/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.cdc.internal.adapters.pc;

import com.vmware.cis.cdc.internal.adapters.pc.PropertyCollectorFilters;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.fault.NotAuthenticated;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import com.vmware.vim.binding.vmodl.query.InvalidCollectorVersion;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PropertyCollectorFacade {
    private static final Logger _logger = LoggerFactory.getLogger(PropertyCollectorFacade.class);
    private final List<ManagedObject> _monitoredObjects;
    private final PropertyCollector.WaitOptions _waitOptions;
    private final PropertyCollector _propertyCollector;
    private final String _serverGuid;
    private volatile String _lastPcVersion = "";

    PropertyCollectorFacade(VmodlContext vmodlContext, Client vlsiClient, PropertyCollectorFilters pcFiltersFactory, int waitPeriodInSeconds) {
        assert (vmodlContext != null);
        assert (vlsiClient != null);
        assert (pcFiltersFactory != null);
        this._waitOptions = new PropertyCollector.WaitOptions();
        this._waitOptions.setMaxWaitSeconds(Integer.valueOf(waitPeriodInSeconds));
        ArrayList<PropertyCollectorFilters.PropertyCollectorFilter> propertyCollectorFilters = new ArrayList<PropertyCollectorFilters.PropertyCollectorFilter>();
        ServiceInstanceContent serviceInstanceContent = PropertyCollectorFacade.createServiceInstanceContent(vlsiClient);
        this._propertyCollector = PropertyCollectorFacade.connectPropertyCollector(vmodlContext, vlsiClient, serviceInstanceContent, pcFiltersFactory, propertyCollectorFilters);
        this._serverGuid = serviceInstanceContent.getAbout().getInstanceUuid();
        this._monitoredObjects = new ArrayList<ManagedObject>(propertyCollectorFilters.size());
        for (PropertyCollectorFilters.PropertyCollectorFilter propertyCollectorFilter : propertyCollectorFilters) {
            this._monitoredObjects.add(propertyCollectorFilter.getMonitoredObject());
        }
        this._lastPcVersion = "";
    }

    PropertyCollectorUpdates waitForUpdates(String version) throws InvalidCollectorVersion {
        Validate.notNull((Object)version, (String)"Wait for updates version must not be null");
        ArrayList<PropertyCollector.FilterUpdate> pcUpdates = new ArrayList<PropertyCollector.FilterUpdate>();
        String newVersion = "";
        try {
            PropertyCollector.UpdateSet updateSet = this._propertyCollector.waitForUpdatesEx(version, this._waitOptions);
            if (updateSet == null) {
                return new PropertyCollectorUpdates(version, Collections.emptyList());
            }
            pcUpdates.addAll(Arrays.asList(updateSet.getFilterSet()));
            newVersion = updateSet.getVersion();
            if (Boolean.TRUE.equals(updateSet.getTruncated())) {
                PropertyCollectorUpdates moreUpdates = this.waitForUpdates(newVersion);
                pcUpdates.addAll(moreUpdates.getUpdates());
                newVersion = moreUpdates.getVersion();
            }
        }
        catch (ManagedObjectNotFound monf) {
            if ("PropertyCollector".equals(monf.getObj().getType())) {
                throw new PropertyCollectorSessionException("Wait for updates stopped, PropertyCollector destroyed.");
            }
        }
        catch (NotAuthenticated na) {
            throw new PropertyCollectorSessionException("VCenter server session not authenticated, waiting for reconnect.");
        }
        catch (UnexpectedStatusCodeException usce) {
            int statusCode = usce.getStatusCode();
            if (statusCode == 503) {
                _logger.warn("VCenter server is not available, retrying wait for updates.");
            } else {
                String msg = "HTTP error {} has occurred while waiting for updates: ";
                if (_logger.isDebugEnabled()) {
                    _logger.debug(msg, (Object)statusCode, (Object)usce);
                } else {
                    _logger.warn(msg + usce.getMessage(), (Object)statusCode);
                }
            }
            throw usce;
        }
        this._lastPcVersion = newVersion;
        return new PropertyCollectorUpdates(newVersion, pcUpdates);
    }

    String getVersion() {
        _logger.debug("[PC] Get version, having current version [{}]", (Object)this._lastPcVersion);
        this._lastPcVersion = PropertyCollectorFacade.skipAllChanges(this._propertyCollector, this._lastPcVersion);
        return this._lastPcVersion;
    }

    String getServerGuid() {
        return this._serverGuid;
    }

    List<ManagedObject> getMonitoredObjects() {
        return this._monitoredObjects;
    }

    void destroy() {
        try {
            if (this._propertyCollector != null) {
                this._propertyCollector.cancelWaitForUpdates();
                this._propertyCollector.destroy();
            }
        }
        catch (Exception e) {
            String msg = "Error has occurred while cleaning up PropertyCollector state: ";
            if (_logger.isDebugEnabled()) {
                _logger.debug(msg, (Throwable)e);
            }
            _logger.warn(msg + e.getMessage());
        }
    }

    private static PropertyCollector connectPropertyCollector(VmodlContext vmodlContext, Client vlsiClient, ServiceInstanceContent serviceInstanceContent, PropertyCollectorFilters pcFiltersFactory, List<PropertyCollectorFilters.PropertyCollectorFilter> propertyCollectorFilters) {
        propertyCollectorFilters.addAll(pcFiltersFactory.createFilters(vmodlContext, vlsiClient, serviceInstanceContent));
        ArrayList<PropertyCollector.FilterSpec> filterSpecs = new ArrayList<PropertyCollector.FilterSpec>(propertyCollectorFilters.size());
        for (PropertyCollectorFilters.PropertyCollectorFilter pcFilter : propertyCollectorFilters) {
            filterSpecs.add(pcFilter.getFilterSpec());
        }
        PropertyCollector propertyCollector = PropertyCollectorFacade.createPropertyCollector(vlsiClient, serviceInstanceContent, filterSpecs);
        return propertyCollector;
    }

    private static String skipAllChanges(PropertyCollector propertyCollector, String currentVersion) throws IllegalStateException {
        assert (propertyCollector != null);
        assert (currentVersion != null);
        try {
            PropertyCollector.WaitOptions initWaitOptions = new PropertyCollector.WaitOptions();
            initWaitOptions.setMaxWaitSeconds(Integer.valueOf(0));
            String version = currentVersion;
            PropertyCollector.UpdateSet updateSet = propertyCollector.waitForUpdatesEx(version, initWaitOptions);
            if (updateSet == null) {
                return version;
            }
            version = updateSet.getVersion();
            while (Boolean.TRUE.equals(updateSet.getTruncated()) && (updateSet = propertyCollector.waitForUpdatesEx(version, initWaitOptions)) != null) {
                version = updateSet.getVersion();
            }
            return version;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error has occurred while skipping changes in PropertyCollector.", e);
        }
    }

    private static PropertyCollector createPropertyCollector(Client vlsiClient, ServiceInstanceContent serviceInstanceContent, List<PropertyCollector.FilterSpec> filterSpecs) throws IllegalStateException {
        assert (vlsiClient != null);
        assert (serviceInstanceContent != null);
        assert (filterSpecs != null);
        assert (!filterSpecs.isEmpty());
        PropertyCollector propertyCollector = PropertyCollectorFacade.createPropertyCollector(vlsiClient, serviceInstanceContent);
        try {
            for (PropertyCollector.FilterSpec filterSpec : filterSpecs) {
                propertyCollector.createFilter(filterSpec, true);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error has occurred while creating filters for updates.", e);
        }
        return propertyCollector;
    }

    private static ServiceInstanceContent createServiceInstanceContent(Client vlsiClient) {
        assert (vlsiClient != null);
        try {
            ManagedObjectReference siRef = new ManagedObjectReference("ServiceInstance", "ServiceInstance");
            ServiceInstance serviceInstance = PropertyCollectorFacade.createStub(vlsiClient, ServiceInstance.class, siRef);
            return serviceInstance.getContent();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error has occurred while preparing ServiceInstanceContent.", e);
        }
    }

    private static PropertyCollector createPropertyCollector(Client vlsiClient, ServiceInstanceContent serviceInstanceContent) {
        assert (vlsiClient != null);
        assert (serviceInstanceContent != null);
        try {
            PropertyCollector rootPC = PropertyCollectorFacade.createStub(vlsiClient, PropertyCollector.class, serviceInstanceContent.getPropertyCollector());
            ManagedObjectReference pcRef = rootPC.createPropertyCollector();
            return PropertyCollectorFacade.createStub(vlsiClient, PropertyCollector.class, pcRef);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error has occurred while preparing PropertyCollector.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends ManagedObject> T createStub(Client vlsiClient, Class<T> stubBindingClass, ManagedObjectReference ref) {
        assert (vlsiClient != null);
        assert (stubBindingClass != null);
        assert (ref != null);
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(PropertyCollectorFacade.class.getClassLoader());
        try {
            ManagedObject managedObject = vlsiClient.createStub(stubBindingClass, ref);
            return (T)managedObject;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }

    static final class PropertyCollectorSessionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        PropertyCollectorSessionException(String cause) {
            super(String.format("Error has occurred while polling PropertyCollector for updates: %s", cause));
        }
    }

    static final class PropertyCollectorUpdates {
        private final String _version;
        private final List<PropertyCollector.FilterUpdate> _updates;

        PropertyCollectorUpdates(String version, List<PropertyCollector.FilterUpdate> updates) {
            assert (version != null);
            assert (updates != null);
            this._version = version;
            this._updates = updates;
        }

        String getVersion() {
            return this._version;
        }

        List<PropertyCollector.FilterUpdate> getUpdates() {
            return this._updates;
        }
    }
}

