/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.cdc.internal.adapters.pc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.vmware.cis.cdc.internal.adapters.pc.PropertyCollectorFacade;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.profile.cluster.ProfileManager;
import com.vmware.vim.binding.vim.view.ContainerView;
import com.vmware.vim.binding.vim.view.ListView;
import com.vmware.vim.binding.vim.view.ViewManager;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PropertyCollectorFilters {
    private static final Logger _logger = LoggerFactory.getLogger(PropertyCollectorFilters.class);
    private static final Map<String, List<String>> VIEW_MONITORED_PROPERTIES_BY_TYPE = ImmutableMap.builder().put((Object)"ManagedEntity", (Object)ImmutableList.builder().add((Object)"availableField").add((Object)"customValue").add((Object)"name").add((Object)"parent").add((Object)"tag").add((Object)"value").build()).put((Object)"ComputeResource", (Object)ImmutableList.builder().add((Object)"configurationEx").add((Object)"datastore").add((Object)"host").add((Object)"network").add((Object)"resourcePool").add((Object)"summary").build()).put((Object)"ClusterComputeResource", (Object)ImmutableList.builder().add((Object)"actionHistory").add((Object)"migrationHistory").build()).put((Object)"Datacenter", (Object)ImmutableList.builder().add((Object)"configuration").add((Object)"datastore").add((Object)"datastoreFolder").add((Object)"hostFolder").add((Object)"network").add((Object)"networkFolder").add((Object)"vmFolder").build()).put((Object)"Datastore", (Object)ImmutableList.builder().add((Object)"capability").add((Object)"host").add((Object)"info").add((Object)"iormConfiguration").add((Object)"summary").add((Object)"vm").build()).put((Object)"DistributedVirtualSwitch", (Object)ImmutableList.builder().add((Object)"capability").add((Object)"config").add((Object)"portgroup").add((Object)"runtime").add((Object)"summary").build()).put((Object)"VmwareDistributedVirtualSwitch", (Object)ImmutableList.builder().add((Object)"capability").build()).put((Object)"Folder", (Object)ImmutableList.builder().add((Object)"childEntity").add((Object)"childType").build()).put((Object)"StoragePod", (Object)ImmutableList.builder().add((Object)"podStorageDrsEntry").add((Object)"summary").build()).put((Object)"HostSystem", (Object)ImmutableList.builder().add((Object)"capability").add((Object)"config").add((Object)"datastore").add((Object)"hardware").add((Object)"licensableResource").add((Object)"network").add((Object)"runtime").add((Object)"summary").add((Object)"systemResources").add((Object)"vm").build()).put((Object)"Network", (Object)ImmutableList.builder().add((Object)"host").add((Object)"name").add((Object)"summary").add((Object)"vm").build()).put((Object)"DistributedVirtualPortgroup", (Object)ImmutableList.builder().add((Object)"config").add((Object)"key").add((Object)"portKeys").build()).put((Object)"OpaqueNetwork", (Object)ImmutableList.builder().add((Object)"name").build()).put((Object)"ResourcePool", (Object)ImmutableList.builder().add((Object)"childConfiguration").add((Object)"config").add((Object)"owner").add((Object)"resourcePool").add((Object)"runtime").add((Object)"summary").add((Object)"vm").build()).put((Object)"VirtualApp", (Object)ImmutableList.builder().add((Object)"datastore").add((Object)"network").add((Object)"parentFolder").add((Object)"parentVApp").add((Object)"vAppConfig").build()).put((Object)"VirtualMachine", (Object)ImmutableList.builder().add((Object)"capability").add((Object)"config").add((Object)"datastore").add((Object)"guest").add((Object)"guestHeartbeatStatus").add((Object)"network").add((Object)"parentVApp").add((Object)"resourcePool").add((Object)"rootSnapshot").add((Object)"runtime").add((Object)"snapshot").add((Object)"summary").build()).build();
    private static final Map<String, List<String>> HOST_PROFILE_MANAGER_MONITORED_PROPERTIES_BY_TYPE = ImmutableMap.builder().put((Object)"Profile", (Object)ImmutableList.builder().add((Object)"complianceStatus").add((Object)"config").add((Object)"description").add((Object)"entity").add((Object)"name").build()).put((Object)"HostProfile", (Object)ImmutableList.builder().add((Object)"referenceHost").build()).build();
    private static final Map<String, List<String>> CLUSTER_PROFILE_MANAGER_MONITORED_PROPERTIES_BY_TYPE = ImmutableMap.builder().put((Object)"Profile", (Object)ImmutableList.builder().add((Object)"complianceStatus").add((Object)"config").add((Object)"description").add((Object)"entity").add((Object)"name").build()).build();
    private final List<FilterFactory> _filterFactories;

    private PropertyCollectorFilters(List<FilterFactory> filterFactories) {
        assert (filterFactories != null);
        if (filterFactories.isEmpty()) {
            throw new IllegalArgumentException("No PropertyCollector filters configured.");
        }
        this._filterFactories = filterFactories;
    }

    List<PropertyCollectorFilter> createFilters(VmodlContext vmodlContext, Client vlsiClient, ServiceInstanceContent serviceInstanceContent) {
        assert (vlsiClient != null);
        assert (serviceInstanceContent != null);
        ArrayList<PropertyCollectorFilter> pcFilters = new ArrayList<PropertyCollectorFilter>(this._filterFactories.size());
        for (FilterFactory pcFilterFactory : this._filterFactories) {
            pcFilters.add(pcFilterFactory.createFilter(vmodlContext, vlsiClient, serviceInstanceContent));
        }
        return pcFilters;
    }

    private static PropertyCollector.FilterSpec createFilterSpec(VmodlContext vmodlContext, ManagedObject monitoredObject, String monitoredType, String monitoredProperty, Map<String, List<String>> propertiesByType) {
        assert (vmodlContext != null);
        assert (monitoredObject != null);
        assert (monitoredType != null);
        assert (monitoredProperty != null);
        assert (propertiesByType != null);
        assert (!propertiesByType.isEmpty());
        PropertyCollector.FilterSpec fSpec = null;
        try {
            String viewName = "";
            ArrayList<PropertyCollector.PropertySpec> propSpecs = new ArrayList<PropertyCollector.PropertySpec>();
            for (Map.Entry<String, List<String>> propsByType : propertiesByType.entrySet()) {
                String type = propsByType.getKey();
                List<String> props = propsByType.getValue();
                assert (!props.isEmpty());
                viewName = viewName + "_" + type;
                TypeName typeName = PropertyCollectorFilters.typeNameFromType(vmodlContext, type);
                PropertyCollector.PropertySpec propSpec = new PropertyCollector.PropertySpec(typeName, Boolean.valueOf(false), props.toArray(new String[props.size()]));
                propSpecs.add(propSpec);
            }
            PropertyCollector.TraversalSpec tSpec = new PropertyCollector.TraversalSpec();
            tSpec.setName("spec" + viewName);
            tSpec.setType(PropertyCollectorFilters.typeNameFromType(vmodlContext, monitoredType));
            tSpec.setPath(monitoredProperty);
            tSpec.setSkip(Boolean.valueOf(false));
            PropertyCollector.ObjectSpec objSpec = new PropertyCollector.ObjectSpec(monitoredObject._getRef(), Boolean.valueOf(true), new PropertyCollector.SelectionSpec[]{tSpec});
            fSpec = new PropertyCollector.FilterSpec(propSpecs.toArray(new PropertyCollector.PropertySpec[propSpecs.size()]), new PropertyCollector.ObjectSpec[]{objSpec}, Boolean.valueOf(false));
        }
        catch (Exception e) {
            _logger.error("Error has occurred while preparing FilterSpec.", (Throwable)e);
        }
        return fSpec;
    }

    private static TypeName typeNameFromType(VmodlContext vmodlContext, String type) {
        assert (vmodlContext != null);
        assert (type != null);
        return vmodlContext.getVmodlTypeMap().getVmodlType(type).getTypeName();
    }

    private static final class ListViewFilterFactory
    implements FilterFactory {
        private final Map<String, List<String>> _monitoredPropertiesByType;
        private final Collection<ManagedObjectReference> _resourcesToMonitor;

        private ListViewFilterFactory(Map<String, List<String>> monitoredPropertiesByType, Collection<ManagedObjectReference> resourcesToMonitor) {
            assert (monitoredPropertiesByType != null);
            assert (resourcesToMonitor != null);
            this._monitoredPropertiesByType = monitoredPropertiesByType;
            this._resourcesToMonitor = resourcesToMonitor;
        }

        @Override
        public PropertyCollectorFilter createFilter(VmodlContext vmodlContext, Client vlsiClient, ServiceInstanceContent serviceInstanceContent) {
            assert (vmodlContext != null);
            assert (vlsiClient != null);
            assert (serviceInstanceContent != null);
            ListView listView = this.createListView(vlsiClient, serviceInstanceContent);
            PropertyCollector.FilterSpec filterSpec = PropertyCollectorFilters.createFilterSpec(vmodlContext, (ManagedObject)listView, "ListView", "view", this._monitoredPropertiesByType);
            return new PropertyCollectorFilter((ManagedObject)listView, filterSpec);
        }

        private ListView createListView(Client vlsiClient, ServiceInstanceContent serviceInstanceContent) {
            ListView listView = null;
            try {
                ViewManager viewManager = PropertyCollectorFacade.createStub(vlsiClient, ViewManager.class, serviceInstanceContent.getViewManager());
                ManagedObjectReference lvRef = viewManager.createListView(this._resourcesToMonitor.toArray(new ManagedObjectReference[this._resourcesToMonitor.size()]));
                listView = PropertyCollectorFacade.createStub(vlsiClient, ListView.class, lvRef);
            }
            catch (Exception e) {
                _logger.error(String.format("Error has occurred while preparing ListView for resources '%s'.", this._resourcesToMonitor), (Throwable)e);
            }
            return listView;
        }
    }

    private static final class ClusterProfileManagerFilterFactory
    implements FilterFactory {
        private final Map<String, List<String>> _monitoredPropertiesByType;

        private ClusterProfileManagerFilterFactory(Map<String, List<String>> monitoredPropertiesByType) {
            assert (monitoredPropertiesByType != null);
            this._monitoredPropertiesByType = monitoredPropertiesByType;
        }

        @Override
        public PropertyCollectorFilter createFilter(VmodlContext vmodlContext, Client vlsiClient, ServiceInstanceContent serviceInstanceContent) {
            assert (vmodlContext != null);
            assert (vlsiClient != null);
            assert (serviceInstanceContent != null);
            ProfileManager clusterProfileManager = ClusterProfileManagerFilterFactory.createClusterProfileManager(vlsiClient, serviceInstanceContent);
            PropertyCollector.FilterSpec filterSpec = PropertyCollectorFilters.createFilterSpec(vmodlContext, (ManagedObject)clusterProfileManager, "ClusterProfileManager", "profile", this._monitoredPropertiesByType);
            return new PropertyCollectorFilter((ManagedObject)clusterProfileManager, filterSpec);
        }

        private static ProfileManager createClusterProfileManager(Client vlsiClient, ServiceInstanceContent serviceInstanceContent) {
            ProfileManager clusterProfileManager = null;
            try {
                clusterProfileManager = PropertyCollectorFacade.createStub(vlsiClient, ProfileManager.class, serviceInstanceContent.getClusterProfileManager());
            }
            catch (Exception e) {
                _logger.error("Error has occurred while preparing ClusterProfileManager.", (Throwable)e);
            }
            return clusterProfileManager;
        }
    }

    private static final class HostProfileManagerFilterFactory
    implements FilterFactory {
        private final Map<String, List<String>> _monitoredPropertiesByType;

        private HostProfileManagerFilterFactory(Map<String, List<String>> monitoredPropertiesByType) {
            assert (monitoredPropertiesByType != null);
            this._monitoredPropertiesByType = monitoredPropertiesByType;
        }

        @Override
        public PropertyCollectorFilter createFilter(VmodlContext vmodlContext, Client vlsiClient, ServiceInstanceContent serviceInstanceContent) {
            assert (vmodlContext != null);
            assert (vlsiClient != null);
            assert (serviceInstanceContent != null);
            com.vmware.vim.binding.vim.profile.host.ProfileManager hostProfileManager = HostProfileManagerFilterFactory.createHostProfileManager(vlsiClient, serviceInstanceContent);
            PropertyCollector.FilterSpec filterSpec = PropertyCollectorFilters.createFilterSpec(vmodlContext, (ManagedObject)hostProfileManager, "HostProfileManager", "profile", this._monitoredPropertiesByType);
            return new PropertyCollectorFilter((ManagedObject)hostProfileManager, filterSpec);
        }

        private static com.vmware.vim.binding.vim.profile.host.ProfileManager createHostProfileManager(Client vlsiClient, ServiceInstanceContent serviceInstanceContent) {
            com.vmware.vim.binding.vim.profile.host.ProfileManager hostProfileManager = null;
            try {
                hostProfileManager = PropertyCollectorFacade.createStub(vlsiClient, com.vmware.vim.binding.vim.profile.host.ProfileManager.class, serviceInstanceContent.getHostProfileManager());
            }
            catch (Exception e) {
                _logger.error("Error has occurred while preparing HostProfileManager.", (Throwable)e);
            }
            return hostProfileManager;
        }
    }

    private static final class ContainerViewFilterFactory
    implements FilterFactory {
        private final Map<String, List<String>> _monitoredPropertiesByType;

        private ContainerViewFilterFactory(Map<String, List<String>> monitoredPropertiesByType) {
            assert (monitoredPropertiesByType != null);
            this._monitoredPropertiesByType = monitoredPropertiesByType;
        }

        @Override
        public PropertyCollectorFilter createFilter(VmodlContext vmodlContext, Client vlsiClient, ServiceInstanceContent serviceInstanceContent) {
            assert (vmodlContext != null);
            assert (vlsiClient != null);
            assert (serviceInstanceContent != null);
            ContainerView containerView = ContainerViewFilterFactory.createContainerView(vmodlContext, vlsiClient, serviceInstanceContent, this._monitoredPropertiesByType.keySet());
            PropertyCollector.FilterSpec filterSpec = PropertyCollectorFilters.createFilterSpec(vmodlContext, (ManagedObject)containerView, "ContainerView", "view", this._monitoredPropertiesByType);
            return new PropertyCollectorFilter((ManagedObject)containerView, filterSpec);
        }

        private static ContainerView createContainerView(VmodlContext vmodlContext, Client vlsiClient, ServiceInstanceContent serviceInstanceContent, Set<String> types) {
            assert (types != null);
            assert (!types.isEmpty());
            ContainerView containerView = null;
            try {
                ViewManager viewManager = PropertyCollectorFacade.createStub(vlsiClient, ViewManager.class, serviceInstanceContent.getViewManager());
                ArrayList<TypeName> typeNames = new ArrayList<TypeName>();
                for (String type : types) {
                    TypeName typeName = PropertyCollectorFilters.typeNameFromType(vmodlContext, type);
                    if (typeName == null) continue;
                    typeNames.add(typeName);
                }
                ManagedObjectReference cvRef = viewManager.createContainerView(serviceInstanceContent.getRootFolder(), typeNames.toArray(new TypeName[typeNames.size()]), true);
                containerView = PropertyCollectorFacade.createStub(vlsiClient, ContainerView.class, cvRef);
            }
            catch (Exception e) {
                _logger.error(String.format("Error has occurred while preparing ContainerView for types '%s'.", types), (Throwable)e);
            }
            return containerView;
        }
    }

    private static interface FilterFactory {
        public PropertyCollectorFilter createFilter(VmodlContext var1, Client var2, ServiceInstanceContent var3);
    }

    static final class Builder {
        private ContainerViewFilterFactory _cvFilterFactory;
        private HostProfileManagerFilterFactory _hpmFilterFactory;
        private ClusterProfileManagerFilterFactory _cpmFilterFactory;
        private ListViewFilterFactory _lvFilterFactory;

        Builder() {
        }

        public Builder withContainerViewFilter() {
            this._cvFilterFactory = new ContainerViewFilterFactory(VIEW_MONITORED_PROPERTIES_BY_TYPE);
            return this;
        }

        public Builder withHostProfileManagerFilter() {
            this._hpmFilterFactory = new HostProfileManagerFilterFactory(HOST_PROFILE_MANAGER_MONITORED_PROPERTIES_BY_TYPE);
            return this;
        }

        public Builder withClusterProfileManagerFilter() {
            this._cpmFilterFactory = new ClusterProfileManagerFilterFactory(CLUSTER_PROFILE_MANAGER_MONITORED_PROPERTIES_BY_TYPE);
            return this;
        }

        public Builder withListViewFilter(Collection<ManagedObjectReference> resourcesToMonitor) {
            this._lvFilterFactory = new ListViewFilterFactory(VIEW_MONITORED_PROPERTIES_BY_TYPE, resourcesToMonitor);
            return this;
        }

        public PropertyCollectorFilters build() {
            ArrayList<FilterFactory> filterFactories = new ArrayList<FilterFactory>();
            if (this._cvFilterFactory != null) {
                filterFactories.add(this._cvFilterFactory);
            }
            if (this._hpmFilterFactory != null) {
                filterFactories.add(this._hpmFilterFactory);
            }
            if (this._cpmFilterFactory != null) {
                filterFactories.add(this._cpmFilterFactory);
            }
            if (this._lvFilterFactory != null) {
                filterFactories.add(this._lvFilterFactory);
            }
            return new PropertyCollectorFilters(filterFactories);
        }
    }

    static final class PropertyCollectorFilter {
        private final ManagedObject _monitoredObject;
        private final PropertyCollector.FilterSpec _filterSpec;

        PropertyCollectorFilter(ManagedObject monitoredObject, PropertyCollector.FilterSpec filterSpec) {
            assert (monitoredObject != null);
            assert (filterSpec != null);
            this._monitoredObject = monitoredObject;
            this._filterSpec = filterSpec;
        }

        ManagedObject getMonitoredObject() {
            return this._monitoredObject;
        }

        PropertyCollector.FilterSpec getFilterSpec() {
            return this._filterSpec;
        }
    }
}

