/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.cdc.internal.adapters.pc;

import com.vmware.cdc.ChangeEvent;
import com.vmware.cdc.ChangeList;
import com.vmware.cdc.exception.SequenceExpiredException;
import com.vmware.cdc.internal.ImmutableChangeEvent;
import com.vmware.cdc.internal.ImmutableChangeList;
import com.vmware.cis.cdc.internal.adapters.pc.PropertyCollectorChangeLog;
import com.vmware.cis.cdc.internal.adapters.pc.PropertyCollectorFacade;
import com.vmware.cis.cdc.internal.adapters.pc.PropertyCollectorFilters;
import com.vmware.cis.data.internal.adapters.vmomi.VmomiAuthenticator;
import com.vmware.cis.data.internal.adapters.vmomi.VmomiSession;
import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.vim.binding.vim.fault.NotAuthenticated;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.common.ProtocolBinding;
import com.vmware.vim.vmomi.client.common.Session;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SessionPropertyCollectorChangeLog
implements PropertyCollectorChangeLog {
    private static Logger _logger = LoggerFactory.getLogger(SessionPropertyCollectorChangeLog.class);
    private static final int DEFAULT_PC_WAIT_PERIOD_IN_SEC = 0;
    private static final String SPECIAL_PC_VERSION_TOKEN = "@";
    private static final String INITIAL_PC_VERSION = "";
    private static final int MAX_PC_NON_FATAL_ERROR_RETRY_ATTEMPTS = 5;
    private int _currentNonFatalAttempt = 0;
    private final VmomiAuthenticator _authenticator;
    private final AuthenticationTokenSource _credentials;
    private final VmodlContext _vmodlContext;
    private final Client _vlsiClient;
    private final AtomicReference<VmomiSession> _vlsiSession = new AtomicReference();
    private final PropertyCollectorFilters _pcFiltersFactory;
    private PropertyCollectorFacade _propertyCollectorFacade;

    SessionPropertyCollectorChangeLog(VmomiAuthenticator authenticator, AuthenticationTokenSource credentials, VmodlContext vmodlContext, Client vlsiClient, PropertyCollectorFilters pcFiltersFactory) {
        assert (authenticator != null);
        assert (credentials != null);
        assert (vmodlContext != null);
        assert (vlsiClient != null);
        assert (pcFiltersFactory != null);
        this._authenticator = authenticator;
        this._credentials = credentials;
        this._vmodlContext = vmodlContext;
        this._vlsiClient = vlsiClient;
        this._pcFiltersFactory = pcFiltersFactory;
    }

    public synchronized ChangeList getChanges(String sequenceToken) throws SequenceExpiredException {
        PropertyCollectorFacade.PropertyCollectorUpdates pcUpdates;
        _logger.debug("[PC] Get changes with sequence [{}]", (Object)sequenceToken);
        PropertyCollectorFacade pcFacade = this.checkCreatePropertyCollectorFacade();
        try {
            pcUpdates = this.getPcUpdates(pcFacade, SPECIAL_PC_VERSION_TOKEN.equals(sequenceToken) ? INITIAL_PC_VERSION : sequenceToken);
        }
        catch (PropertyCollectorFacade.PropertyCollectorSessionException pcse) {
            _logger.error("Error while waiting for updates from PropertyCollector.", (Throwable)pcse);
            this.close();
            throw new SequenceExpiredException(sequenceToken);
        }
        String newSequenceToken = pcUpdates.getVersion();
        newSequenceToken = INITIAL_PC_VERSION.equals(newSequenceToken) ? SPECIAL_PC_VERSION_TOKEN : newSequenceToken;
        List<ChangeEvent> changes = SessionPropertyCollectorChangeLog.fromPcUpdates(pcUpdates.getUpdates());
        _logger.debug("[PC] Changes requested by token [{}], returned [{}] number of changes with token [{}]", new Object[]{sequenceToken, changes.size(), newSequenceToken});
        _logger.trace("[PC] Returned changes: {}", changes);
        return new ImmutableChangeList(newSequenceToken, changes);
    }

    private PropertyCollectorFacade.PropertyCollectorUpdates getPcUpdates(PropertyCollectorFacade pcFacade, String version) {
        PropertyCollectorFacade.PropertyCollectorUpdates pcUpdates = null;
        boolean retryRequest = false;
        try {
            pcUpdates = pcFacade.waitForUpdates(version);
        }
        catch (PropertyCollectorFacade.PropertyCollectorSessionException pcse) {
            throw pcse;
        }
        catch (Exception e) {
            String msg = "Non-fatal error while waiting for updates from PropertyCollector: ";
            if (_logger.isDebugEnabled()) {
                _logger.debug(msg, (Throwable)e);
            } else {
                _logger.warn(msg + e.getMessage());
            }
            retryRequest = true;
        }
        if (retryRequest) {
            if (this._currentNonFatalAttempt > 5) {
                throw new PropertyCollectorFacade.PropertyCollectorSessionException("Reached maximum attempts to retry request on non-fatal error.");
            }
            ++this._currentNonFatalAttempt;
            return new PropertyCollectorFacade.PropertyCollectorUpdates(version, Collections.emptyList());
        }
        this._currentNonFatalAttempt = 0;
        return pcUpdates;
    }

    public synchronized String getCurrentSequence() {
        PropertyCollectorFacade pcFacade = this.checkCreatePropertyCollectorFacade();
        String currSequence = pcFacade.getVersion();
        currSequence = INITIAL_PC_VERSION.equals(currSequence) ? SPECIAL_PC_VERSION_TOKEN : currSequence;
        _logger.debug("[PC] Get current sequence: {}", (Object)currSequence);
        return currSequence;
    }

    @Override
    public synchronized void close() {
        PropertyCollectorFacade pcFacade = this._propertyCollectorFacade;
        if (pcFacade != null) {
            pcFacade.destroy();
            this._propertyCollectorFacade = null;
        }
        this.closeConnection();
    }

    private PropertyCollectorFacade checkCreatePropertyCollectorFacade() {
        PropertyCollectorFacade pcFacade = this._propertyCollectorFacade;
        if (pcFacade != null) {
            return pcFacade;
        }
        VmomiSession vlsiSession = SessionPropertyCollectorChangeLog.login(this._authenticator, this._credentials, this._vlsiClient.getBinding());
        this._vlsiSession.set(vlsiSession);
        this._propertyCollectorFacade = pcFacade = new PropertyCollectorFacade(this._vmodlContext, this._vlsiClient, this._pcFiltersFactory, 0);
        return pcFacade;
    }

    private static VmomiSession login(VmomiAuthenticator authenticator, AuthenticationTokenSource credentials, ProtocolBinding binding) {
        VmomiSession session = null;
        try {
            session = authenticator.login(credentials);
            assert (session != null) : authenticator + " for VCenter server returned null session.";
            Session vlsiSession = binding.createSession(session.getSessionCookie());
            binding.setSession(vlsiSession);
        }
        catch (UnexpectedStatusCodeException usce) {
            if (usce.getStatusCode() == 503) {
                _logger.warn("VCenter server is unavailable.");
            }
        }
        catch (RuntimeException re) {
            _logger.warn("Login to VCenter server failed.");
        }
        if (session == null) {
            throw new IllegalStateException("Could not connect to VCenter server.");
        }
        return session;
    }

    private void closeConnection() {
        SessionPropertyCollectorChangeLog.closeQuietly(this._vlsiSession.get());
        SessionPropertyCollectorChangeLog.closeQuietly(this._vlsiClient);
    }

    private static void closeQuietly(Client vlsiClient) {
        try {
            if (vlsiClient != null) {
                vlsiClient.shutdown();
            }
        }
        catch (RuntimeException ex) {
            String msg = "Error while closing VLSI client: ";
            if (_logger.isDebugEnabled()) {
                _logger.debug(msg, (Throwable)ex);
            }
            _logger.warn(msg + ex.getMessage());
        }
    }

    private static void closeQuietly(VmomiSession vmomiSession) {
        try {
            if (vmomiSession != null) {
                vmomiSession.logout();
            }
        }
        catch (NotAuthenticated ignore) {
        }
        catch (RuntimeException ex) {
            String msg = "Error while closing VMOMI session: ";
            if (_logger.isDebugEnabled()) {
                _logger.debug(msg, (Throwable)ex);
            }
            _logger.warn(msg + ex.getMessage());
        }
    }

    private static List<ChangeEvent> fromPcUpdates(List<PropertyCollector.FilterUpdate> pcFilterUpdates) {
        assert (pcFilterUpdates != null);
        if (pcFilterUpdates.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ChangeEvent> pcChanges = new ArrayList<ChangeEvent>();
        for (PropertyCollector.FilterUpdate filterUpdate : pcFilterUpdates) {
            if (filterUpdate.getObjectSet() == null) continue;
            for (PropertyCollector.ObjectUpdate objUpdate : filterUpdate.getObjectSet()) {
                if (objUpdate == null || objUpdate.getObj() == null || PropertyCollector.ObjectUpdate.Kind.modify.equals((Object)objUpdate.getKind()) && ArrayUtils.isEmpty((Object[])objUpdate.getChangeSet())) continue;
                pcChanges.add(SessionPropertyCollectorChangeLog.fromPcUpdate(objUpdate));
            }
        }
        return pcChanges;
    }

    private static ChangeEvent fromPcUpdate(PropertyCollector.ObjectUpdate pcObjectUpdate) {
        assert (pcObjectUpdate != null);
        ManagedObjectReference changedResource = pcObjectUpdate.getObj();
        switch (pcObjectUpdate.getKind()) {
            case enter: {
                _logger.trace("CDC by PropertyCollector spotted CREATE change for resource [{}].", (Object)pcObjectUpdate.getObj());
                return new ImmutableChangeEvent(ChangeEvent.ChangeKind.CREATE, (Object)changedResource, changedResource.getType());
            }
            case modify: {
                ArrayList<String> changedProperties = new ArrayList<String>(pcObjectUpdate.getChangeSet().length);
                for (PropertyCollector.Change propChange : pcObjectUpdate.getChangeSet()) {
                    changedProperties.add(propChange.getName());
                }
                _logger.trace("CDC by PropertyCollector spotted UPDATE change for resource [{}] and properties [{}].", (Object)pcObjectUpdate.getObj(), changedProperties);
                return new ImmutableChangeEvent(ChangeEvent.ChangeKind.UPDATE, (Object)changedResource, changedResource.getType(), changedProperties);
            }
            case leave: {
                _logger.trace("CDC by PropertyCollector spotted DELETE change for resource [{}].", (Object)pcObjectUpdate.getObj());
                return new ImmutableChangeEvent(ChangeEvent.ChangeKind.DELETE, (Object)changedResource, changedResource.getType());
            }
        }
        throw new IllegalStateException("Unsupported change kind: " + pcObjectUpdate.getKind());
    }
}

