/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.cdc.internal.adapters.pc;

import com.vmware.cis.cdc.internal.adapters.pc.PropertyCollectorChangeLog;
import com.vmware.cis.cdc.internal.adapters.pc.PropertyCollectorChangeLogFactory;
import com.vmware.cis.cdc.internal.adapters.pc.PropertyCollectorFilters;
import com.vmware.cis.cdc.internal.adapters.pc.SessionPropertyCollectorChangeLog;
import com.vmware.cis.cdc.internal.adapters.vcenter.ChangeLogConnection;
import com.vmware.cis.cdc.internal.adapters.vcenter.NamedChangeLog;
import com.vmware.cis.data.internal.adapters.lookup.ServiceEndpointInfo;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VcVmomiAuthenticator;
import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.vim.binding.vim.version.internal.versions;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.net.URI;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SessionPropertyCollectorChangeLogFactory
implements PropertyCollectorChangeLogFactory {
    private static final Logger _logger = LoggerFactory.getLogger(SessionPropertyCollectorChangeLogFactory.class);
    private final VmodlContext _vmodlContext;
    private final boolean _useUnstableVersion;
    private final PropertyCollectorFilters _pcFiltersFactory;

    SessionPropertyCollectorChangeLogFactory(VmodlContext vmodlContext, boolean useUnstableVersion, Collection<ManagedObjectReference> monitoredObjects) {
        assert (vmodlContext != null);
        assert (monitoredObjects != null);
        this._vmodlContext = vmodlContext;
        this._useUnstableVersion = useUnstableVersion;
        this._pcFiltersFactory = new PropertyCollectorFilters.Builder().withListViewFilter(monitoredObjects).build();
    }

    @Override
    public Collection<ChangeLogConnection> connect(Collection<ServiceEndpointInfo> vpxdEndpoints, AuthenticationTokenSource credentials) {
        assert (vpxdEndpoints != null);
        assert (credentials != null);
        if (vpxdEndpoints.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ChangeLogConnection> pcChangeLogs = new ArrayList<ChangeLogConnection>(vpxdEndpoints.size());
        for (ServiceEndpointInfo vpxdEndpoint : vpxdEndpoints) {
            PropertyCollectorChangeLog pcChangeLog;
            try {
                pcChangeLog = this.createPropertyCollectorChangeLog(vpxdEndpoint, credentials);
            }
            catch (Exception e) {
                String msg = "Error while connecting change log at '{}', skipping it: ";
                if (_logger.isDebugEnabled()) {
                    _logger.debug(msg, (Object)vpxdEndpoint.getUrl(), (Object)e);
                    continue;
                }
                _logger.warn(msg + e.getMessage(), (Object)vpxdEndpoint.getUrl());
                continue;
            }
            pcChangeLogs.add(new ChangeLogConnection(new NamedChangeLog(pcChangeLog, vpxdEndpoint.getUrl().toString()), pcChangeLog));
        }
        return pcChangeLogs;
    }

    @Override
    public void close() {
    }

    private PropertyCollectorChangeLog createPropertyCollectorChangeLog(ServiceEndpointInfo vpxdEndpoint, AuthenticationTokenSource credentials) {
        HttpConfiguration pcHttpConfiguration = SessionPropertyCollectorChangeLogFactory.createVlsiConfigForPC(vpxdEndpoint);
        URI vmomiUri = vpxdEndpoint.getUrl();
        VcVmomiAuthenticator authenticator = new VcVmomiAuthenticator(this._vmodlContext, vmomiUri, pcHttpConfiguration);
        Client vlsiClient = SessionPropertyCollectorChangeLogFactory.createVlsiClient(vmomiUri, pcHttpConfiguration, this._vmodlContext, this._useUnstableVersion);
        return new SessionPropertyCollectorChangeLog(authenticator, credentials, this._vmodlContext, vlsiClient, this._pcFiltersFactory);
    }

    private static Client createVlsiClient(URI vmomiUri, HttpConfiguration httpConfiguration, VmodlContext vmodlContext, boolean useUnstableVersion) {
        HttpClientConfiguration clientConfiguration = HttpClientConfiguration.Factory.newInstance();
        clientConfiguration.setHttpConfiguration(httpConfiguration);
        Class version = useUnstableVersion ? versions.VIM_VERSION_NEWEST : versions.VIM_VERSION_STABLE;
        Client vlsiClient = Client.Factory.createClient((URI)vmomiUri, (Class)version, (VmodlContext)vmodlContext, (ClientConfiguration)clientConfiguration);
        return vlsiClient;
    }

    private static HttpConfiguration createVlsiConfigForPC(ServiceEndpointInfo endpoint) {
        assert (endpoint != null);
        HttpConfiguration httpConfig = HttpConfiguration.Factory.newInstance();
        KeyStore trustStore = endpoint.getTrustStore();
        if (trustStore != null) {
            httpConfig.setTrustStore(trustStore);
        }
        httpConfig.setTimeoutMs((int)TimeUnit.HOURS.toMillis(1L));
        return httpConfig;
    }
}

