/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.cdc.internal.adapters.vcenter;

import com.vmware.cdc.ChangeEvent;
import com.vmware.cdc.ChangeList;
import com.vmware.cdc.ChangeLog;
import com.vmware.cdc.exception.SequenceExpiredException;
import com.vmware.cdc.provider.ChangeLogRecorder;
import com.vmware.cdc.provider.ChangeRecorder;
import com.vmware.vapi.CoreException;
import com.vmware.vapi.client.exception.SslException;
import com.vmware.vapi.client.exception.TransportProtocolException;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vim.vmomi.client.exception.ConnectionException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeLogMirror
implements ChangeLog,
AutoCloseable {
    private static final Logger _logger = LoggerFactory.getLogger(ChangeLogMirror.class);
    private static final long BACKOFF_TIME_BETWEEN_UPDATES_MS = 500L;
    private static final int STATE_READY = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_STOPPED = 2;
    private final AtomicInteger _state = new AtomicInteger(0);
    private final String _serviceName;
    private final ChangeLog _mirroredChangeLog;
    private final ChangeLogRecorder _internalChangeLog;
    private final ExecutorService _mirrorExecutor;
    private final boolean _keepPropertiesInMirror;
    private volatile Future<?> _mirrorTask = null;

    public ChangeLogMirror(String serviceName, ChangeLog mirroredChangeLog, int mirrorSize, ExecutorService mirrorExecutor, boolean keepPropertiesInMirror) {
        this._serviceName = serviceName;
        this._internalChangeLog = ChangeLogRecorder.forCircularChangeLog((int)mirrorSize);
        this._mirroredChangeLog = mirroredChangeLog;
        this._mirrorExecutor = mirrorExecutor;
        this._keepPropertiesInMirror = keepPropertiesInMirror;
    }

    public ChangeList getChanges(String sequenceToken) throws SequenceExpiredException {
        this.start();
        return this._internalChangeLog.getLog().getChanges(sequenceToken);
    }

    public String getCurrentSequence() {
        this.start();
        return this._internalChangeLog.getLog().getCurrentSequence();
    }

    @Override
    public void close() throws Exception {
        if (this._state.getAndSet(2) == 1) {
            _logger.debug("Stopping mirroring of ChangeLog {}", (Object)this._serviceName);
            this._mirrorTask.cancel(true);
            this._mirrorTask = null;
        }
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), this._serviceName);
    }

    private void start() {
        if (this._state.compareAndSet(0, 1)) {
            _logger.debug("Starting mirroring of ChangeLog {}", (Object)this._serviceName);
            this._mirrorTask = this._mirrorExecutor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    _logger.info("Started mirroring of ChangeLog {}", (Object)ChangeLogMirror.this._serviceName);
                    try {
                        ChangeLogMirror.this.mirrorChangesTask();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        _logger.info("Stopped mirroring of ChangeLog {}", (Object)ChangeLogMirror.this._serviceName);
                    }
                }

                public String toString() {
                    return ChangeLogMirror.this._serviceName;
                }
            });
        }
    }

    private void mirrorChangesTask() throws InterruptedException {
        String sequenceToken = null;
        int connectionErrors = 0;
        while (this._state.get() == 1 && !Thread.currentThread().isInterrupted()) {
            try {
                if (sequenceToken == null) {
                    _logger.trace("[{}] Sync current sequence.", (Object)this._serviceName);
                    sequenceToken = this._mirroredChangeLog.getCurrentSequence();
                } else {
                    _logger.trace("[{}] GetChanges for sequence {}.", (Object)this._serviceName, sequenceToken);
                    ChangeList changeList = this._mirroredChangeLog.getChanges(sequenceToken);
                    sequenceToken = changeList.getSequence();
                    this.mirrorChanges(changeList.getChanges());
                }
                connectionErrors = 0;
                Thread.sleep(500L);
            }
            catch (SequenceExpiredException e) {
                _logger.info("[{}] The sequence token '{}' has expired, changes will be truncated!", (Object)this._serviceName, sequenceToken);
                sequenceToken = null;
            }
            catch (Exception e) {
                if (ChangeLogMirror.exceptionIndicatesTemporaryError(e)) {
                    this.backOffOnTemporaryError(++connectionErrors, e);
                    continue;
                }
                if (this._state.get() != 2) {
                    _logger.error("Mirror of {} terimanted because of an unexpected error: {} {}", new Object[]{this._serviceName, e.getClass().getName(), e.getMessage(), e});
                }
                return;
            }
        }
    }

    private void backOffOnTemporaryError(int connectionErrors, Exception e) throws InterruptedException {
        long backOffTimeSec = connectionErrors < 5 ? 5L : (connectionErrors < 10 ? 10L : 30L);
        _logger.info("Connection error while reading from ChangeLog {} : {} {}. Will retry after {} seconds.", new Object[]{this._serviceName, e.getClass().getName(), e.getMessage(), backOffTimeSec});
        _logger.debug("", (Throwable)e);
        Thread.sleep(TimeUnit.SECONDS.toMillis(backOffTimeSec));
    }

    private static boolean exceptionIndicatesTemporaryError(Exception e) {
        if (e instanceof UnexpectedStatusCodeException) {
            return ((UnexpectedStatusCodeException)e).getStatusCode() == 503;
        }
        if (e instanceof ConnectionException) {
            return e.getCause() instanceof SocketTimeoutException;
        }
        if (e instanceof com.vmware.vim.vmomi.client.exception.TransportProtocolException) {
            return e.getCause() instanceof NoHttpResponseException;
        }
        if (e instanceof TransportProtocolException) {
            return !(e instanceof SslException) && !(e.getCause() instanceof UnknownHostException) && !(e.getCause() instanceof InterruptedIOException) && !(e.getCause() instanceof HttpException) && !(e.getCause() instanceof ParseException) && !(e.getCause() instanceof CoreException);
        }
        return false;
    }

    private void mirrorChanges(List<ChangeEvent> changeEvents) {
        assert (changeEvents != null);
        if (changeEvents.isEmpty()) {
            return;
        }
        _logger.debug("Copying {} change(s) from {}.", (Object)changeEvents.size(), (Object)this._serviceName);
        _logger.trace("Changes: {}", changeEvents);
        for (ChangeEvent changeEvent : changeEvents) {
            this.mirrorChange(changeEvent.getKind(), changeEvent.getResource(), changeEvent.getResourceType(), changeEvent.getProperties());
        }
    }

    private void mirrorChange(ChangeEvent.ChangeKind changeKind, Object resource, String resourceType, List<String> changedProperties) {
        assert (changeKind != null);
        assert (resource != null);
        assert (resourceType != null);
        ChangeRecorder changeRecorder = this._internalChangeLog.getRecorder();
        switch (changeKind) {
            case CREATE: {
                changeRecorder.recordCreate(resource, resourceType);
                break;
            }
            case UPDATE: {
                if (!this._keepPropertiesInMirror || changedProperties == null || changedProperties.isEmpty()) {
                    changeRecorder.recordUpdate(resource, resourceType);
                    break;
                }
                changeRecorder.recordUpdate(resource, resourceType, changedProperties);
                break;
            }
            case DELETE: {
                changeRecorder.recordDelete(resource, resourceType);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported change kind: " + changeKind);
            }
        }
    }
}

