/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.cdc.internal.adapters.vcenter;

import com.vmware.cdc.ChangeLog;
import com.vmware.cdc.client.transport.ChangeLogProxy;
import com.vmware.cdc.internal.client.aggregator.AggregatingChangeLog;
import com.vmware.cis.cdc.internal.adapters.pc.PropertyCollectorChangeLogFactory;
import com.vmware.cis.cdc.internal.adapters.vcenter.ChangeLogConfiguration;
import com.vmware.cis.cdc.internal.adapters.vcenter.ChangeLogConnection;
import com.vmware.cis.cdc.internal.adapters.vcenter.ChangeLogMirror;
import com.vmware.cis.cdc.internal.adapters.vcenter.NamedChangeLog;
import com.vmware.cis.data.internal.adapters.federation.IdentifiableServiceInstance;
import com.vmware.cis.data.internal.adapters.federation.ServiceEndpointDiscovery;
import com.vmware.cis.data.internal.adapters.lookup.ServiceEndpointInfo;
import com.vmware.cis.data.internal.adapters.lookup.ServiceLocator;
import com.vmware.cis.data.internal.adapters.util.vapi.DefaultVapiAuthenticatorFactory;
import com.vmware.cis.data.internal.adapters.util.vapi.SessionAwareApiProvider;
import com.vmware.cis.data.internal.adapters.util.vapi.SessionAwareVapiConnectionCloseable;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiAuthenticator;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiAuthenticatorFactory;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiProtocolConnectionFactory;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiSession;
import com.vmware.cis.data.internal.adapters.vmomi.VmomiAuthenticator;
import com.vmware.cis.data.internal.adapters.vmomi.VmomiAuthenticatorFactory;
import com.vmware.cis.data.internal.adapters.vmomi.impl.DefaultVmomiAuthenticatorFactory;
import com.vmware.cis.data.internal.adapters.vmomi.impl.HttpConfigurationFactory;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VlsiClientUtil;
import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.protocol.ProtocolConnection;
import com.vmware.vim.binding.vim.version.internal.versions;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VcenterChangeLogs
implements AutoCloseable {
    private static final Logger _logger = LoggerFactory.getLogger(VcenterChangeLogs.class);
    private static final String ENDPOINT_CDC_PROVIDER = "com.vmware.cdc.provider";
    private static final int VMOMI_CHANGE_LOG_MIRROR_SIZE = 1024;
    private static final int VAPI_CHANGE_LOG_MIRROR_SIZE = 512;
    private final ServiceLocator _serviceLocator;
    private final VmodlContext _vmodlContext;
    private final HttpConfigurationFactory _vlsiHttpConfigFactory;
    private final VapiProtocolConnectionFactory _vApiConnectionFactory;
    private final PropertyCollectorChangeLogFactory _pcChangeLogFactory;
    private final ChangeLogConfiguration _configuration;
    private final ExecutorService _mirrorThreadPool;

    public VcenterChangeLogs(ServiceLocator serviceLocator, VmodlContext vmodlContext, HttpConfigurationFactory vlsiHttpConfigFactory, VapiProtocolConnectionFactory vApiConnectionFactory, PropertyCollectorChangeLogFactory pcChangeLogFactory, ChangeLogConfiguration configuration) {
        assert (serviceLocator != null);
        assert (vmodlContext != null);
        assert (vlsiHttpConfigFactory != null);
        assert (vApiConnectionFactory != null);
        assert (pcChangeLogFactory != null);
        assert (configuration != null);
        this._serviceLocator = serviceLocator;
        this._vmodlContext = vmodlContext;
        this._vlsiHttpConfigFactory = vlsiHttpConfigFactory;
        this._vApiConnectionFactory = vApiConnectionFactory;
        this._pcChangeLogFactory = pcChangeLogFactory;
        this._configuration = configuration;
        this._mirrorThreadPool = new MirrorThreadPool(Short.MAX_VALUE);
    }

    public ChangeLogConnection connect(AuthenticationTokenSource credentials, VmomiAuthenticatorFactory vmomiAuthFactory) {
        return this.connect(credentials, vmomiAuthFactory, null);
    }

    public ChangeLogConnection connect(AuthenticationTokenSource credentials, VmomiAuthenticatorFactory vmomiAuthFactory, VapiAuthenticatorFactory vapiAuthFactory) {
        Validate.notNull((Object)credentials);
        DefaultVmomiAuthenticatorFactory defaultAuthFactory = new DefaultVmomiAuthenticatorFactory(this._vmodlContext, this._vlsiHttpConfigFactory, vmomiAuthFactory);
        DefaultVapiAuthenticatorFactory defaultVapiAuthFactory = new DefaultVapiAuthenticatorFactory(this._vApiConnectionFactory, vapiAuthFactory);
        long startConnectTime = System.currentTimeMillis();
        Collection<ChangeLogConnection> defaultChangeLogs = this.connectDefaultChangeLogs(credentials, defaultAuthFactory, defaultVapiAuthFactory);
        if (defaultChangeLogs.isEmpty()) {
            throw new IllegalStateException("No ChangeLog(s) connected, CDC is not active.");
        }
        long endConnectTime = System.currentTimeMillis();
        ArrayList<ChangeLog> changeLogs = new ArrayList<ChangeLog>(defaultChangeLogs.size());
        final ArrayList<AutoCloseable> changeLogConnections = new ArrayList<AutoCloseable>(defaultChangeLogs.size());
        for (ChangeLogConnection changeLogConnection : defaultChangeLogs) {
            changeLogs.add(changeLogConnection.getChangeLog());
            changeLogConnections.add(changeLogConnection.getConnection());
        }
        _logger.info("Connected in {} ms to ChangeLog providers: {}", (Object)(endConnectTime - startConnectTime), changeLogs);
        AggregatingChangeLog changeLog = new AggregatingChangeLog(changeLogs, this._configuration.getExecutionThreshold());
        AutoCloseable connectionCloseable = new AutoCloseable(){

            @Override
            public void close() throws Exception {
                for (AutoCloseable changeLogConnection : changeLogConnections) {
                    try {
                        changeLogConnection.close();
                    }
                    catch (Exception e) {
                        String msg = "Error while closing change log: ";
                        if (_logger.isDebugEnabled()) {
                            _logger.debug(msg, (Throwable)e);
                            continue;
                        }
                        _logger.warn(msg + e.getMessage());
                    }
                }
            }
        };
        return new ChangeLogConnection((ChangeLog)changeLog, connectionCloseable);
    }

    @Override
    public void close() {
        this._mirrorThreadPool.shutdownNow();
    }

    private Collection<ChangeLogConnection> connectDefaultChangeLogs(AuthenticationTokenSource credentials, VmomiAuthenticatorFactory vmomiAuthFactory, VapiAuthenticatorFactory vapiAuthFactory) {
        ArrayList<ChangeLogConnection> changeLogs = new ArrayList<ChangeLogConnection>();
        Collection<ServiceEndpointInfo> cdcEndpoints = VcenterChangeLogs.findCdcProviderEndpoints(this._serviceLocator, this._vmodlContext, this._vlsiHttpConfigFactory);
        ArrayList<ServiceEndpointInfo> pcEndpointInfos = new ArrayList<ServiceEndpointInfo>();
        for (ServiceEndpointInfo cdcEndpoint : cdcEndpoints) {
            ChangeLogConnection changeLogConnection;
            if (!this._configuration.useVpxdCdc() && "vmomi".equals(cdcEndpoint.getEndpointProtocol())) {
                pcEndpointInfos.add(cdcEndpoint);
                continue;
            }
            try {
                changeLogConnection = this.connectChangeLog(cdcEndpoint, credentials, vmomiAuthFactory, vapiAuthFactory);
            }
            catch (Exception e) {
                String msg = "Error while connecting change log at '{}', skipping it: ";
                if (_logger.isDebugEnabled()) {
                    _logger.debug(msg, (Object)cdcEndpoint.getUrl(), (Object)e);
                    continue;
                }
                _logger.warn(msg + e.getMessage(), (Object)cdcEndpoint.getUrl());
                continue;
            }
            changeLogs.add(changeLogConnection);
        }
        if (!this._configuration.useVpxdCdc()) {
            changeLogs.addAll(this._pcChangeLogFactory.connect(pcEndpointInfos, credentials));
        }
        if (this._configuration.usePcCdcForPreRise()) {
            changeLogs.addAll(this.connectPreRiseChangeLogs(credentials));
        }
        return Collections.unmodifiableCollection(changeLogs);
    }

    private Collection<ChangeLogConnection> connectPreRiseChangeLogs(AuthenticationTokenSource credentials) {
        Map<String, IdentifiableServiceInstance> vpxdInstanceIdByNode;
        Collection<ServiceEndpointInfo> vpxdEndpoints = ServiceEndpointDiscovery.findVcEndpoints(this._serviceLocator);
        Collection<ServiceEndpointInfo> preRiseVcEndpoints = ServiceEndpointDiscovery.onlyPreRise(vpxdEndpoints, vpxdInstanceIdByNode = ServiceEndpointDiscovery.createVpxdInstanceIdPerNode(vpxdEndpoints, this._vmodlContext, this._vlsiHttpConfigFactory));
        if (preRiseVcEndpoints.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ServiceEndpointInfo> preRisePcEndpoints = new ArrayList<ServiceEndpointInfo>();
        for (ServiceEndpointInfo cdcEndpoint : preRiseVcEndpoints) {
            if (!"vmomi".equals(cdcEndpoint.getEndpointProtocol())) continue;
            preRisePcEndpoints.add(cdcEndpoint);
        }
        return this._pcChangeLogFactory.connect(preRisePcEndpoints, credentials);
    }

    private static Collection<ServiceEndpointInfo> findCdcProviderEndpoints(ServiceLocator serviceLocator, VmodlContext vmodlContext, HttpConfigurationFactory vlsiHttpConfigFactory) {
        Collection<ServiceEndpointInfo> cdcProviderEndpoints = VcenterChangeLogs.findCdcProviderEndpoints(serviceLocator);
        Collection<ServiceEndpointInfo> vpxdEndpoints = ServiceEndpointDiscovery.filterByServiceType(cdcProviderEndpoints, ServiceEndpointDiscovery.PROVIDER_TYPE_VC);
        Map<String, IdentifiableServiceInstance> vpxdInstanceIdByNode = ServiceEndpointDiscovery.createVpxdInstanceIdPerNode(vpxdEndpoints, vmodlContext, vlsiHttpConfigFactory);
        return Collections.unmodifiableCollection(ServiceEndpointDiscovery.onlySupported(cdcProviderEndpoints, vpxdInstanceIdByNode));
    }

    private static Collection<ServiceEndpointInfo> findCdcProviderEndpoints(ServiceLocator serviceLocator) {
        assert (serviceLocator != null);
        Collection<ServiceEndpointInfo> endpointInfos = serviceLocator.findServiceEndpoints(null, null, ENDPOINT_CDC_PROVIDER, null);
        return endpointInfos;
    }

    private ChangeLogConnection connectChangeLog(ServiceEndpointInfo endpoint, AuthenticationTokenSource credentials, VmomiAuthenticatorFactory vmomiAuthFactory, VapiAuthenticatorFactory vapiAuthFactory) {
        String protocolName;
        assert (endpoint != null);
        assert (credentials != null);
        assert (vmomiAuthFactory != null);
        assert (vapiAuthFactory != null);
        ChangeLogConnection changeLogConnection = null;
        switch (protocolName = endpoint.getEndpointProtocol()) {
            case "vmomi": {
                changeLogConnection = this.connectVmomiChangeLog(endpoint, credentials, vmomiAuthFactory.getAuthenticator(endpoint));
                break;
            }
            case "vapi.json.https": 
            case "vapi.json.http": {
                changeLogConnection = this.connectVapiChangeLog(endpoint, credentials, vapiAuthFactory.getAuthenticator(endpoint));
                break;
            }
            default: {
                _logger.warn("Ignoring cdc provider endpoint {} because it has unknown protocol: {}", (Object)endpoint.getUrl(), (Object)protocolName);
            }
        }
        return changeLogConnection;
    }

    private ChangeLogConnection connectVmomiChangeLog(ServiceEndpointInfo vmomiEndpoint, AuthenticationTokenSource credentials, VmomiAuthenticator authenticator) {
        HttpConfiguration httpConfig = this._vlsiHttpConfigFactory.createConfiguration(vmomiEndpoint.getUrl(), vmomiEndpoint.getTrustStore());
        final Client vlsiClient = VlsiClientUtil.createAuthenticatedVlsiClient(vmomiEndpoint.getUrl(), httpConfig, this._vmodlContext, authenticator, credentials, versions.VIM_VERSION_NEWEST);
        ChangeLog rawChangeLog = ChangeLogProxy.forVmomiProvider((VmodlContext)this._vmodlContext, (Client)vlsiClient);
        String serviceName = VcenterChangeLogs.getFriendlyServiceName(vmomiEndpoint);
        final ChangeLogMirror mirrorChangeLog = new ChangeLogMirror(serviceName, rawChangeLog, 1024, this._mirrorThreadPool, this._configuration.keepPropertiesInMirror());
        AutoCloseable connectionCloseable = new AutoCloseable(){

            @Override
            public void close() throws Exception {
                mirrorChangeLog.close();
                vlsiClient.shutdown();
            }
        };
        return new ChangeLogConnection(new NamedChangeLog(mirrorChangeLog, vmomiEndpoint.getUrl().toString()), connectionCloseable);
    }

    private ChangeLogConnection connectVapiChangeLog(ServiceEndpointInfo vapiEndpoint, AuthenticationTokenSource credentials, VapiAuthenticator authenticator) {
        VapiSession session = authenticator.login(credentials);
        ProtocolConnection connection = this._vApiConnectionFactory.connect(vapiEndpoint.getUrl(), vapiEndpoint.getTrustStore());
        ApiProvider apiProvider = connection.getApiProvider();
        final SessionAwareVapiConnectionCloseable connectionCloseable = new SessionAwareVapiConnectionCloseable(connection, session);
        ChangeLog rawChangeLog = ChangeLogProxy.forVapiProvider((ApiProvider)new SessionAwareApiProvider(apiProvider, session));
        String serviceName = vapiEndpoint.getUrl().toString();
        final ChangeLogMirror mirrorChangeLog = new ChangeLogMirror(serviceName, rawChangeLog, 512, this._mirrorThreadPool, this._configuration.keepPropertiesInMirror());
        AutoCloseable cleanup = new AutoCloseable(){

            @Override
            public void close() throws Exception {
                mirrorChangeLog.close();
                connectionCloseable.close();
            }
        };
        return new ChangeLogConnection(new NamedChangeLog(mirrorChangeLog, vapiEndpoint.getUrl().toString()), cleanup);
    }

    private static String getFriendlyServiceName(ServiceEndpointInfo endpoint) {
        return endpoint.getServiceType() + "@" + endpoint.getUrl().toString();
    }

    private static final class MirrorThreadFactory
    implements ThreadFactory {
        private final AtomicInteger _index = new AtomicInteger();

        private MirrorThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = "change-log-mirror-" + this._index.incrementAndGet();
            return new Thread(r, name);
        }
    }

    private static final class MirrorThreadPool
    extends ThreadPoolExecutor {
        public MirrorThreadPool(int maxSize) {
            super(0, maxSize, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new MirrorThreadFactory());
            this.allowCoreThreadTimeOut(true);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (t != null) {
                _logger.error("Mirror task {} finished with error: {}: {}", new Object[]{r, t.getClass(), t.getMessage(), t});
            }
        }
    }
}

