/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.adapters.vcenter;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VmomiDataProviderConnection;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.vim.binding.cis.data.provider.ResourceModel;
import com.vmware.vim.binding.cis.data.provider.version.internal.versions;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.exception.VmodlAlreadyLoadedException;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import java.util.Collections;
import org.apache.commons.lang.Validate;

public final class VpxdVimQueryService {
    private VpxdVimQueryService() {
    }

    public static Class<?> getClientVersion() {
        return versions.CIS_DATA_PROVIDER_VERSION_STABLE;
    }

    public static void prepareVmodlContext(VmodlContext vmodlContext) {
        Validate.notNull((Object)vmodlContext);
        VmodlTypeMap vmodlTypeMap = vmodlContext.getVmodlTypeMap();
        if (vmodlTypeMap.getLoadedVmodlType(ServiceInstance.class) == null) {
            throw new IllegalArgumentException("VmodlContext does not contain VIM bindings");
        }
        if (vmodlTypeMap.getLoadedVmodlType(ResourceModel.class) != null) {
            return;
        }
        try {
            vmodlContext.loadVmodlPackages(new String[]{"com.vmware.vim.binding.cis.data.provider"}, true);
        }
        catch (VmodlAlreadyLoadedException vmodlAlreadyLoadedException) {
            // empty catch block
        }
    }

    public static QueryService createQueryService(Client vimClient) {
        Validate.notNull((Object)vimClient);
        final VmomiDataProviderConnection vimdp = new VmomiDataProviderConnection(vimClient);
        final QuerySchema schema = vimdp.getSchema();
        DataProvider dataProvider = new DataProvider(){

            public ResultSet executeQuery(Query query) {
                return vimdp.executeQuery(query);
            }

            public QuerySchema getSchema() {
                return schema;
            }
        };
        return QueryService.Builder.forProviders(Collections.singleton(dataProvider)).build();
    }
}

