/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.customfield;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.adapters.customfield.CustomFieldRepository;
import com.vmware.cis.data.internal.adapters.customfield.VimCustomFieldsManagerRepository;
import com.vmware.cis.data.internal.provider.util.filter.OperatorLikeEvaluator;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CustomFieldDataProviderConnection
implements DataProvider {
    private static final Logger _logger = LoggerFactory.getLogger(CustomFieldDataProviderConnection.class);
    private static final boolean EXACTLY = true;
    private static final boolean CONTAINS = false;
    private final CustomFieldRepository _customFields;

    public CustomFieldDataProviderConnection(Client vlsiClient) {
        this(new VimCustomFieldsManagerRepository(vlsiClient));
    }

    CustomFieldDataProviderConnection(CustomFieldRepository customFields) {
        Validate.notNull((Object)customFields);
        this._customFields = customFields;
    }

    public ResultSet executeQuery(Query query) {
        CustomFieldDataProviderConnection.validateQuery(query);
        Filter filter = query.getFilter();
        Collection<ManagedObjectReference> entities = this.getEntitiesWithCustomFieldAndValue(filter);
        return CustomFieldDataProviderConnection.createResultSet(entities);
    }

    public QuerySchema getSchema() {
        LinkedHashMap<String, QuerySchema.PropertyInfo> props = new LinkedHashMap<String, QuerySchema.PropertyInfo>();
        props.put("CustomFieldAssociation/name", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING));
        props.put("CustomFieldAssociation/value", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING));
        props.put("CustomFieldAssociation/entity", QuerySchema.PropertyInfo.forNonFilterableProperty());
        return QuerySchema.forProperties(props);
    }

    public String toString() {
        return "CustomFieldAssociationDataProviderConnection(" + this._customFields + ")";
    }

    private Collection<ManagedObjectReference> getEntitiesWithCustomFieldAndValue(Filter filter) {
        assert (filter != null);
        PropertyPredicate namePredicate = CustomFieldDataProviderConnection.getCaseInsensitivePredicate(filter, "CustomFieldAssociation/name");
        PropertyPredicate valuePredicate = CustomFieldDataProviderConnection.getCaseInsensitivePredicate(filter, "CustomFieldAssociation/value");
        PropertyPredicate.ComparisonOperator nameOp = namePredicate.getOperator();
        PropertyPredicate.ComparisonOperator valueOp = valuePredicate.getOperator();
        String name = CustomFieldDataProviderConnection.getComparableString(namePredicate);
        String value = CustomFieldDataProviderConnection.getComparableString(valuePredicate);
        if (_logger.isDebugEnabled()) {
            _logger.debug("Searching entities by custom field name {} '{}' and custom field value {} '{}", new Object[]{nameOp, name, valueOp, value});
        }
        if (PropertyPredicate.ComparisonOperator.EQUAL.equals((Object)nameOp) && PropertyPredicate.ComparisonOperator.EQUAL.equals((Object)valueOp)) {
            return this.nameEqualAndValueEqual(name, value);
        }
        if (PropertyPredicate.ComparisonOperator.EQUAL.equals((Object)nameOp) && PropertyPredicate.ComparisonOperator.NOT_EQUAL.equals((Object)valueOp)) {
            return this.nameEqualAndValueNotEqual(name, value);
        }
        if (PropertyPredicate.ComparisonOperator.EQUAL.equals((Object)nameOp) && PropertyPredicate.ComparisonOperator.LIKE.equals((Object)valueOp)) {
            return this.nameEqualAndValueLike(name, value);
        }
        if (PropertyPredicate.ComparisonOperator.NOT_EQUAL.equals((Object)nameOp) && PropertyPredicate.ComparisonOperator.EQUAL.equals((Object)valueOp)) {
            return this.nameNotEqualAndValueEqual(name, value);
        }
        if (PropertyPredicate.ComparisonOperator.NOT_EQUAL.equals((Object)nameOp) && PropertyPredicate.ComparisonOperator.NOT_EQUAL.equals((Object)valueOp)) {
            return this.nameNotEqualAndValueNotEqual(name, value);
        }
        if (PropertyPredicate.ComparisonOperator.NOT_EQUAL.equals((Object)nameOp) && PropertyPredicate.ComparisonOperator.LIKE.equals((Object)valueOp)) {
            return this.nameNotEqualAndValueLike(name, value);
        }
        if (PropertyPredicate.ComparisonOperator.LIKE.equals((Object)nameOp) && PropertyPredicate.ComparisonOperator.EQUAL.equals((Object)valueOp)) {
            return this.nameLikeAndValueEqual(name, value);
        }
        if (PropertyPredicate.ComparisonOperator.LIKE.equals((Object)nameOp) && PropertyPredicate.ComparisonOperator.NOT_EQUAL.equals((Object)valueOp)) {
            return this.nameLikeAndValueNotEqual(name, value);
        }
        if (PropertyPredicate.ComparisonOperator.LIKE.equals((Object)nameOp) && PropertyPredicate.ComparisonOperator.LIKE.equals((Object)valueOp)) {
            return this.nameLikeAndValueLike(name, value);
        }
        throw new IllegalArgumentException("Filter uses unsupported comparison operator: " + filter);
    }

    private Collection<ManagedObjectReference> nameEqualAndValueEqual(String name, String value) {
        return this.getEntities(name, value, true);
    }

    private Collection<ManagedObjectReference> nameEqualAndValueNotEqual(String name, String value) {
        Collection<ManagedObjectReference> entities = this.getEntities(name, null, true);
        return this.filterEntities(entities, CustomFieldDataProviderConnection.equalsIgnoreCase(name), CustomFieldDataProviderConnection.notEqualsIgnoreCase(value));
    }

    private Collection<ManagedObjectReference> nameEqualAndValueLike(String name, String value) {
        Collection<ManagedObjectReference> entities = this.getEntities(name, null, true);
        return this.filterEntities(entities, CustomFieldDataProviderConnection.equalsIgnoreCase(name), CustomFieldDataProviderConnection.likeIgnoreCase(value));
    }

    private Collection<ManagedObjectReference> nameNotEqualAndValueEqual(String name, String value) {
        ImmutableList names = FluentIterable.from(this.getCustomFieldNames()).filter(CustomFieldDataProviderConnection.notEqualsIgnoreCase(name)).toList();
        return this.getEntities((Collection<String>)names, value, true);
    }

    private Collection<ManagedObjectReference> nameNotEqualAndValueNotEqual(String name, String value) {
        return this.getEntities(CustomFieldDataProviderConnection.notEqualsIgnoreCase(name), CustomFieldDataProviderConnection.notEqualsIgnoreCase(value));
    }

    private Collection<ManagedObjectReference> nameNotEqualAndValueLike(String name, String value) {
        return this.getEntities(CustomFieldDataProviderConnection.notEqualsIgnoreCase(name), CustomFieldDataProviderConnection.likeIgnoreCase(value));
    }

    private Collection<ManagedObjectReference> nameLikeAndValueEqual(String name, String value) {
        ImmutableList names = FluentIterable.from(this.getCustomFieldNames()).filter(CustomFieldDataProviderConnection.likeIgnoreCase(name)).toList();
        return this.getEntities((Collection<String>)names, value, true);
    }

    private Collection<ManagedObjectReference> nameLikeAndValueNotEqual(String name, String value) {
        return this.getEntities(CustomFieldDataProviderConnection.likeIgnoreCase(name), CustomFieldDataProviderConnection.notEqualsIgnoreCase(value));
    }

    private Collection<ManagedObjectReference> nameLikeAndValueLike(String name, String value) {
        OperatorLikeEvaluator.StringMatchingInfo nameMatchInfo = OperatorLikeEvaluator.analyzeTemplate((String)name);
        OperatorLikeEvaluator.StringMatchingInfo valueMatchInfo = OperatorLikeEvaluator.analyzeTemplate((String)value);
        OperatorLikeEvaluator.StringMatchingMode nameMode = nameMatchInfo.getMode();
        OperatorLikeEvaluator.StringMatchingMode valueMode = valueMatchInfo.getMode();
        String nameSearchText = nameMatchInfo.getSearchText();
        String valueSearchText = valueMatchInfo.getSearchText();
        if (OperatorLikeEvaluator.StringMatchingMode.Exact.equals((Object)nameMode) && OperatorLikeEvaluator.StringMatchingMode.Exact.equals((Object)valueMode)) {
            return this.getEntities(nameSearchText, valueSearchText, true);
        }
        if (OperatorLikeEvaluator.StringMatchingMode.Exact.equals((Object)nameMode)) {
            return this.nameEqualAndValueLike(nameSearchText, value);
        }
        if (OperatorLikeEvaluator.StringMatchingMode.Exact.equals((Object)valueMode)) {
            return this.nameLikeAndValueEqual(name, valueSearchText);
        }
        if (OperatorLikeEvaluator.StringMatchingMode.Contains.equals((Object)nameMode) && OperatorLikeEvaluator.StringMatchingMode.Contains.equals((Object)valueMode)) {
            return this.getEntities(nameSearchText, valueSearchText, false);
        }
        Collection<ManagedObjectReference> entities = this.getEntities(nameSearchText, valueSearchText, false);
        return this.filterEntities(entities, CustomFieldDataProviderConnection.likeIgnoreCase(name), CustomFieldDataProviderConnection.likeIgnoreCase(value));
    }

    private Collection<ManagedObjectReference> getEntities(Predicate<String> namePredicate, Predicate<String> valuePredicate) {
        assert (namePredicate != null);
        assert (valuePredicate != null);
        ImmutableList names = FluentIterable.from(this.getCustomFieldNames()).filter(namePredicate).toList();
        Collection<ManagedObjectReference> entities = this.getEntities((Collection<String>)names, null, true);
        return this.filterEntities(entities, namePredicate, valuePredicate);
    }

    private Collection<ManagedObjectReference> getEntities(String name, String value, boolean exactMatch) {
        return this.getEntities(Collections.singleton(name), value, exactMatch);
    }

    private Collection<ManagedObjectReference> getEntities(Collection<String> names, String value, boolean exactMatch) {
        return this._customFields.getEntities(names, value, exactMatch);
    }

    private Collection<ManagedObjectReference> filterEntities(Collection<ManagedObjectReference> entities, Predicate<String> namePredicate, Predicate<String> valuePredicate) {
        return this._customFields.filterEntities(entities, namePredicate, valuePredicate);
    }

    private Collection<String> getCustomFieldNames() {
        return this._customFields.getCustomFieldNames();
    }

    private static void validateQuery(Query query) {
        Validate.notNull((Object)query);
        for (String property : query.getProperties()) {
            if ("CustomFieldAssociation/entity".equals(property)) continue;
            throw new IllegalArgumentException("Unsupported property requested: " + property);
        }
        if (query.getWithTotalCount()) {
            throw new IllegalArgumentException("Total count is not supported");
        }
        for (String model : query.getResourceModels()) {
            if ("CustomFieldAssociation".equals(model)) continue;
            throw new IllegalArgumentException("Unsupported resource model: " + model);
        }
        if (query.getFilter() == null) {
            throw new IllegalArgumentException("Filter is required");
        }
        if (query.getFilter().getCriteria().size() != 2) {
            throw new IllegalArgumentException("Filter must be a conjunction with two predicates: " + query.getFilter());
        }
        if (!LogicalOperator.AND.equals((Object)query.getFilter().getOperator())) {
            throw new IllegalArgumentException("Only conjunction filters are supported");
        }
        if (!query.getSortCriteria().isEmpty()) {
            throw new IllegalArgumentException("Ordering is not supported");
        }
    }

    private static PropertyPredicate getCaseInsensitivePredicate(Filter filter, String property) {
        assert (filter != null);
        assert (filter.getCriteria().size() > 0);
        PropertyPredicate wantedPredicate = null;
        int wantedPredicateCount = 0;
        for (PropertyPredicate predicate : filter.getCriteria()) {
            if (!property.equals(predicate.getProperty())) continue;
            wantedPredicate = predicate;
            ++wantedPredicateCount;
        }
        if (wantedPredicateCount > 1) {
            throw new IllegalArgumentException(String.format("Filter has multiple predicates on property '%s': %s", property, filter));
        }
        if (wantedPredicate == null) {
            throw new IllegalArgumentException(String.format("Filter must have predicate on '%s': %s", property, filter));
        }
        return wantedPredicate;
    }

    private static String getComparableString(PropertyPredicate predicate) {
        assert (predicate != null);
        Object comparableValue = predicate.getComparableValue();
        if (comparableValue instanceof String) {
            return (String)comparableValue;
        }
        throw new IllegalArgumentException(String.format("Comparable value for property '%s' must be java.lang.String and not %s", predicate.getProperty(), comparableValue != null ? comparableValue.getClass() : "null"));
    }

    private static ResultSet createResultSet(Collection<ManagedObjectReference> entitiesWithCustomFields) {
        assert (entitiesWithCustomFields != null);
        ArrayList<ResourceItem> items = new ArrayList<ResourceItem>(entitiesWithCustomFields.size());
        for (ManagedObjectReference ref : entitiesWithCustomFields) {
            ResourceItem item = new ResourceItem(Collections.singletonList(ref));
            items.add(item);
        }
        return new ResultSet(Collections.singletonList("CustomFieldAssociation/entity"), items);
    }

    private static Predicate<String> equalsIgnoreCase(final String comparable) {
        Validate.notNull((Object)comparable);
        return new Predicate<String>(){

            public boolean apply(String input) {
                if (input == null) {
                    return false;
                }
                return comparable.equalsIgnoreCase(input);
            }

            public String toString() {
                return "Predicate:EqualsIgnoreCase";
            }
        };
    }

    private static Predicate<String> notEqualsIgnoreCase(final String comparable) {
        Validate.notNull((Object)comparable);
        return new Predicate<String>(){

            public boolean apply(String input) {
                if (input == null) {
                    return true;
                }
                return !comparable.equalsIgnoreCase(input);
            }

            public String toString() {
                return "Predicate:NotEqualsIgnoreCase";
            }
        };
    }

    private static Predicate<String> startsWithIgnoreCase(String comparable) {
        Validate.notNull((Object)comparable);
        final String lowerCaseComparable = comparable.toLowerCase();
        return new Predicate<String>(){

            public boolean apply(String input) {
                if (input == null) {
                    return false;
                }
                return input.toLowerCase().startsWith(lowerCaseComparable);
            }

            public String toString() {
                return "Predicate:StartsWithIgnoreCase";
            }
        };
    }

    private static Predicate<String> endsWithIgnoreCase(String comparable) {
        Validate.notNull((Object)comparable);
        final String lowerCaseComparable = comparable.toLowerCase();
        return new Predicate<String>(){

            public boolean apply(String input) {
                if (input == null) {
                    return false;
                }
                return input.toLowerCase().endsWith(lowerCaseComparable);
            }

            public String toString() {
                return "Predicate:EndsWithIgnoreCase";
            }
        };
    }

    private static Predicate<String> containsIgnoreCase(String comparable) {
        Validate.notNull((Object)comparable);
        final String lowerCaseComparable = comparable.toLowerCase();
        return new Predicate<String>(){

            public boolean apply(String input) {
                if (input == null) {
                    return false;
                }
                return input.toLowerCase().contains(lowerCaseComparable);
            }

            public String toString() {
                return "Predicate:ContainsIgnoreCase";
            }
        };
    }

    private static Predicate<String> likeIgnoreCase(String comparable) {
        Validate.notNull((Object)comparable);
        OperatorLikeEvaluator.StringMatchingInfo matchInfo = OperatorLikeEvaluator.analyzeTemplate((String)comparable);
        OperatorLikeEvaluator.StringMatchingMode mode = matchInfo.getMode();
        String searchText = matchInfo.getSearchText();
        switch (mode) {
            case StartsWith: {
                return CustomFieldDataProviderConnection.startsWithIgnoreCase(searchText);
            }
            case EndsWith: {
                return CustomFieldDataProviderConnection.endsWithIgnoreCase(searchText);
            }
            case Contains: {
                return CustomFieldDataProviderConnection.containsIgnoreCase(searchText);
            }
            case Exact: {
                return CustomFieldDataProviderConnection.equalsIgnoreCase(searchText);
            }
        }
        throw new IllegalStateException(String.format("Unknown string matching mode '%s' in search phrase '%s'", mode, comparable));
    }
}

