/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.federation;

import com.vmware.cis.data.internal.adapters.federation.MajorMinorVersion;

public final class VersionAnalyzer {
    private static final MajorMinorVersion BEGINNING_OF_RISE_LOW = new MajorMinorVersion(6, 1);
    private static final MajorMinorVersion BEGINNING_OF_RISE_HIGH = new MajorMinorVersion(6, 5);

    public static boolean isVersionBeforeRise(String version) {
        assert (version != null);
        MajorMinorVersion actual = MajorMinorVersion.parseVersion(version);
        return VersionAnalyzer.isVersionBeforeRise(actual);
    }

    public static boolean isVersionBeforeRise(MajorMinorVersion version) {
        assert (version != null);
        return BEGINNING_OF_RISE_LOW.compareTo(version) > 0;
    }

    public static boolean isVersionTooNew(String version) {
        assert (version != null);
        MajorMinorVersion actual = MajorMinorVersion.parseVersion(version);
        return VersionAnalyzer.isVersionTooNew(actual);
    }

    public static boolean isVersionTooNew(MajorMinorVersion version) {
        assert (version != null);
        return version.compareTo(BEGINNING_OF_RISE_HIGH) > 0;
    }
}

