/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.tagging;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.internal.adapters.tagging.LenientTaggingFacade;
import com.vmware.cis.data.internal.adapters.tagging.PropertyProvider;
import com.vmware.cis.tagging.CategoryModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class CategoryModelPropertyProvider
implements PropertyProvider {
    private final LenientTaggingFacade _tagging;

    public static Map<String, QuerySchema.PropertyInfo> getProperties() {
        HashMap<String, QuerySchema.PropertyInfo> properties = new HashMap<String, QuerySchema.PropertyInfo>();
        properties.put("com.vmware.cis.tagging.CategoryModel/id", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.ID));
        properties.put("com.vmware.cis.tagging.CategoryModel/name", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING));
        properties.put("com.vmware.cis.tagging.CategoryModel/description", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING));
        properties.put("com.vmware.cis.tagging.CategoryModel/cardinality", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING));
        properties.put("com.vmware.cis.tagging.CategoryModel/associableTypes", QuerySchema.PropertyInfo.forNonFilterableProperty());
        properties.put("com.vmware.cis.tagging.CategoryModel/usedBy", QuerySchema.PropertyInfo.forNonFilterableProperty());
        properties.put("com.vmware.cis.tagging.CategoryModel/tags", QuerySchema.PropertyInfo.forNonFilterableProperty());
        return Collections.unmodifiableMap(properties);
    }

    CategoryModelPropertyProvider(LenientTaggingFacade tagging) {
        assert (tagging != null);
        this._tagging = tagging;
    }

    @Override
    public ResourceItem get(String modelKey, List<String> properties) {
        assert (modelKey != null);
        assert (properties != null);
        CategoryModel categoryModel = this._tagging.getCategory(modelKey);
        return this.getItem(categoryModel, properties);
    }

    @Override
    public List<ResourceItem> get(List<String> modelKeys, List<String> properties) {
        assert (modelKeys != null);
        assert (properties != null);
        List<CategoryModel> categoryModels = this._tagging.getCategories(modelKeys);
        return this.getItems(categoryModels, properties);
    }

    @Override
    public List<ResourceItem> list(List<String> properties) {
        assert (properties != null);
        List<CategoryModel> categoryModels = this._tagging.getAllCategories();
        return this.getItems(categoryModels, properties);
    }

    private List<ResourceItem> getItems(List<CategoryModel> categoryModels, List<String> properties) {
        assert (categoryModels != null);
        assert (properties != null);
        ArrayList<ResourceItem> items = new ArrayList<ResourceItem>(categoryModels.size());
        for (CategoryModel categoryModel : categoryModels) {
            ResourceItem item = this.getItem(categoryModel, properties);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    private ResourceItem getItem(CategoryModel categoryModel, List<String> properties) {
        assert (properties != null);
        if (categoryModel == null) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>(properties.size());
        for (String property : properties) {
            Object value = this.getProperty(categoryModel, property);
            values.add(value);
        }
        return new ResourceItem(values);
    }

    private Object getProperty(CategoryModel categoryModel, String property) {
        assert (categoryModel != null);
        assert (property != null);
        switch (property) {
            case "@modelKey": {
                return categoryModel.getId();
            }
            case "@type": {
                return "com.vmware.cis.tagging.Category";
            }
            case "com.vmware.cis.tagging.CategoryModel/id": {
                return categoryModel.getId();
            }
            case "com.vmware.cis.tagging.CategoryModel/name": {
                return categoryModel.getName();
            }
            case "com.vmware.cis.tagging.CategoryModel/description": {
                return categoryModel.getDescription();
            }
            case "com.vmware.cis.tagging.CategoryModel/cardinality": {
                return categoryModel.getCardinality().name();
            }
            case "com.vmware.cis.tagging.CategoryModel/associableTypes": {
                return categoryModel.getAssociableTypes();
            }
            case "com.vmware.cis.tagging.CategoryModel/usedBy": {
                return categoryModel.getUsedBy();
            }
            case "com.vmware.cis.tagging.CategoryModel/tags": {
                return this._tagging.listTagsForCategory(categoryModel.getId());
            }
        }
        throw new IllegalArgumentException("Unknown property : " + property);
    }
}

