/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.tagging;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.adapters.tagging.FilteringPropertyProvider;
import com.vmware.cis.data.internal.adapters.tagging.PropertyProvider;
import com.vmware.cis.data.internal.provider.merge.DefaultItemComparator;
import com.vmware.cis.data.internal.provider.util.filter.FilterEvaluator;
import com.vmware.cis.data.internal.provider.util.property.PropertyByName;
import com.vmware.cis.data.internal.provider.util.property.PropertyByNameBackedByResourceItem;
import com.vmware.cis.data.internal.provider.util.property.ResourceItemPropertyByName;
import com.vmware.cis.data.internal.provider.util.property.ResourceItemPropertyValueByNameViaIndexMap;
import com.vmware.cis.data.internal.util.PropertyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public final class PropertyProviderBasedQueryExecutor {
    private final PropertyProvider _data;
    private final FilteringPropertyProvider _search;

    public PropertyProviderBasedQueryExecutor(PropertyProvider data) {
        this(data, new FilteringPropertyProvider(){

            @Override
            public List<String> getKeys(PropertyPredicate predicate) {
                return null;
            }
        });
    }

    public PropertyProviderBasedQueryExecutor(PropertyProvider data, FilteringPropertyProvider search) {
        assert (data != null);
        assert (search != null);
        this._data = data;
        this._search = search;
    }

    public ResultSet executeQuery(Query query) {
        List properties;
        List<Object> items;
        assert (query != null);
        List<String> filteredKeys = this.filter(query.getFilter());
        if (query.getLimit() != 0) {
            List<String> sortedKeys = this.sort(filteredKeys, query.getSortCriteria());
            List<String> pagedKeys = PropertyProviderBasedQueryExecutor.page(sortedKeys, query.getOffset(), query.getLimit());
            items = this.getPropertyValues(pagedKeys, query.getProperties());
            properties = query.getProperties();
        } else {
            items = Collections.emptyList();
            properties = Collections.emptyList();
        }
        return new ResultSet(properties, items, query.getWithTotalCount() ? Integer.valueOf(filteredKeys.size()) : null);
    }

    private List<String> filter(Filter filter) {
        List<String> keys = this.filterByNative(filter);
        if (keys != null) {
            return keys;
        }
        List<String> propertiesInInterpretableFilter = PropertyProviderBasedQueryExecutor.getPropsAndKey(filter);
        List<ResourceItem> allItems = this._data.list(propertiesInInterpretableFilter);
        return this.filterByInterpreted(filter, propertiesInInterpretableFilter, allItems);
    }

    private List<String> filterByNative(Filter filter) {
        if (filter == null) {
            return null;
        }
        if (filter.getCriteria().size() != 1) {
            return null;
        }
        PropertyPredicate predicate = (PropertyPredicate)filter.getCriteria().get(0);
        if (!"@modelKey".equals(predicate.getProperty()) || !PropertyProviderBasedQueryExecutor.operatorIsEquality(predicate.getOperator())) {
            return this._search.getKeys(predicate);
        }
        Collection<Object> comparableCollection = PropertyProviderBasedQueryExecutor.getComparableCollection(predicate);
        ArrayList<String> modelKeys = new ArrayList<String>(comparableCollection.size());
        for (Object comparableElement : comparableCollection) {
            assert (comparableElement instanceof String);
            String modelKey = (String)comparableElement;
            modelKeys.add(modelKey);
        }
        return PropertyProviderBasedQueryExecutor.getModelKeys(this._data.get(modelKeys, (List<String>)PropertyUtil.PROPERTY_LIST_MODEL_KEY), PropertyUtil.PROPERTY_LIST_MODEL_KEY);
    }

    private List<String> filterByInterpreted(Filter filter, List<String> propertiesInFilter, List<ResourceItem> items) {
        assert (propertiesInFilter != null);
        assert (items != null);
        if (filter == null) {
            return PropertyProviderBasedQueryExecutor.getModelKeys(items, propertiesInFilter);
        }
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ResourceItem> filtered = new ArrayList<ResourceItem>(items.size());
        ResourceItemPropertyValueByNameViaIndexMap propertyValueByName = new ResourceItemPropertyValueByNameViaIndexMap(propertiesInFilter);
        for (ResourceItem item : items) {
            PropertyByNameBackedByResourceItem valueByName = new PropertyByNameBackedByResourceItem(item, (ResourceItemPropertyByName)propertyValueByName);
            if (!FilterEvaluator.eval((Filter)filter, (PropertyByName)valueByName)) continue;
            filtered.add(item);
        }
        return PropertyProviderBasedQueryExecutor.getModelKeys(filtered, propertiesInFilter);
    }

    private static Collection<Object> getComparableCollection(PropertyPredicate predicate) {
        assert (predicate != null);
        if (PropertyPredicate.ComparisonOperator.IN.equals((Object)predicate.getOperator())) {
            assert (predicate.getComparableValue() instanceof Collection);
            Collection comparableCollection = (Collection)predicate.getComparableValue();
            return comparableCollection;
        }
        return Collections.singletonList(predicate.getComparableValue());
    }

    private static List<String> getPropsAndKey(Filter filter) {
        if (filter == null) {
            return Collections.singletonList("@modelKey");
        }
        LinkedHashSet<String> properties = new LinkedHashSet<String>(filter.getCriteria().size() + 1);
        properties.add("@modelKey");
        for (PropertyPredicate predicate : filter.getCriteria()) {
            properties.add(predicate.getProperty());
        }
        return new ArrayList<String>(properties);
    }

    private static List<String> getModelKeys(List<ResourceItem> items, List<String> properties) {
        int modelKeyIndex = properties.indexOf("@modelKey");
        assert (modelKeyIndex >= 0);
        ArrayList<String> modelKeys = new ArrayList<String>(items.size());
        for (ResourceItem item : items) {
            String modelKey = (String)item.getPropertyValues().get(modelKeyIndex);
            modelKeys.add(modelKey);
        }
        return modelKeys;
    }

    private List<String> sort(List<String> ids, List<SortCriterion> sortCriteria) {
        assert (ids != null);
        assert (sortCriteria != null);
        if (ids.isEmpty() || sortCriteria.isEmpty()) {
            return ids;
        }
        List<String> propertiesInSort = PropertyProviderBasedQueryExecutor.getPropsAndKey(sortCriteria);
        List<ResourceItem> items = this._data.get(ids, propertiesInSort);
        Collections.sort(items, new DefaultItemComparator(propertiesInSort, sortCriteria));
        return PropertyProviderBasedQueryExecutor.getModelKeys(items, propertiesInSort);
    }

    private static List<String> getPropsAndKey(List<SortCriterion> sortCriteria) {
        assert (sortCriteria != null);
        LinkedHashSet<String> properties = new LinkedHashSet<String>(sortCriteria.size() + 1);
        properties.add("@modelKey");
        for (SortCriterion sortCriterion : sortCriteria) {
            properties.add(sortCriterion.getProperty());
        }
        return new ArrayList<String>(properties);
    }

    private static <T> List<T> page(List<T> list, int offset, int limit) {
        assert (list != null);
        assert (offset >= 0);
        if (list.isEmpty()) {
            return list;
        }
        if (limit == 0) {
            return Collections.emptyList();
        }
        if (offset >= list.size()) {
            return Collections.emptyList();
        }
        if (limit < 0) {
            return list.subList(offset, list.size());
        }
        int lastIndex = offset + limit;
        if (lastIndex < 0 || lastIndex >= list.size()) {
            return list.subList(offset, list.size());
        }
        return list.subList(offset, lastIndex);
    }

    private List<ResourceItem> getPropertyValues(List<String> modelKeys, List<String> properties) {
        assert (modelKeys != null);
        assert (properties != null);
        assert (!properties.isEmpty());
        if (modelKeys.isEmpty()) {
            return Collections.emptyList();
        }
        return this._data.get(modelKeys, properties);
    }

    private static boolean operatorIsEquality(PropertyPredicate.ComparisonOperator operator) {
        return operator == PropertyPredicate.ComparisonOperator.EQUAL || operator == PropertyPredicate.ComparisonOperator.IN;
    }
}

