/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.tagging;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.adapters.tagging.CategoryModelPropertyProvider;
import com.vmware.cis.data.internal.adapters.tagging.LenientTaggingFacade;
import com.vmware.cis.data.internal.adapters.tagging.PropertyProviderBasedQueryExecutor;
import com.vmware.cis.data.internal.adapters.tagging.TagModelFilteringPropertyProvider;
import com.vmware.cis.data.internal.adapters.tagging.TagModelPropertyProvider;
import com.vmware.cis.data.internal.adapters.tagging.TaggingFacadeCache;
import com.vmware.cis.data.internal.adapters.tagging.TaggingFacadeImpl;
import com.vmware.cis.data.internal.adapters.tagging.TaggingFacadePerfLogging;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.vapi.core.ApiProvider;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.Validate;

final class TagDataProviderConnection
implements DataProvider {
    private final LenientTaggingFacade _tagging;

    TagDataProviderConnection(ApiProvider apiProvider) {
        Validate.notNull((Object)apiProvider);
        this._tagging = new TaggingFacadePerfLogging(new TaggingFacadeImpl(apiProvider));
    }

    public ResultSet executeQuery(Query query) {
        Validate.notNull((Object)query);
        String model = TagDataProviderConnection.getModel(query.getResourceModels());
        TaggingFacadeCache tagging = new TaggingFacadeCache(this._tagging);
        PropertyProviderBasedQueryExecutor queryExecutor = TagDataProviderConnection.createQueryExecutorForModel(model, tagging);
        return queryExecutor.executeQuery(query);
    }

    public QuerySchema getSchema() {
        HashMap<String, QuerySchema.PropertyInfo> propertyInfoByQualifiedName = new HashMap<String, QuerySchema.PropertyInfo>();
        propertyInfoByQualifiedName.putAll(TagModelPropertyProvider.getProperties());
        propertyInfoByQualifiedName.putAll(CategoryModelPropertyProvider.getProperties());
        return QuerySchema.forProperties(propertyInfoByQualifiedName);
    }

    private static String getModel(List<String> resourceModels) {
        assert (resourceModels != null);
        assert (!resourceModels.isEmpty());
        if (resourceModels.size() > 1) {
            throw new IllegalArgumentException("Multiple models in tagging query: " + resourceModels);
        }
        return resourceModels.get(0);
    }

    private static PropertyProviderBasedQueryExecutor createQueryExecutorForModel(String model, LenientTaggingFacade tagging) {
        assert (model != null);
        assert (tagging != null);
        switch (model) {
            case "com.vmware.cis.tagging.TagModel": {
                return new PropertyProviderBasedQueryExecutor(new TagModelPropertyProvider(tagging), new TagModelFilteringPropertyProvider(tagging));
            }
            case "com.vmware.cis.tagging.CategoryModel": {
                return new PropertyProviderBasedQueryExecutor(new CategoryModelPropertyProvider(tagging));
            }
        }
        throw new IllegalArgumentException("Unknown model: " + model);
    }
}

