/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.tagging;

import com.vmware.cis.data.internal.adapters.tagging.LenientTaggingFacade;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiOsgiAwareStubFactory;
import com.vmware.cis.tagging.Batch;
import com.vmware.cis.tagging.BatchTypes;
import com.vmware.cis.tagging.Category;
import com.vmware.cis.tagging.CategoryModel;
import com.vmware.cis.tagging.Tag;
import com.vmware.cis.tagging.TagModel;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.std.DynamicID;
import com.vmware.vapi.std.errors.NotFound;
import com.vmware.vapi.std.errors.Unauthorized;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

final class TaggingFacadeImpl
implements LenientTaggingFacade {
    private final Tag _tagService;
    private final Category _categoryService;
    private final Batch _batchService;

    TaggingFacadeImpl(ApiProvider apiProvider) {
        assert (apiProvider != null);
        VapiOsgiAwareStubFactory stubFactory = new VapiOsgiAwareStubFactory(apiProvider);
        this._tagService = stubFactory.createStub(Tag.class);
        this._categoryService = stubFactory.createStub(Category.class);
        this._batchService = stubFactory.createStub(Batch.class);
    }

    @Override
    public List<String> listTags() {
        return this._tagService.list();
    }

    @Override
    public TagModel getTag(String tagId) {
        assert (tagId != null);
        try {
            return this._tagService.get(tagId);
        }
        catch (NotFound notFound) {
            return null;
        }
        catch (Unauthorized unauthorized) {
            return null;
        }
    }

    @Override
    public List<TagModel> getAllTags() {
        return this._batchService.getAllTags();
    }

    @Override
    public List<TagModel> getTags(List<String> tagIds) {
        List unordered = this._batchService.getTags(tagIds);
        HashMap<String, TagModel> modelById = new HashMap<String, TagModel>(unordered.size());
        for (TagModel model : unordered) {
            modelById.put(model.getId(), model);
        }
        ArrayList<TagModel> ordered = new ArrayList<TagModel>(unordered.size());
        for (String id : tagIds) {
            TagModel model = (TagModel)modelById.get(id);
            if (model == null) continue;
            ordered.add(model);
        }
        return ordered;
    }

    @Override
    public List<String> findTagsByName(String tagNamePattern) {
        assert (tagNamePattern != null);
        return this._batchService.findTagsByName(tagNamePattern);
    }

    @Override
    public List<String> listCategories() {
        return this._categoryService.list();
    }

    @Override
    public CategoryModel getCategory(String categoryId) {
        assert (categoryId != null);
        try {
            return this._categoryService.get(categoryId);
        }
        catch (NotFound notFound) {
            return null;
        }
        catch (Unauthorized unauthorized) {
            return null;
        }
    }

    @Override
    public List<CategoryModel> getAllCategories() {
        return this._batchService.getAllCategories();
    }

    @Override
    public List<CategoryModel> getCategories(List<String> categoryIds) {
        List unordered = this._batchService.getCategories(categoryIds);
        HashMap<String, CategoryModel> modelById = new HashMap<String, CategoryModel>(unordered.size());
        for (CategoryModel model : unordered) {
            modelById.put(model.getId(), model);
        }
        ArrayList<CategoryModel> ordered = new ArrayList<CategoryModel>(unordered.size());
        for (String id : categoryIds) {
            CategoryModel model = (CategoryModel)modelById.get(id);
            if (model == null) continue;
            ordered.add(model);
        }
        return ordered;
    }

    @Override
    public List<String> listTagsForCategory(String categoryId) {
        assert (categoryId != null);
        try {
            return this._tagService.listTagsForCategory(categoryId);
        }
        catch (NotFound notFound) {
            return null;
        }
        catch (Unauthorized unauthorized) {
            return null;
        }
    }

    @Override
    public List<String> listAttachedTags(List<DynamicID> objectIds) {
        assert (objectIds != null);
        try {
            return this._batchService.listAttachedTags(objectIds);
        }
        catch (Unauthorized unauthorized) {
            return Collections.emptyList();
        }
    }

    @Override
    public List<DynamicID> listAttachedObjects(List<String> tagIds) {
        assert (tagIds != null);
        try {
            return this._batchService.listAttachedObjects(tagIds);
        }
        catch (NotFound notFound) {
            return Collections.emptyList();
        }
        catch (Unauthorized unauthorized) {
            return Collections.emptyList();
        }
    }

    @Override
    public List<BatchTypes.TagToObjects> listAllAttachedObjectsOnTags() {
        try {
            return this._batchService.listAllAttachedObjectsOnTags();
        }
        catch (Unauthorized unauthorized) {
            return Collections.emptyList();
        }
    }

    @Override
    public List<BatchTypes.TagToObjects> listAttachedObjectsOnTags(List<String> tagIds) {
        assert (tagIds != null);
        try {
            return this._batchService.listAttachedObjectsOnTags(tagIds);
        }
        catch (NotFound notFound) {
            return Collections.emptyList();
        }
        catch (Unauthorized unauthorized) {
            return Collections.emptyList();
        }
    }

    @Override
    public List<BatchTypes.ObjectToTags> listAttachedTagsOnObjects(List<DynamicID> objectIds) {
        assert (objectIds != null);
        try {
            return this._batchService.listAttachedTagsOnObjects(objectIds);
        }
        catch (NotFound notFound) {
            return Collections.emptyList();
        }
        catch (Unauthorized unauthorized) {
            return Collections.emptyList();
        }
    }
}

