/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.util.vapi;

import com.vmware.cis.Session;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiInvocationSecurity;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiOsgiAwareStubFactory;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiSessionSource;
import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.std.errors.Unauthenticated;

public final class CisSessionVapiSessionSource
implements VapiSessionSource {
    private final Session _sessionManager;
    private final AuthenticationTokenSource _credentials;

    public CisSessionVapiSessionSource(ApiProvider api, AuthenticationTokenSource credentials) {
        assert (api != null);
        assert (credentials != null);
        this._sessionManager = new VapiOsgiAwareStubFactory(api).createStub(Session.class);
        this._credentials = credentials;
    }

    @Override
    public char[] createSession() {
        return this._sessionManager.create(VapiInvocationSecurity.cfgWithToken(this._credentials));
    }

    @Override
    public void deleteSession(char[] sessionId) {
        if (sessionId == null) {
            return;
        }
        try {
            this._sessionManager.delete(VapiInvocationSecurity.cfgWithSessionId(sessionId));
        }
        catch (Unauthenticated unauthenticated) {
            // empty catch block
        }
    }
}

