/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.util.vapi;

import com.vmware.cis.data.internal.adapters.lookup.ServiceEndpointInfo;
import com.vmware.cis.data.internal.adapters.util.vapi.CisSessionVapiAuthenticator;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiAuthenticator;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiAuthenticatorFactory;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiProtocolConnectionFactory;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultVapiAuthenticatorFactory
implements VapiAuthenticatorFactory {
    private static final Logger _logger = LoggerFactory.getLogger(DefaultVapiAuthenticatorFactory.class);
    private final VapiProtocolConnectionFactory _connectionFactory;
    private final VapiAuthenticatorFactory _customAuthFactory;

    public DefaultVapiAuthenticatorFactory(VapiProtocolConnectionFactory connectionFactory, VapiAuthenticatorFactory customAuthFactory) {
        Validate.notNull((Object)connectionFactory);
        this._connectionFactory = connectionFactory;
        this._customAuthFactory = customAuthFactory;
    }

    @Override
    public VapiAuthenticator getAuthenticator(ServiceEndpointInfo serviceEndpointInfo) {
        Validate.notNull((Object)serviceEndpointInfo);
        if (!DefaultVapiAuthenticatorFactory.isVapiService(serviceEndpointInfo)) {
            throw new IllegalArgumentException("Expected vAPI service but found: " + serviceEndpointInfo);
        }
        VapiAuthenticator custom = this.getCustomAuthenticator(serviceEndpointInfo);
        if (custom != null) {
            _logger.debug("Using custom authenticator {} for endpoint: {}", (Object)custom, (Object)serviceEndpointInfo);
            return custom;
        }
        _logger.debug("Using com.vmware.cis.Session authenticator for endpoint: {}", (Object)serviceEndpointInfo);
        return new CisSessionVapiAuthenticator(this._connectionFactory, serviceEndpointInfo.getUrl(), serviceEndpointInfo.getTrustStore());
    }

    private static boolean isVapiService(ServiceEndpointInfo serviceEndpointInfo) {
        String protocol = serviceEndpointInfo.getEndpointProtocol();
        return "vapi.json.https".equals(protocol) || "vapi.json.http".equals(protocol);
    }

    private VapiAuthenticator getCustomAuthenticator(ServiceEndpointInfo serviceEndpointInfo) {
        if (this._customAuthFactory == null) {
            return null;
        }
        return this._customAuthFactory.getAuthenticator(serviceEndpointInfo);
    }
}

