/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.util.vapi;

import com.vmware.cis.data.internal.adapters.util.vapi.SessionAwareAsyncHandle;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiInvocationSecurity;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiInvokeCommand;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiSession;
import com.vmware.cis.data.internal.util.QueryMarker;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import java.util.HashMap;

public final class SessionAwareApiProvider
implements ApiProvider {
    private final ApiProvider _api;
    private final VapiSession _session;

    public SessionAwareApiProvider(ApiProvider api, VapiSession session) {
        assert (api != null);
        assert (session != null);
        this._api = api;
        this._session = session;
    }

    public void invoke(String serviceId, String operationId, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle) {
        VapiInvokeCommand invocation = new VapiInvokeCommand(this._api, serviceId, operationId, input);
        char[] sessionId = this._session.get();
        ExecutionContext.ApplicationData appData = this.createApplicationData(ctx);
        ExecutionContext ctxWithSession = VapiInvocationSecurity.ctxWithSessionId(sessionId, appData);
        SessionAwareAsyncHandle reloginCallback = new SessionAwareAsyncHandle(asyncHandle, this._session, invocation, appData, sessionId);
        invocation.execute(ctxWithSession, (AsyncHandle<MethodResult>)reloginCallback);
    }

    private ExecutionContext.ApplicationData createApplicationData(ExecutionContext ctx) {
        ExecutionContext.ApplicationData appData = ctx.retrieveApplicationData();
        String queryId = QueryMarker.getQueryId();
        if (queryId == null) {
            return appData;
        }
        HashMap<String, String> properties = appData == null ? new HashMap<String, String>() : new HashMap(appData.getAllProperties());
        properties.put("opId", queryId);
        return new ExecutionContext.ApplicationData(properties);
    }
}

