/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.util.vapi;

import com.vmware.cis.data.internal.adapters.util.vapi.VapiInvocationSecurity;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiInvokeCommand;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiSession;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.util.async.DecoratorAsyncHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SessionAwareAsyncHandle
extends DecoratorAsyncHandle<MethodResult> {
    private static Logger _logger = LoggerFactory.getLogger(SessionAwareAsyncHandle.class);
    private final VapiSession _session;
    private final VapiInvokeCommand _invocation;
    private final ExecutionContext.ApplicationData _appData;
    private final char[] _sessionId;

    SessionAwareAsyncHandle(AsyncHandle<MethodResult> asyncHandle, VapiSession session, VapiInvokeCommand invocation, ExecutionContext.ApplicationData appData, char[] sessionId) {
        super(asyncHandle);
        assert (session != null);
        assert (invocation != null);
        assert (appData != null);
        assert (sessionId != null);
        this._session = session;
        this._invocation = invocation;
        this._appData = appData;
        this._sessionId = sessionId;
    }

    public void setResult(MethodResult result) {
        assert (result != null);
        try {
            this.setResultThrowing(result);
        }
        catch (RuntimeException ex) {
            super.setError(ex);
        }
    }

    private void setResultThrowing(MethodResult result) {
        assert (result != null);
        if (SessionAwareAsyncHandle.isUnauthenticated(result)) {
            _logger.info("Operation {}.{} failed with Unauthenticated. Will re-login and retry.", (Object)this._invocation.getServiceId(), (Object)this._invocation.getOperationId());
            char[] newSessionId = this._session.renew(this._sessionId);
            this._invocation.execute(VapiInvocationSecurity.ctxWithSessionId(newSessionId, this._appData), (AsyncHandle<MethodResult>)this.decorated);
        } else {
            super.setResult((Object)result);
        }
    }

    private static boolean isUnauthenticated(MethodResult result) {
        assert (result != null);
        ErrorValue errorValue = result.getError();
        return errorValue != null && "com.vmware.vapi.std.errors.unauthenticated".equals(errorValue.getName());
    }
}

