/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vapi.impl;

import com.vmware.cis.data.internal.adapters.util.vapi.SessionAwareApiProvider;
import com.vmware.cis.data.internal.adapters.util.vapi.SessionAwareVapiConnectionCloseable;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiAuthenticator;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiSession;
import com.vmware.cis.data.internal.adapters.vapi.VapiDataProviderConfig;
import com.vmware.cis.data.internal.adapters.vapi.impl.VapiDataProviderConnection;
import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.cis.data.internal.provider.DataProviderConnection;
import com.vmware.cis.data.internal.provider.DataProviderConnector;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.vapi.protocol.ProtocolConnection;
import java.net.URI;
import java.security.KeyStore;
import org.apache.commons.lang.Validate;

public final class VapiDataProvider
implements DataProviderConnector {
    private final URI _uri;
    private final KeyStore _trustStore;
    private final VapiDataProviderConfig _cfg;
    private final VapiAuthenticator _authenticator;

    public VapiDataProvider(URI uri, KeyStore trustStore, VapiDataProviderConfig cfg, VapiAuthenticator authenticator) {
        Validate.notNull((Object)uri);
        Validate.notNull((Object)cfg);
        Validate.notNull((Object)authenticator);
        this._uri = uri;
        this._trustStore = trustStore;
        this._cfg = cfg;
        this._authenticator = authenticator;
    }

    public DataProviderConnection getConnection(AuthenticationTokenSource authn) {
        Validate.notNull((Object)authn);
        VapiSession session = this._authenticator.login(authn);
        ProtocolConnection connection = this._cfg.getVApiConnectionFactory().connect(this._uri, this._trustStore);
        SessionAwareApiProvider apiProvider = new SessionAwareApiProvider(connection.getApiProvider(), session);
        final SessionAwareVapiConnectionCloseable vapiConnection = new SessionAwareVapiConnectionCloseable(connection, session);
        final VapiDataProviderConnection vapiProvider = new VapiDataProviderConnection(apiProvider, this._cfg);
        return new DataProviderConnection(){

            public void close() throws Exception {
                vapiConnection.close();
            }

            public DataProvider getDataProvider() {
                return vapiProvider;
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(url=" + this._uri + ")";
    }
}

