/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vapi.impl;

import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.adapters.vapi.VapiPropertyValueConverter;
import com.vmware.cis.data.provider.vapi.ResourceModelTypes;
import com.vmware.vapi.data.DataValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;

final class VapiDataProviderResultSetConverter {
    private final VapiPropertyValueConverter _propertyValueConverter;

    VapiDataProviderResultSetConverter(VapiPropertyValueConverter propertyValueConverter) {
        assert (propertyValueConverter != null);
        this._propertyValueConverter = propertyValueConverter;
    }

    public ResultSet convertResultSet(ResourceModelTypes.ResultSet vapiResultSet, int limit, boolean withTotalCount) {
        Validate.notNull((Object)vapiResultSet);
        List<Object> items = limit == 0 ? Collections.emptyList() : this.convertItems(vapiResultSet.getItems(), vapiResultSet.getProperties());
        Integer totalCount = VapiDataProviderResultSetConverter.getTotalCount(vapiResultSet, withTotalCount);
        return new ResultSet(vapiResultSet.getProperties(), items, totalCount);
    }

    private static Integer getTotalCount(ResourceModelTypes.ResultSet vapiResultSet, boolean withTotalCount) {
        if (withTotalCount) {
            if (vapiResultSet.getTotalCount() == null) {
                throw new IllegalArgumentException("Response does not contain total item count");
            }
            return vapiResultSet.getTotalCount().intValue();
        }
        return null;
    }

    private List<ResourceItem> convertItems(List<ResourceModelTypes.ResourceItem> vapiItems, List<String> vapiProperties) {
        if (vapiItems == null) {
            return Collections.emptyList();
        }
        ArrayList<ResourceItem> items = new ArrayList<ResourceItem>(vapiItems.size());
        for (ResourceModelTypes.ResourceItem vapiItem : vapiItems) {
            ResourceItem item = this.convertItem(vapiItem, vapiProperties);
            items.add(item);
        }
        return items;
    }

    private ResourceItem convertItem(ResourceModelTypes.ResourceItem vapiItem, List<String> vapiProperties) {
        Validate.notEmpty(vapiProperties);
        if (vapiProperties.size() != vapiItem.getPropertyValues().size()) {
            throw new IllegalArgumentException(String.format("The number of property values in a vAPI ResourceItem does not match the number of properties in the vAPI ResultSet: %d != %d", vapiItem.getPropertyValues().size(), vapiProperties.size()));
        }
        ArrayList<Object> values = new ArrayList<Object>(vapiItem.getPropertyValues().size());
        Iterator<String> iterator = vapiProperties.iterator();
        for (DataValue propertyValue : vapiItem.getPropertyValues()) {
            String propertyName = iterator.next();
            Object value = this._propertyValueConverter.fromVapiResultDataValue(propertyName, propertyValue);
            values.add(value);
        }
        return new ResourceItem(values);
    }
}

