/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vmomi.impl;

import com.vmware.cis.data.internal.adapters.vmomi.VmomiAuthenticator;
import com.vmware.cis.data.internal.adapters.vmomi.VmomiDataProviderConfig;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VlsiClientUtil;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VmomiDataProviderConnection;
import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.cis.data.internal.provider.DataProviderConnection;
import com.vmware.cis.data.internal.provider.DataProviderConnector;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.vim.binding.cis.data.provider.version.internal.versions;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import java.net.URI;
import java.security.KeyStore;
import org.apache.commons.lang.Validate;

public final class VmomiDataProvider
implements DataProviderConnector {
    private final VmomiDataProviderConfig _providerCfg;
    private final URI _endpointAddress;
    private final KeyStore _trustStore;
    private final VmomiAuthenticator _authenticator;

    public VmomiDataProvider(VmomiDataProviderConfig providerCfg, URI endpointAddress, KeyStore trustStore, VmomiAuthenticator authenticator) {
        Validate.notNull((Object)providerCfg, (String)"Argument `providerCfg' is required.");
        Validate.notNull((Object)endpointAddress, (String)"Argument `endpointAddress' is required.");
        Validate.notNull((Object)authenticator, (String)"Argument `authenticator' is required.");
        this._providerCfg = providerCfg;
        this._endpointAddress = endpointAddress;
        this._trustStore = trustStore;
        this._authenticator = authenticator;
    }

    public DataProviderConnection getConnection(AuthenticationTokenSource credentials) {
        Validate.notNull((Object)credentials);
        Class version = this._providerCfg.getUseUnstableVersion() ? versions.CIS_DATA_PROVIDER_VERSION_NEWEST : versions.CIS_DATA_PROVIDER_VERSION_STABLE;
        HttpConfiguration httpConfig = this._providerCfg.getVlsiHttpConfigFactory().createConfiguration(this._endpointAddress, this._trustStore);
        final Client vlsiClient = VlsiClientUtil.createAuthenticatedVlsiClient(this._endpointAddress, httpConfig, this._providerCfg.getVmodlContext(), this._authenticator, credentials, version);
        final VmomiDataProviderConnection vmomiProvider = new VmomiDataProviderConnection(vlsiClient);
        return new DataProviderConnection(){

            public void close() throws Exception {
                vlsiClient.shutdown();
            }

            public DataProvider getDataProvider() {
                return vmomiProvider;
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(url=" + this._endpointAddress + ")";
    }
}

