/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vmomi.impl;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.adapters.vmomi.util.VmomiProperty;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.vim.binding.cis.data.provider.Filter;
import com.vmware.vim.binding.cis.data.provider.PropertyPredicate;
import com.vmware.vim.binding.cis.data.provider.QuerySpec;
import com.vmware.vim.binding.cis.data.provider.SortCriterion;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class VmomiDataProviderQueryConverter {
    private static final Logger _logger = LoggerFactory.getLogger(VmomiDataProviderQueryConverter.class);
    static final String TYPE_MANAGED_OBJECT = "ManagedObject";

    VmomiDataProviderQueryConverter() {
    }

    public static QuerySpec convertQuery(Query query) {
        assert (query != null);
        String resourceModel = VmomiDataProviderQueryConverter.getQueryResourceModel(query);
        QuerySpec vmomiQuery = new QuerySpec();
        vmomiQuery.setResourceModel(resourceModel);
        if (query.getFilter() != null) {
            com.vmware.vim.binding.cis.data.provider.Filter vmomiFilter = VmomiDataProviderQueryConverter.convertFilter(query.getFilter(), resourceModel);
            if (vmomiFilter == null) {
                return null;
            }
            vmomiQuery.setFilter(vmomiFilter);
        }
        vmomiQuery.setOffset(VmomiDataProviderQueryConverter.convertOffset(query));
        vmomiQuery.setLimit(VmomiDataProviderQueryConverter.convertLimit(query));
        vmomiQuery.setReturnTotalCount(Boolean.valueOf(query.getWithTotalCount()));
        if (query.getLimit() == 0) {
            vmomiQuery.setProperties(new String[]{"@modelKey"});
            vmomiQuery.setSortCriteria(new SortCriterion[]{VmomiDataProviderQueryConverter.stubSortForTotalCountQuery()});
        } else {
            vmomiQuery.setProperties(VmomiDataProviderQueryConverter.convertProperties(query.getProperties()));
            vmomiQuery.setSortCriteria(VmomiDataProviderQueryConverter.convertSortCriteria(query.getSortCriteria()));
        }
        return vmomiQuery;
    }

    private static String getQueryResourceModel(Query query) {
        assert (query.getResourceModels().size() <= 1);
        return (String)query.getResourceModels().get(0);
    }

    private static com.vmware.vim.binding.cis.data.provider.Filter convertFilter(Filter filter, String resourceModel) {
        com.vmware.vim.binding.cis.data.provider.Filter vmomiFilter = new com.vmware.vim.binding.cis.data.provider.Filter();
        vmomiFilter.setOperator(VmomiDataProviderQueryConverter.convertLogicalOperator(filter.getOperator()).name());
        com.vmware.vim.binding.cis.data.provider.PropertyPredicate[] vmomiPredicates = VmomiDataProviderQueryConverter.convertPropertyPredicates(filter.getCriteria(), filter.getOperator(), resourceModel);
        if (vmomiPredicates == null) {
            return null;
        }
        vmomiFilter.setCriteria(vmomiPredicates);
        return vmomiFilter;
    }

    private static Filter.LogicalOperator convertLogicalOperator(LogicalOperator operator) {
        assert (operator != null);
        switch (operator) {
            case AND: {
                return Filter.LogicalOperator.AND;
            }
            case OR: {
                return Filter.LogicalOperator.OR;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported logical operator: '%s'", operator.name()));
    }

    private static com.vmware.vim.binding.cis.data.provider.PropertyPredicate[] convertPropertyPredicates(List<PropertyPredicate> predicates, LogicalOperator operator, String resourceModel) {
        assert (predicates != null);
        assert (predicates.size() > 0);
        ArrayList<com.vmware.vim.binding.cis.data.provider.PropertyPredicate> vmomiPredicates = new ArrayList<com.vmware.vim.binding.cis.data.provider.PropertyPredicate>();
        for (PropertyPredicate predicate : predicates) {
            com.vmware.vim.binding.cis.data.provider.PropertyPredicate vmomiPredicate = VmomiDataProviderQueryConverter.convertPropertyPredicate(predicate, resourceModel);
            if (vmomiPredicate != null) {
                vmomiPredicates.add(vmomiPredicate);
                continue;
            }
            if (LogicalOperator.OR.equals((Object)operator)) continue;
            return null;
        }
        return vmomiPredicates.isEmpty() ? null : vmomiPredicates.toArray(new com.vmware.vim.binding.cis.data.provider.PropertyPredicate[vmomiPredicates.size()]);
    }

    private static com.vmware.vim.binding.cis.data.provider.PropertyPredicate convertPropertyPredicate(PropertyPredicate predicate, String resourceModel) {
        assert (predicate != null);
        assert (predicate.getComparableValue() != null);
        String property = predicate.getProperty();
        Object comparableValue = predicate.getComparableValue();
        PropertyPredicate.ComparisonOperator operator = predicate.getOperator();
        boolean isModelKey = PropertyUtil.isModelKey((String)property);
        boolean isForeignKey = VmomiProperty.isForeignKey(property);
        com.vmware.vim.binding.cis.data.provider.PropertyPredicate vmomiPredicate = new com.vmware.vim.binding.cis.data.provider.PropertyPredicate();
        vmomiPredicate.setProperty(VmomiDataProviderQueryConverter.convertProperty(property));
        vmomiPredicate.setOperator(VmomiDataProviderQueryConverter.convertComparisonOperator(operator).name());
        if (PropertyPredicate.ComparisonOperator.IN.equals((Object)predicate.getOperator())) {
            Object[] compList = VmomiDataProviderQueryConverter.convertComparableList(comparableValue, isModelKey, isForeignKey, resourceModel);
            if (compList == null) {
                return null;
            }
            vmomiPredicate.setComparableList(compList);
        } else {
            Object compValue = VmomiDataProviderQueryConverter.convertComparableValue(comparableValue, isModelKey, isForeignKey, resourceModel);
            if (compValue == null) {
                return null;
            }
            vmomiPredicate.setComparableValue(compValue);
        }
        vmomiPredicate.setIgnoreCase(predicate.isIgnoreCase() ? Boolean.TRUE : null);
        return vmomiPredicate;
    }

    private static PropertyPredicate.ComparisonOperator convertComparisonOperator(PropertyPredicate.ComparisonOperator operator) {
        assert (operator != null);
        switch (operator) {
            case EQUAL: {
                return PropertyPredicate.ComparisonOperator.EQUAL;
            }
            case NOT_EQUAL: {
                return PropertyPredicate.ComparisonOperator.NOT_EQUAL;
            }
            case GREATER: {
                return PropertyPredicate.ComparisonOperator.GREATER;
            }
            case GREATER_OR_EQUAL: {
                return PropertyPredicate.ComparisonOperator.GREATER_OR_EQUAL;
            }
            case LESS: {
                return PropertyPredicate.ComparisonOperator.LESS;
            }
            case LESS_OR_EQUAL: {
                return PropertyPredicate.ComparisonOperator.LESS_OR_EQUAL;
            }
            case IN: {
                return PropertyPredicate.ComparisonOperator.IN;
            }
            case LIKE: {
                return PropertyPredicate.ComparisonOperator.LIKE;
            }
            case UNSET: {
                return PropertyPredicate.ComparisonOperator.UNSET;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported comparison operator: '%s'", operator.name()));
    }

    private static Object[] convertComparableList(Object comparableValue, boolean isModelKey, boolean isForeignKey, String resourceModel) {
        List<?> comparableList = VmomiDataProviderQueryConverter.getComparableList(comparableValue);
        ArrayList<Object> vmomiComparableList = new ArrayList<Object>();
        for (Object comparableElement : comparableList) {
            Object compValue = VmomiDataProviderQueryConverter.convertComparableValue(comparableElement, isModelKey, isForeignKey, resourceModel);
            if (compValue == null) continue;
            vmomiComparableList.add(compValue);
        }
        if (vmomiComparableList.isEmpty()) {
            return null;
        }
        return vmomiComparableList.toArray(new Object[vmomiComparableList.size()]);
    }

    private static Object convertComparableValue(Object comparableValue, boolean isModelKey, boolean isForeignKey, String resourceModel) {
        if (isModelKey) {
            return VmomiDataProviderQueryConverter.convertModelKeyValue(comparableValue, resourceModel);
        }
        if (isForeignKey) {
            return VmomiDataProviderQueryConverter.convertForeignKeyValue(comparableValue);
        }
        return comparableValue;
    }

    private static List<?> getComparableList(Object comparableValue) {
        assert (comparableValue instanceof List);
        List comparableList = (List)comparableValue;
        assert (comparableList.size() > 0);
        return comparableList;
    }

    private static ManagedObjectReference convertForeignKeyValue(Object value) {
        Validate.isTrue((boolean)(value instanceof String), (String)"When the property '@moId' is used, the identifier have to be represented in string format.");
        ManagedObjectReference mor = null;
        try {
            mor = CisIdConverter.fromGlobalCisId((String)((String)value), (String)TYPE_MANAGED_OBJECT);
        }
        catch (IllegalArgumentException iae) {
            _logger.warn("Error has occurred while converting foreign key comparable value", (Throwable)iae);
        }
        return mor;
    }

    private static ManagedObjectReference convertModelKeyValue(Object comparableValue, String resourceModel) {
        if (comparableValue instanceof ManagedObjectReference) {
            return (ManagedObjectReference)comparableValue;
        }
        assert (comparableValue instanceof String);
        ManagedObjectReference mor = null;
        try {
            mor = CisIdConverter.fromGlobalCisId((String)((String)comparableValue), (String)resourceModel);
        }
        catch (IllegalArgumentException iae) {
            _logger.warn("Error has occurred while converting model key comparable value", (Throwable)iae);
        }
        return mor;
    }

    private static String[] convertProperties(List<String> properties) {
        assert (properties != null);
        ArrayList<String> vmomiProperties = new ArrayList<String>(properties.size());
        boolean includedModelKey = false;
        for (String property : properties) {
            String vmomiProperty = VmomiDataProviderQueryConverter.convertProperty(property);
            if (PropertyUtil.isModelKey((String)vmomiProperty)) {
                if (includedModelKey) continue;
                includedModelKey = true;
            }
            vmomiProperties.add(vmomiProperty);
        }
        return vmomiProperties.toArray(new String[vmomiProperties.size()]);
    }

    private static String convertProperty(String property) {
        return VmomiProperty.toVmomiProperty(property);
    }

    private static SortCriterion[] convertSortCriteria(List<com.vmware.cis.data.api.SortCriterion> criteria) {
        assert (criteria != null);
        if (criteria.isEmpty()) {
            return null;
        }
        SortCriterion[] vmomiSortCriteria = new SortCriterion[criteria.size()];
        int i = 0;
        for (com.vmware.cis.data.api.SortCriterion criterion : criteria) {
            vmomiSortCriteria[i++] = VmomiDataProviderQueryConverter.convertSortCriterion(criterion);
        }
        return vmomiSortCriteria;
    }

    private static SortCriterion convertSortCriterion(com.vmware.cis.data.api.SortCriterion criterion) {
        assert (criterion != null);
        assert (criterion.getProperty() != null);
        assert (criterion.getProperty().length() > 0);
        assert (criterion.getSortDirection() != null);
        SortCriterion vmomiSort = new SortCriterion();
        vmomiSort.setProperty(VmomiDataProviderQueryConverter.convertProperty(criterion.getProperty()));
        vmomiSort.setSortDirection(VmomiDataProviderQueryConverter.convertSortDirection(criterion.getSortDirection()).name());
        vmomiSort.setIgnoreCase(criterion.isIgnoreCase() ? Boolean.TRUE : null);
        return vmomiSort;
    }

    private static SortCriterion.SortDirection convertSortDirection(SortCriterion.SortDirection sortDirection) {
        assert (sortDirection != null);
        switch (sortDirection) {
            case ASCENDING: {
                return SortCriterion.SortDirection.ASCENDING;
            }
            case DESCENDING: {
                return SortCriterion.SortDirection.DESCENDING;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported sort direction: '%s'", sortDirection.name()));
    }

    private static Integer convertOffset(Query query) {
        assert (query.getOffset() >= 0);
        int offset = query.getOffset();
        if (offset == 0) {
            return null;
        }
        assert (query.getSortCriteria() != null);
        assert (query.getSortCriteria().size() > 0);
        return offset;
    }

    private static Integer convertLimit(Query query) {
        int limit = query.getLimit();
        if (limit < 0) {
            return null;
        }
        assert (query.getSortCriteria() != null);
        assert (query.getLimit() == 0 || query.getSortCriteria().size() > 0);
        return limit;
    }

    private static SortCriterion stubSortForTotalCountQuery() {
        SortCriterion sortCriterion = new SortCriterion();
        sortCriterion.setProperty("@modelKey");
        return sortCriterion;
    }
}

