/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vmomi.impl;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.adapters.vmomi.util.VmomiProperty;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.vim.binding.cis.data.provider.OptionalPropertyValue;
import com.vmware.vim.binding.cis.data.provider.QuerySpec;
import com.vmware.vim.binding.cis.data.provider.ResourceItem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

final class VmomiDataProviderResultSetConverter {
    VmomiDataProviderResultSetConverter() {
    }

    public static ResultSet convertResultSet(com.vmware.vim.binding.cis.data.provider.ResultSet vmomiResultSet, QuerySpec vmomiQuery, Query query) {
        Validate.notNull((Object)vmomiResultSet);
        Validate.notNull((Object)query);
        Validate.notNull((Object)vmomiQuery);
        List properties = query.getProperties();
        List<Object> items = query.getLimit() == 0 ? Collections.emptyList() : VmomiDataProviderResultSetConverter.convertItems(vmomiResultSet.getItems(), vmomiResultSet.getProperties(), properties);
        Integer totalCount = VmomiDataProviderResultSetConverter.getTotalCount(vmomiResultSet, query.getWithTotalCount());
        return new ResultSet(properties, items, totalCount);
    }

    private static Integer getTotalCount(com.vmware.vim.binding.cis.data.provider.ResultSet vmomiResultSet, boolean withTotalCount) {
        if (withTotalCount) {
            if (vmomiResultSet.getTotalCount() == null) {
                throw new IllegalArgumentException("Response does not contain total item count");
            }
            return vmomiResultSet.getTotalCount().intValue();
        }
        return null;
    }

    private static List<com.vmware.cis.data.api.ResourceItem> convertItems(ResourceItem[] vmomiItems, String[] vmomiProperties, List<String> coreProperties) {
        if (vmomiItems == null) {
            return Collections.emptyList();
        }
        ArrayList<com.vmware.cis.data.api.ResourceItem> items = new ArrayList<com.vmware.cis.data.api.ResourceItem>(vmomiItems.length);
        for (int i = 0; i < vmomiItems.length; ++i) {
            com.vmware.cis.data.api.ResourceItem item = VmomiDataProviderResultSetConverter.convertItem(vmomiItems[i], vmomiProperties, coreProperties);
            items.add(item);
        }
        return items;
    }

    private static com.vmware.cis.data.api.ResourceItem convertItem(ResourceItem vmomiItem, String[] vmomiProperties, List<String> coreProperties) {
        Validate.notNull((Object)vmomiItem);
        Validate.notNull((Object)vmomiProperties);
        Validate.notNull(coreProperties);
        OptionalPropertyValue[] vmomiValues = vmomiItem.getPropertyValues();
        if (vmomiValues.length != vmomiProperties.length) {
            throw new IllegalArgumentException(String.format("The number of property value in a VMOMI ResourceItem does not match the number of properties in the VMOMI ResultSet: %d != %d", vmomiValues.length, vmomiProperties.length));
        }
        Map<String, Object> vmomiValueByProperty = VmomiDataProviderResultSetConverter.toVmomiValueByProperty(vmomiItem, vmomiProperties);
        ArrayList<Object> coreValues = new ArrayList<Object>(coreProperties.size());
        for (String coreProperty : coreProperties) {
            String vmomiProperty = VmomiProperty.toVmomiProperty(coreProperty);
            Object vmomiValue = vmomiValueByProperty.get(vmomiProperty);
            Object coreValue = VmomiDataProviderResultSetConverter.convertPropertyValue(coreProperty, vmomiValue);
            coreValues.add(coreValue);
        }
        return new com.vmware.cis.data.api.ResourceItem(coreValues);
    }

    private static Map<String, Object> toVmomiValueByProperty(ResourceItem vmomiItem, String[] vmomiProperties) {
        assert (vmomiItem != null);
        assert (vmomiItem.getPropertyValues() != null);
        assert (vmomiProperties != null);
        assert (vmomiProperties.length == vmomiItem.getPropertyValues().length);
        OptionalPropertyValue[] vmomiValues = vmomiItem.getPropertyValues();
        HashMap<String, Object> valueByProperty = new HashMap<String, Object>(vmomiProperties.length);
        for (int i = 0; i < vmomiProperties.length; ++i) {
            String vmomiProperty = vmomiProperties[i];
            OptionalPropertyValue vmomiValue = vmomiValues[i];
            valueByProperty.put(vmomiProperty, vmomiValue.getValue());
        }
        return valueByProperty;
    }

    private static Object convertPropertyValue(String coreProperty, Object vmomiValue) {
        assert (coreProperty != null);
        Object coreValue = null;
        if (PropertyUtil.isType((String)coreProperty)) {
            ManagedObjectReference mor = VmomiDataProviderResultSetConverter.getMor(vmomiValue);
            if (mor != null) {
                coreValue = mor.getType();
            }
        } else {
            coreValue = VmomiProperty.isForeignKey(coreProperty) ? VmomiDataProviderResultSetConverter.convertToCisId(vmomiValue) : vmomiValue;
        }
        return coreValue;
    }

    private static Object convertToCisId(Object vmomiValue) {
        if (vmomiValue == null) {
            return null;
        }
        if (vmomiValue instanceof ManagedObjectReference[]) {
            ManagedObjectReference[] mors = (ManagedObjectReference[])vmomiValue;
            String[] cisIds = new String[mors.length];
            int i = 0;
            for (ManagedObjectReference mor : mors) {
                String cisId = CisIdConverter.toGlobalCisId((ManagedObjectReference)mor, (String)mor.getServerGuid());
                cisIds[i++] = cisId;
            }
            return cisIds;
        }
        ManagedObjectReference mor = VmomiDataProviderResultSetConverter.getMor(vmomiValue);
        String cisId = CisIdConverter.toGlobalCisId((ManagedObjectReference)mor, (String)mor.getServerGuid());
        return cisId;
    }

    private static ManagedObjectReference getMor(Object vmomiValue) {
        if (vmomiValue == null) {
            return null;
        }
        if (!(vmomiValue instanceof ManagedObjectReference)) {
            throw new IllegalArgumentException(String.format("VMOMI ResourceItem contains invalid model key value of class %s", vmomiValue.getClass().getCanonicalName()));
        }
        return (ManagedObjectReference)vmomiValue;
    }
}

