/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.data;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.data.VimObjectReferenceService;
import java.util.ArrayList;
import java.util.List;

@type(value="vsphere:client")
public class ClientDataAdapter
implements DataProviderAdapter {
    public static final String OBJECT_TYPE = "vsphere:client";
    private VimObjectReferenceService _objectRefService;
    private static ResultItem _sharedResultItem;

    public ClientDataAdapter(VimObjectReferenceService vimObjectReferenceService) {
        if (vimObjectReferenceService == null) {
            throw new IllegalArgumentException("VimObjectReferenceService cannot be null.");
        }
        this._objectRefService = vimObjectReferenceService;
        _sharedResultItem = this.createResultItem();
    }

    public Response getData(RequestSpec requestSpec) {
        if (requestSpec == null) {
            throw new IllegalArgumentException("RequestSpec cannot be null.");
        }
        ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>();
        for (QuerySpec querySpec : requestSpec.querySpec) {
            if (!this.processConstraints(querySpec.resourceSpec.constraint).booleanValue()) continue;
            ResultSet resultSet = this.createResultSet(querySpec);
            arrayList.add(resultSet);
        }
        Response response = this.createResponse(arrayList);
        return response;
    }

    private Boolean processConstraints(Constraint constraint) {
        if (constraint instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)constraint;
            if (OBJECT_TYPE.equals(objectIdentityConstraint.targetType)) {
                return true;
            }
        } else {
            if (constraint instanceof CompositeConstraint) {
                CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
                return this.processCompositeConstraint(compositeConstraint);
            }
            if (constraint.getClass().getSimpleName().equals(Constraint.class.getSimpleName()) && OBJECT_TYPE.equals(constraint.targetType)) {
                return true;
            }
        }
        return false;
    }

    private Boolean processCompositeConstraint(CompositeConstraint compositeConstraint) {
        Boolean bl = false;
        if (compositeConstraint.conjoiner == Conjoiner.OR) {
            for (Constraint constraint : compositeConstraint.nestedConstraints) {
                bl = bl != false || this.processConstraints(constraint) != false;
            }
        } else {
            bl = true;
            for (Constraint constraint : compositeConstraint.nestedConstraints) {
                bl = bl != false && this.processConstraints(constraint) != false;
            }
        }
        return bl;
    }

    private ResultItem createResultItem() {
        Object object = this._objectRefService.getReference(OBJECT_TYPE, "0", null);
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = object;
        return resultItem;
    }

    private ResultSet createResultSet(QuerySpec querySpec) {
        ResultSet resultSet = new ResultSet();
        resultSet.items = new ResultItem[1];
        resultSet.items[0] = _sharedResultItem;
        resultSet.totalMatchedObjectCount = 1;
        resultSet.queryName = querySpec.name;
        return resultSet;
    }

    private Response createResponse(List<ResultSet> list) {
        Response response = new Response();
        response.resultSet = list.toArray(new ResultSet[list.size()]);
        return response;
    }
}

