/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security.websso;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.util.UrlUtils;

public class AuthenticationSuccessRedirectStrategy
implements RedirectStrategy {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public void sendRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        String string2 = this.calculateRedirectUrl(httpServletRequest.getContextPath(), string);
        string2 = this.toAbsolute(httpServletRequest, string2);
        string2 = string2.replaceFirst("http:", "https:");
        string2 = httpServletResponse.encodeRedirectURL(string2);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Redirecting to '" + string2 + "'"));
        }
        httpServletResponse.sendRedirect(string2);
    }

    private String calculateRedirectUrl(String string, String string2) {
        if (!UrlUtils.isAbsoluteUrl((String)string2)) {
            return string + string2;
        }
        return string2;
    }

    private String toAbsolute(HttpServletRequest httpServletRequest, String string) {
        if (string == null) {
            return string;
        }
        boolean bl = string.startsWith("/");
        if (!bl) {
            return string;
        }
        String string2 = httpServletRequest.getScheme();
        String string3 = httpServletRequest.getServerName();
        int n = httpServletRequest.getServerPort();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2).append("://").append(string3);
        if (n != 80 && n != 443) {
            stringBuffer.append(":").append(n);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

