/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security.websso;

import com.vmware.identity.websso.client.SsoRequestSettings;
import com.vmware.identity.websso.client.endpoint.SsoRequestSender;
import com.vmware.vsphere.client.security.util.Util;
import com.vmware.vsphere.client.security.websso.MetadataGenerator;
import com.vmware.vsphere.client.security.websso.RequestCache;
import com.vmware.vsphere.client.security.websso.WebssoUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.web.HttpRequestHandler;

public class WebssoLoginRequestHandler
implements HttpRequestHandler {
    private static final Log _logger = LogFactory.getLog(WebssoLoginRequestHandler.class);
    private final SsoRequestSender _ssoRequestSender;
    private final RequestCache _requestCache;
    private final MetadataGenerator _metadataGenerator;

    @Autowired
    public WebssoLoginRequestHandler(SsoRequestSender ssoRequestSender, RequestCache requestCache, MetadataGenerator metadataGenerator) {
        this._ssoRequestSender = ssoRequestSender;
        this._requestCache = requestCache;
        this._metadataGenerator = metadataGenerator;
    }

    public void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            _logger.info((Object)"Received WebSSO login request");
            this._metadataGenerator.processMetadata((ServletRequest)httpServletRequest);
            HttpSession httpSession = httpServletRequest.getSession();
            DefaultSavedRequest defaultSavedRequest = (DefaultSavedRequest)new HttpSessionRequestCache().getRequest(httpServletRequest, httpServletResponse);
            String string = null;
            if (defaultSavedRequest != null) {
                string = httpSession.getId();
                this._requestCache.getRequestMap().put(string, defaultSavedRequest);
            }
            String string2 = WebssoUtil.getSPAlias(httpServletRequest);
            _logger.info((Object)("SP alias for the login request is " + string2));
            SsoRequestSettings ssoRequestSettings = new SsoRequestSettings(string2, "csp_ngc");
            ssoRequestSettings.setIsSigned(Boolean.valueOf(true));
            ssoRequestSettings.setRelayState(string);
            ssoRequestSettings.setIsRenewable(Boolean.valueOf(true));
            ssoRequestSettings.setIsDelegable(Boolean.valueOf(true));
            _logger.info((Object)"Sending authentication request to the SSO server");
            this._ssoRequestSender.sendRequest(ssoRequestSettings, httpServletResponse);
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
            String string = String.format(Util.getLocalizedString("websso.authRequestError", new String[0]), exception.getMessage());
            httpServletResponse.sendError(400, string);
        }
    }
}

