/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security.websso;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.vmware.identity.websso.client.AssertionConsumerService;
import com.vmware.identity.websso.client.IDPConfiguration;
import com.vmware.identity.websso.client.Message;
import com.vmware.identity.websso.client.SPConfiguration;
import com.vmware.identity.websso.client.SingleLogoutService;
import com.vmware.identity.websso.client.SingleSignOnService;
import com.vmware.identity.websso.client.ValidationResult;
import com.vmware.vise.util.DocumentBuilderFactorySource;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WebssoUtil {
    private static final String WEBSSO_SESSION_INDEX = "WEBSSO-SESSION-INDEX";
    private static final String SESSION_USERNAME_COOKIE_NAME = "VSPHERE-USERNAME";
    private static final String SESSION_INDEX_COOKIE_NAME = "VSPHERE-CLIENT-SESSION-INDEX";
    private static final String SESSION_COOKIE_PATH = "/";
    private static final String COOKIE_ENCODING_CHARSET = Charsets.UTF_8.name();
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final Set<String> URL_ENCODED_COOKIES = ImmutableSet.of((Object)"VSPHERE-USERNAME", (Object)"VSPHERE-CLIENT-SESSION-INDEX");
    private static final DocumentBuilderFactorySource BUILDER_FACTORY_SOURCE = DocumentBuilderFactorySource.INSTANCE;

    public static IDPConfiguration getIDPConfigurationFromMetadata(String string, String string2) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        DocumentBuilderFactory documentBuilderFactory = BUILDER_FACTORY_SOURCE.createDocumentBuilderFactory();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(byteArrayInputStream);
        IDPConfiguration iDPConfiguration = WebssoUtil.getIDPConfigurationFromMetadataDocument(document);
        iDPConfiguration.setAlias(string);
        return iDPConfiguration;
    }

    public static SPConfiguration createDefaultSPConfiguration(String string, String string2, X509Certificate x509Certificate, PrivateKey privateKey) {
        return WebssoUtil.createDefaultSPConfiguration(string, string2, x509Certificate, privateKey, "/saml/websso/sso", "/saml/websso/slo");
    }

    public static SPConfiguration createDefaultSPConfiguration(String string, String string2, X509Certificate x509Certificate, PrivateKey privateKey, String string3, String string4) {
        String string5 = string2 + "/saml/websso/metadata";
        boolean bl = true;
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        linkedList.add("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        LinkedList<AssertionConsumerService> linkedList2 = new LinkedList<AssertionConsumerService>();
        String string6 = string2 + string3;
        AssertionConsumerService assertionConsumerService = new AssertionConsumerService(string6, true, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 0);
        linkedList2.add(assertionConsumerService);
        String string7 = string2 + string4;
        LinkedList<SingleLogoutService> linkedList3 = new LinkedList<SingleLogoutService>();
        SingleLogoutService singleLogoutService = new SingleLogoutService(string7, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        linkedList3.add(singleLogoutService);
        SingleLogoutService singleLogoutService2 = new SingleLogoutService(string7, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        linkedList3.add(singleLogoutService2);
        String string8 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        return new SPConfiguration(string, string5, bl, privateKey, x509Certificate, string8, linkedList, linkedList2, linkedList3);
    }

    public static String getSPAlias(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getServerName();
        int n = httpServletRequest.getServerPort();
        if (n > 0) {
            string = string + ":" + n;
        }
        return string;
    }

    public static String getMetadataFromSPConfiguration(SPConfiguration sPConfiguration) throws Exception {
        Document document = WebssoUtil.getMetadataDocumentFromSPConfiguration(sPConfiguration);
        return XMLUtil.xmlToString((Node)document);
    }

    public static void sendResponse(HttpServletResponse httpServletResponse, String string, String string2) throws IOException {
        httpServletResponse.setContentType(string);
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println(string2);
        printWriter.close();
    }

    public static void setSessionCookies(HttpServletResponse httpServletResponse, String string, String string2) throws UnsupportedEncodingException {
        String string3 = URLEncoder.encode(string, COOKIE_ENCODING_CHARSET);
        Cookie cookie = new Cookie(SESSION_USERNAME_COOKIE_NAME, string3);
        cookie.setPath(SESSION_COOKIE_PATH);
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        httpServletResponse.addCookie(cookie);
        String string4 = URLEncoder.encode(string2, COOKIE_ENCODING_CHARSET);
        Cookie cookie2 = new Cookie(SESSION_INDEX_COOKIE_NAME, string4);
        cookie2.setPath(SESSION_COOKIE_PATH);
        cookie2.setHttpOnly(true);
        cookie2.setSecure(true);
        httpServletResponse.addCookie(cookie2);
    }

    public static String getUsernameCookieValue(HttpServletRequest httpServletRequest) throws UnsupportedEncodingException {
        return WebssoUtil.getCookieValue(httpServletRequest.getCookies(), SESSION_USERNAME_COOKIE_NAME, null);
    }

    public static String getSessionIndexCookieValue(HttpServletRequest httpServletRequest) throws UnsupportedEncodingException {
        return WebssoUtil.getCookieValue(httpServletRequest.getCookies(), SESSION_INDEX_COOKIE_NAME, null);
    }

    private static String getCookieValue(Cookie[] cookieArray, String string, String string2) throws UnsupportedEncodingException {
        if (cookieArray != null) {
            for (Cookie cookie : cookieArray) {
                if (!string.equals(cookie.getName())) continue;
                if (URL_ENCODED_COOKIES.contains(string)) {
                    return URLDecoder.decode(cookie.getValue(), COOKIE_ENCODING_CHARSET);
                }
                return cookie.getValue();
            }
        }
        return string2;
    }

    public static void setSessionIndex(HttpServletRequest httpServletRequest, String string) {
        HttpSession httpSession = httpServletRequest.getSession();
        httpSession.setAttribute(WEBSSO_SESSION_INDEX, (Object)string);
    }

    public static String getWebSsoSessionIndex(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession();
        return (String)httpSession.getAttribute(WEBSSO_SESSION_INDEX);
    }

    static boolean handleSpecialValidationCases(ValidationResult validationResult, HttpServletRequest httpServletRequest, Log log) {
        String string = validationResult.getSubstatus();
        if ("Issuer not recognized.".equals(string)) {
            try {
                WebssoAction webssoAction = WebssoAction.getFromRequest(httpServletRequest);
                if (webssoAction != WebssoAction.REFRESHED_METADATA_AND_RETRYING) {
                    log.error((Object)"[WebssoUtil] Detected an 'Issuer not recognized.' error. Sending a 'Refresh metadata & retry' signal");
                    WebssoAction.REFRESH_METADATA_AND_RETRY.setInRequest(httpServletRequest);
                    return true;
                }
                log.error((Object)"Detected an 'Issuer not recognized.' error again. Will not retry anymore");
            }
            catch (Exception exception) {
                log.error((Object)"Failed to do custom processing of an ISSUER error. Falling back to standard error processing.", (Throwable)exception);
            }
        }
        return false;
    }

    private static IDPConfiguration getIDPConfigurationFromMetadataDocument(Document document) throws Exception {
        NodeList nodeList = document.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:metadata", "EntityDescriptor");
        Element element = (Element)nodeList.item(0);
        if (WebssoUtil.isExpired(element)) {
            throw new Exception("Document has expired!");
        }
        return WebssoUtil.importIDPEntity(element);
    }

    private static IDPConfiguration importIDPEntity(Element element) throws Exception {
        String string = element.getAttribute("entityID");
        NodeList nodeList = element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:metadata", "IDPSSODescriptor");
        if (nodeList.getLength() == 0) {
            throw new Exception("SAML medadata error: file does not have a idp or sp descriptor!");
        }
        Element element2 = (Element)nodeList.item(0);
        return WebssoUtil.importIDPSSODescriptor(element2, string);
    }

    private static IDPConfiguration importIDPSSODescriptor(Element element, String string) throws Exception {
        NodeList nodeList = element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:metadata", "KeyDescriptor");
        if (nodeList.getLength() == 0) {
            throw new Exception("SAML metadata error: no signing key for IDP");
        }
        Element element2 = (Element)nodeList.item(0);
        if (!element2.getAttribute("use").equals("signing")) {
            throw new Exception("SAML metadata error: no signing key for IDP");
        }
        NodeList nodeList2 = element2.getElementsByTagName("ds:KeyInfo");
        Element element3 = (Element)nodeList2.item(0);
        Collection<Certificate> collection = WebssoUtil.parseCertificates(element3);
        List<String> list = WebssoUtil.parseNameIDFormats(element);
        List<SingleSignOnService> list2 = WebssoUtil.parseSsoServices(element);
        List<SingleLogoutService> list3 = WebssoUtil.parseSloServices(element);
        IDPConfiguration iDPConfiguration = new IDPConfiguration(string, string, (X509Certificate)collection.toArray()[0], list, list2, list3);
        return iDPConfiguration;
    }

    private static Document getMetadataDocumentFromSPConfiguration(SPConfiguration sPConfiguration) throws ParserConfigurationException, CertificateEncodingException {
        DocumentBuilder documentBuilder = BUILDER_FACTORY_SOURCE.createDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = WebssoUtil.createEntitiesDescriptor(document, sPConfiguration);
        document.appendChild(element);
        Element element2 = WebssoUtil.createSPEntityDescriptor(document, sPConfiguration);
        element.appendChild(element2);
        return document;
    }

    private static Element createEntitiesDescriptor(Document document, SPConfiguration sPConfiguration) {
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:2.0:metadata", "EntitiesDescriptor");
        element.setAttribute("Name", sPConfiguration.getAlias());
        return element;
    }

    private static Element createSPEntityDescriptor(Document document, SPConfiguration sPConfiguration) throws CertificateEncodingException {
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:2.0:metadata", "EntityDescriptor");
        element.setAttribute("entityID", sPConfiguration.getEntityID());
        Element element2 = WebssoUtil.createSPSSODescriptor(document, sPConfiguration);
        element.appendChild(element2);
        return element;
    }

    private static Element createSPSSODescriptor(Document document, SPConfiguration sPConfiguration) throws CertificateEncodingException {
        Element element;
        Object object;
        Object object22;
        Element element2 = document.createElement("SPSSODescriptor");
        element2.setAttribute("AuthnRequestsSigned", new Boolean(sPConfiguration.isAuthnRequestsSigned()).toString());
        element2.setAttribute("protocolSupportEnumeration", "urn:oasis:names:tc:SAML:2.0:protocol");
        Element element3 = WebssoUtil.createSPKeyDescriptor(document, sPConfiguration);
        if (element3 != null) {
            element2.appendChild(element3);
        }
        List list = sPConfiguration.getSingleLogoutServices();
        for (Object object22 : list) {
            object = WebssoUtil.createSingleLogoutService(document, (SingleLogoutService)object22);
            if (object == null) continue;
            element2.appendChild((Node)object);
        }
        List list2 = sPConfiguration.getNameIDFormats();
        object22 = list2.iterator();
        while (object22.hasNext()) {
            object = (String)object22.next();
            element = WebssoUtil.createNameIDFormat(document, object);
            if (element == null) continue;
            element2.appendChild(element);
        }
        object22 = sPConfiguration.getAssertionConsumerServices();
        object = object22.iterator();
        while (object.hasNext()) {
            element = (AssertionConsumerService)object.next();
            Element element4 = WebssoUtil.createAssertionConsumerService(document, (AssertionConsumerService)element);
            if (element4 == null) continue;
            element2.appendChild(element4);
        }
        return element2;
    }

    private static Element createSPKeyDescriptor(Document document, SPConfiguration sPConfiguration) throws CertificateEncodingException {
        Element element = null;
        X509Certificate x509Certificate = sPConfiguration.getSigningCertificate();
        if (x509Certificate == null) {
            return null;
        }
        element = document.createElement("KeyDescriptor");
        element.setAttribute("xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        element.setAttribute("use", "signing");
        Element element2 = document.createElement("ds:KeyInfo");
        Element element3 = document.createElement("ds:X509Data");
        Element element4 = WebssoUtil.createCertificate(document, x509Certificate);
        element3.appendChild(element4);
        element2.appendChild(element3);
        element.appendChild(element2);
        return element;
    }

    private static Element createCertificate(Document document, X509Certificate x509Certificate) throws CertificateEncodingException {
        Element element = document.createElement("ds:X509Certificate");
        String string = new String(Base64.encodeBase64((byte[])x509Certificate.getEncoded()));
        Text text = document.createTextNode(string);
        element.appendChild(text);
        return element;
    }

    private static Element createNameIDFormat(Document document, String string) {
        Element element = document.createElement("NameIDFormat");
        element.appendChild(document.createTextNode(string));
        return element;
    }

    private static Element createAssertionConsumerService(Document document, AssertionConsumerService assertionConsumerService) {
        if (assertionConsumerService == null) {
            return null;
        }
        Element element = document.createElement("AssertionConsumerService");
        String string = assertionConsumerService.getLocation();
        element.setAttribute("Binding", assertionConsumerService.getBinding());
        element.setAttribute("Location", string);
        element.setAttribute("index", Integer.toString(assertionConsumerService.getIndex()));
        if (assertionConsumerService.isDefault()) {
            element.setAttribute("isDefault", "true");
        }
        return element;
    }

    private static Element createSingleLogoutService(Document document, SingleLogoutService singleLogoutService) {
        if (singleLogoutService == null) {
            return null;
        }
        Element element = document.createElement("SingleLogoutService");
        String string = singleLogoutService.getLocation();
        element.setAttribute("Binding", singleLogoutService.getBinding());
        element.setAttribute("Location", string);
        return element;
    }

    private static Collection<Certificate> parseCertificates(Element element) throws CertificateException {
        NodeList nodeList = element.getElementsByTagName("ds:X509Data");
        if (nodeList.getLength() == 0) {
            return null;
        }
        NodeList nodeList2 = ((Element)nodeList.item(0)).getElementsByTagName("ds:X509Certificate");
        if (nodeList2.getLength() == 0) {
            return null;
        }
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Element element2 = (Element)nodeList2.item(0);
            if (element2 == null) continue;
            byte[] byArray = Base64.decodeBase64((byte[])element2.getTextContent().getBytes());
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
            arrayList.add(x509Certificate);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }

    private static List<String> parseNameIDFormats(Element element) {
        NodeList nodeList = element.getElementsByTagName("NameIDFormat");
        if (nodeList.getLength() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add(nodeList.item(i).getTextContent());
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }

    private static List<SingleLogoutService> parseSloServices(Element element) {
        NodeList nodeList = element.getElementsByTagName("SingleLogoutService");
        if (nodeList.getLength() == 0) {
            return null;
        }
        ArrayList<SingleLogoutService> arrayList = new ArrayList<SingleLogoutService>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            arrayList.add(new SingleLogoutService(element2.getAttribute("Location"), element2.getAttribute("Binding")));
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }

    private static List<SingleSignOnService> parseSsoServices(Element element) {
        NodeList nodeList = element.getElementsByTagName("SingleSignOnService");
        if (nodeList.getLength() == 0) {
            return null;
        }
        ArrayList<SingleSignOnService> arrayList = new ArrayList<SingleSignOnService>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            arrayList.add(new SingleSignOnService(element2.getAttribute("Location"), element2.getAttribute("Binding")));
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }

    private static boolean isExpired(Element element) throws ParseException {
        String string = element.getAttribute("validUntil");
        if (StringUtil.isNullOrEmpty((String)string)) {
            return false;
        }
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        Calendar calendar = Calendar.getInstance(timeZone);
        Date date = calendar.getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        simpleDateFormat.setTimeZone(timeZone);
        Date date2 = simpleDateFormat.parse(string);
        return date2.before(date);
    }

    public static void logMessageDetails(@Nonnull Message message, @Nullable String string) {
        Validate.notNull((Object)message);
        _logger.info((Object)((string != null ? "[" + string + "] " : "") + "Message details: id=" + message.getId() + ", type=" + message.getType() + ", source='" + message.getSource() + "', target='" + message.getTarget() + "', issueInstant='" + message.getIssueInstant() + "'"));
    }

    static enum WebssoAction {
        REFRESH_METADATA_AND_RETRY,
        REFRESHED_METADATA_AND_RETRYING;

        private static final String REQ_ATTR_NAME__WEBSSO_ACTION = "#WebssoAction#";

        public void setInRequest(HttpServletRequest httpServletRequest) {
            httpServletRequest.setAttribute(REQ_ATTR_NAME__WEBSSO_ACTION, (Object)this);
        }

        public static WebssoAction getFromRequest(HttpServletRequest httpServletRequest) {
            WebssoAction webssoAction = (WebssoAction)((Object)httpServletRequest.getAttribute(REQ_ATTR_NAME__WEBSSO_ACTION));
            return webssoAction;
        }
    }
}

