/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons;

import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vim.UserSession;
import com.vmware.vim.binding.vim.version.internal.versions;
import com.vmware.vim.binding.vim.version.version10;
import com.vmware.vim.binding.vim.version.version11;
import com.vmware.vim.binding.vim.version.version7;
import com.vmware.vim.binding.vim.version.version8;
import com.vmware.vim.binding.vim.version.version9;
import com.vmware.vim.binding.vmodl.versionId;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.Version;
import com.vmware.vise.util.XMLUtil;
import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.I18nUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.security.NotAuthenticatedError;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.commons.ssl.SslUtil;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.LoginSpec;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vcservice.VcServiceConnectionInfo;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VcServiceUtil {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final String PRODUCT_ID_EMBEDDED_ESX = "embeddedEsx";
    private static final String PRODUCT_ID_CLASSIC_ESX = "esx";
    public static final String DEFAULT_WSDL_NAMESPACE_OF_VC_VERSIONS = VcServiceUtil.getWsdlNamespaceOfVmodlVersion(version10.class);
    public static final VmodlVersion VC_VERSION_5_0;
    public static final VmodlVersion VC_VERSION_5_1;
    public static final VmodlVersion VC_VERSION_5_5;
    public static final VmodlVersion VC_VERSION_6_0;
    public static final VmodlVersion VC_VERSION_6_5;
    private static final List<VmodlVersion> KNOWN_VC_VMODL_VERSIONS;
    private static Version VERSION_5_5;
    private static Version VERSION_6_0;
    private static Version VERSION_6_1;

    public static String getServiceUrl(VcService vcService) {
        String string = vcService.getServiceUrl();
        return VcServiceUtil.formatServiceUrl(string);
    }

    public static String formatServiceUrl(String string) {
        int n = string.lastIndexOf("/sdk");
        return n == -1 ? string : string.substring(0, n);
    }

    @Deprecated
    public static HttpClient getSslSecuredHttpClient(VcService vcService) {
        return SslUtil.getHttpClient((String)vcService.getThumbprint());
    }

    public static HttpClient getSslSecuredHttpClient(VcService vcService, SSLConfigurationProvider sSLConfigurationProvider) {
        return new SSLBuilder().sslConfigurationProvider(sSLConfigurationProvider).thumbprint(vcService.getThumbprint()).buildHttpClientIgnoreErrors();
    }

    public static ServiceDirectory.ServiceEndpoint getServiceEndpoint(String string) {
        return VcServiceUtil.getServiceEndpoint(string, ServiceDirectory.ServiceProtocol.vimApi, null);
    }

    public static ServiceDirectory.ServiceEndpoint getServiceEndpoint(String string, ServiceDirectory.ServiceProtocol serviceProtocol, HttpSession httpSession) {
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry(httpSession);
        if (linkedVcGroupRegistry == null) {
            return null;
        }
        LinkedVcGroup linkedVcGroup = linkedVcGroupRegistry.getLinkedGroupByServiceUuid(string);
        if (linkedVcGroup == null) {
            return null;
        }
        return linkedVcGroup.getServiceEndpoint(string, serviceProtocol);
    }

    private static ServiceDirectory.ServiceEndpoint getServiceEndpoint(String string, ServiceDirectory.ServiceEndpoint[] serviceEndpointArray) throws Exception {
        for (ServiceDirectory.ServiceEndpoint serviceEndpoint : serviceEndpointArray) {
            if (!serviceEndpoint.instanceUuid.equals(string)) continue;
            return serviceEndpoint;
        }
        throw MixedUtil.getRuntimeFault(I18nUtil.getLocalizedString("error.serverNotFound", string));
    }

    public static String getServiceName(String string) {
        ServiceDirectory.ServiceEndpoint serviceEndpoint = VcServiceUtil.getServiceEndpoint(string);
        if (serviceEndpoint != null) {
            return serviceEndpoint.instanceName;
        }
        return null;
    }

    public static String fetchServiceThumbprint(String string) throws Exception {
        ServiceDirectory.ServiceEndpoint serviceEndpoint = VcServiceUtil.fetchServiceEndpoint(string);
        return serviceEndpoint.sslThumbprint;
    }

    public static ServiceDirectory.ServiceEndpoint fetchServiceEndpoint(String string) throws Exception {
        return VcServiceUtil.fetchServiceEndpoint(string, null);
    }

    private static ServiceDirectory.ServiceEndpoint fetchServiceEndpoint(String string, HttpSession httpSession) throws Exception {
        VcService vcService = VimSessionUtil.getService(string, httpSession);
        ServiceDirectory.ServiceEndpoint[] serviceEndpointArray = vcService.fetchServiceEndpoints();
        return VcServiceUtil.getServiceEndpoint(string, serviceEndpointArray);
    }

    public static ServiceDirectory.ServiceEndpoint[] fetchServiceEndpoints(VcService vcService) {
        ServiceDirectory.ServiceEndpoint[] serviceEndpointArray = vcService.fetchServiceEndpoints();
        return serviceEndpointArray;
    }

    public static boolean isEsxServer(AboutInfo aboutInfo) {
        if (aboutInfo == null) {
            return false;
        }
        return aboutInfo.productLineId.equals(PRODUCT_ID_CLASSIC_ESX) || aboutInfo.productLineId.equals(PRODUCT_ID_EMBEDDED_ESX);
    }

    public static String acquireSessionTicket(VcService vcService, ServiceDirectory.ServiceEndpoint serviceEndpoint) throws Exception {
        if (vcService == null) {
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.nullService", new String[0]));
        }
        if (serviceEndpoint == null) {
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.nullEndpoint", new String[0]));
        }
        ServiceInstanceContent serviceInstanceContent = vcService.getServiceInstanceContent();
        SessionManager sessionManager = (SessionManager)ManagedObjectUtil.getManagedObject(serviceInstanceContent.getSessionManager());
        return sessionManager.acquireSessionTicket(serviceEndpoint.getKey());
    }

    public static SessionManager.GenericServiceTicket acquireGenericServiceTicket(HttpSession httpSession, String string, String string2) throws Exception {
        if (httpSession == null && (httpSession = SessionUtil.getHttpSession((boolean)false)) == null) {
            _logger.error((Object)"Session is null");
            throw new NotAuthenticatedError();
        }
        String string3 = SessionUtil.getClientId((HttpSession)httpSession);
        if (string3 == null) {
            _logger.error((Object)"cliendId is null");
            throw new NotAuthenticatedError();
        }
        return VcServiceUtil.acquireGenericServiceTicketByClientId(string3, string, string2);
    }

    public static SessionManager.GenericServiceTicket acquireGenericServiceTicketByClientId(String string, String string2, String string3) throws Exception {
        SessionManager.HttpServiceRequestSpec httpServiceRequestSpec = new SessionManager.HttpServiceRequestSpec();
        httpServiceRequestSpec.url = string2.replace("%20", " ");
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistryByClientId(string);
        LinkedVcGroup linkedVcGroup = linkedVcGroupRegistry.getLinkedGroupByServiceUuid(string3);
        VcService vcService = linkedVcGroup.getVcService(string3);
        ServiceInstanceContent serviceInstanceContent = vcService.getServiceInstanceContent();
        SessionManager sessionManager = (SessionManager)ManagedObjectUtil.getManagedObjectByClientId(serviceInstanceContent.getSessionManager(), string);
        SessionManager.GenericServiceTicket genericServiceTicket = sessionManager.acquireGenericServiceTicket((SessionManager.ServiceRequestSpec)httpServiceRequestSpec);
        return genericServiceTicket;
    }

    @Deprecated
    public static boolean isMNnextVcOrLater(String string) {
        Version version = new Version(VcServiceUtil.getVersion(string));
        return version.compareTo(new Version("5.1.0")) >= 0;
    }

    public static boolean isMNNextVcOrLater(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Invalid vc service version.");
        }
        return version.compareTo(new Version("5.1.0")) >= 0;
    }

    public static boolean isMNNextVcOrLaterByVersion(String string) {
        Version version = new Version(string);
        return VcServiceUtil.isMNNextVcOrLater(version);
    }

    public static boolean isMNNextVcOrLater(Class<?> clazz) {
        VmodlVersion vmodlVersion = VcServiceUtil.getVmodlVersion(clazz);
        boolean bl = VcServiceUtil.isMNNextVcOrLater(vmodlVersion);
        return bl;
    }

    public static boolean isMNNextVcOrLater(VmodlVersion vmodlVersion) {
        Validate.notNull((Object)vmodlVersion, (String)"The vmodlVersion is null");
        boolean bl = vmodlVersion.isCompatible(VC_VERSION_5_1);
        return bl;
    }

    public static boolean isOPVcOrLater(String string) {
        Version version = new Version(VcServiceUtil.getVersion(string));
        return VcServiceUtil.isOPVcOrLater(version);
    }

    public static boolean isOPVcOrLaterByVersion(String string) {
        Version version = new Version(string);
        return VcServiceUtil.isOPVcOrLater(version);
    }

    @CheckForNull
    public static Class<?> determineInternalVmodlVersionByStringVersion(@Nonnull String string) {
        Validate.notNull((Object)string, (String)"serviceVersion shouldn't be null");
        Version version = new Version(string);
        if (VcServiceUtil.is65VcOrLater(version)) {
            return versions.VIM_VERSION_STABLE;
        }
        if (VcServiceUtil.is60VcOrLater(version)) {
            return com.vmware.vim.binding.vim.version.internal.version10.class;
        }
        if (VcServiceUtil.isOPVcOrLater(version)) {
            return com.vmware.vim.binding.vim.version.internal.version9.class;
        }
        if (VcServiceUtil.isMNNextVcOrLater(version)) {
            return com.vmware.vim.binding.vim.version.internal.version8.class;
        }
        if (VcServiceUtil.isMNVcOrLater(version)) {
            return com.vmware.vim.binding.vim.version.internal.version7.class;
        }
        return null;
    }

    public static boolean isOPVcOrLater(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Invalid vc service version.");
        }
        return version.compareTo(VERSION_5_5) >= 0;
    }

    public static boolean isOPVcOrLater(Class<?> clazz) {
        VmodlVersion vmodlVersion = VcServiceUtil.getVmodlVersion(clazz);
        boolean bl = VcServiceUtil.isOPVcOrLater(vmodlVersion);
        return bl;
    }

    public static boolean isOPVcOrLater(VmodlVersion vmodlVersion) {
        Validate.notNull((Object)vmodlVersion, (String)"The vmodlVersion is null");
        boolean bl = vmodlVersion.isCompatible(VC_VERSION_5_5);
        return bl;
    }

    @Deprecated
    public static boolean is2014VcOrLater(String string) {
        return VcServiceUtil.is60VcOrLater(string);
    }

    public static boolean is60VcOrLater(String string) {
        Version version = new Version(VcServiceUtil.getVersion(string));
        return VcServiceUtil.is60VcOrLater(version);
    }

    @Deprecated
    public static boolean is2014VcOrLaterByVersion(String string) {
        return VcServiceUtil.is60VcOrLaterByVersion(string);
    }

    public static boolean is60VcOrLaterByVersion(String string) {
        Version version = new Version(string);
        return VcServiceUtil.is60VcOrLater(version);
    }

    @Deprecated
    public static boolean is2014VcOrLater(Version version) {
        return VcServiceUtil.is60VcOrLater(version);
    }

    public static boolean is60VcOrLater(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Invalid vc service version.");
        }
        return version.compareTo(VERSION_6_0) >= 0;
    }

    @Deprecated
    public static boolean is2014VcOrLater(Class<?> clazz) {
        return VcServiceUtil.is60VcOrLater(clazz);
    }

    public static boolean is60VcOrLater(Class<?> clazz) {
        VmodlVersion vmodlVersion = VcServiceUtil.getVmodlVersion(clazz);
        boolean bl = VcServiceUtil.is60VcOrLater(vmodlVersion);
        return bl;
    }

    @Deprecated
    public static boolean is2014VcOrLater(VmodlVersion vmodlVersion) {
        return VcServiceUtil.is60VcOrLater(vmodlVersion);
    }

    public static boolean is60VcOrLater(VmodlVersion vmodlVersion) {
        Validate.notNull((Object)vmodlVersion, (String)"The vmodlVersion is null");
        boolean bl = vmodlVersion.isCompatible(VC_VERSION_6_0);
        return bl;
    }

    public static boolean is65VcOrLaterByServerGuid(String string) {
        return VcServiceUtil.is65VcOrLaterByServerGuid(string, false);
    }

    public static boolean is65VcOrLaterByServerGuid(String string, boolean bl) {
        String string2 = VcServiceUtil.getVersion(string, bl);
        if (string2 == null) {
            return false;
        }
        Version version = new Version(string2);
        return VcServiceUtil.is65VcOrLater(version);
    }

    public static boolean is65VcOrLaterByVersion(String string) {
        Version version = new Version(string);
        return VcServiceUtil.is65VcOrLater(version);
    }

    public static boolean is65VcOrLater(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Invalid vc service version.");
        }
        return version.compareTo(VERSION_6_1) >= 0;
    }

    public static boolean is65VcOrLater(Class<?> clazz) {
        VmodlVersion vmodlVersion = VcServiceUtil.getVmodlVersion(clazz);
        boolean bl = VcServiceUtil.is65VcOrLater(vmodlVersion);
        return bl;
    }

    public static boolean is65VcOrLater(VmodlVersion vmodlVersion) {
        Validate.notNull((Object)vmodlVersion, (String)"The vmodlVersion is null");
        boolean bl = vmodlVersion.isCompatible(VC_VERSION_6_5);
        return bl;
    }

    private static VmodlVersion getVmodlVersion(Class<?> clazz) {
        Validate.notNull(clazz, (String)"vmodlVersionClass is null");
        VmodlVersionMap vmodlVersionMap = VmodlVersionMap.Factory.getVmodlVersionMap();
        VmodlVersion vmodlVersion = vmodlVersionMap.getVersion(clazz);
        if (vmodlVersion == null) {
            throw new IllegalArgumentException("The class " + clazz.getCanonicalName() + " is not a VMODL version");
        }
        return vmodlVersion;
    }

    public static boolean areVersionsInSameRelease(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2) {
        VmodlVersion vmodlVersion = VcServiceUtil.getVmodlVersion(clazz);
        VmodlVersion vmodlVersion2 = VcServiceUtil.getReleaseVersion(vmodlVersion);
        if (vmodlVersion2 == null) {
            return false;
        }
        String string = vmodlVersion2.getVersionId();
        if (string == null) {
            return false;
        }
        VmodlVersion vmodlVersion3 = VcServiceUtil.getVmodlVersion(clazz2);
        VmodlVersion vmodlVersion4 = VcServiceUtil.getReleaseVersion(vmodlVersion3);
        if (vmodlVersion4 == null) {
            return false;
        }
        String string2 = vmodlVersion4.getVersionId();
        boolean bl = string.equals(string2);
        return bl;
    }

    public static boolean isKnownVersion(@Nonnull VmodlVersion vmodlVersion) {
        Validate.notNull((Object)vmodlVersion, (String)"vmodlVersion is null");
        VmodlVersion vmodlVersion2 = VcServiceUtil.getReleaseVersion(vmodlVersion);
        if (vmodlVersion2 == null) {
            return false;
        }
        return KNOWN_VC_VMODL_VERSIONS.contains(vmodlVersion2);
    }

    @CheckForNull
    private static VmodlVersion getReleaseVersion(@Nonnull VmodlVersion vmodlVersion) {
        LinkedList linkedList = null;
        do {
            Set set;
            String string;
            if (!StringUtil.isNullOrEmpty((String)(string = vmodlVersion.getVersionId()))) {
                try {
                    new Version(string);
                    return vmodlVersion;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (linkedList == null) {
                linkedList = new LinkedList();
            }
            if ((set = vmodlVersion.getParentVersion()) == null || set.size() <= 0) continue;
            linkedList.addAll(set);
        } while ((vmodlVersion = (VmodlVersion)linkedList.poll()) != null);
        return null;
    }

    @Deprecated
    public static boolean isMNVc(String string) {
        Version version = new Version(VcServiceUtil.getVersion(string));
        return version.compareTo(new Version("5.0.0")) >= 0 && version.compareTo(new Version("5.1.0")) < 0;
    }

    public static boolean isMNVcOrLater(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Invalid vc service version.");
        }
        return version.compareTo(new Version("5.0.0")) >= 0;
    }

    public static boolean isMNVcOrLaterByVersion(String string) {
        Version version = new Version(string);
        return VcServiceUtil.isMNVcOrLater(version);
    }

    public static boolean isMNVcOrLater(Class<?> clazz) {
        VmodlVersion vmodlVersion = VcServiceUtil.getVmodlVersion(clazz);
        boolean bl = VcServiceUtil.isMNVcOrLater(vmodlVersion);
        return bl;
    }

    public static boolean isMNVcOrLater(VmodlVersion vmodlVersion) {
        Validate.notNull((Object)vmodlVersion, (String)"The vmodlVersion is null");
        boolean bl = vmodlVersion.isCompatible(VC_VERSION_5_0);
        return bl;
    }

    private static String getVersion(String string) {
        return VcServiceUtil.getVersion(string, false);
    }

    private static String getVersion(String string, boolean bl) {
        VcService vcService;
        if (!StringUtil.isNullOrEmpty((String)string) && (vcService = VimSessionUtil.getService(string)) != null) {
            return vcService.getServiceVersion();
        }
        if (bl) {
            return null;
        }
        throw new IllegalArgumentException("Invalid guid, no matching VcService found.");
    }

    public static String getVersionIdOfVmodlVersion(Class<?> clazz) {
        Validate.notNull(clazz, (String)"vmodlVersion is null");
        versionId versionId2 = clazz.getAnnotation(versionId.class);
        if (versionId2 == null) {
            throw new IllegalArgumentException("The provided VIM version doesn't contain a @" + versionId.class.getSimpleName() + " annotation: " + clazz);
        }
        String string = versionId2.value();
        if (StringUtil.isNullOrWhitespace((String)string)) {
            throw new IllegalArgumentException("The provided VIM version's @" + versionId.class.getSimpleName() + " annotation doesn't specify a version number: " + clazz);
        }
        return string;
    }

    public static String getWsdlNamespaceOfVmodlVersion(Class<?> clazz) {
        Validate.notNull(clazz, (String)"vmodlVersion is null");
        wsdlName wsdlName2 = clazz.getAnnotation(wsdlName.class);
        if (wsdlName2 == null) {
            throw new IllegalArgumentException("The provided VIM version doesn't contain a @" + wsdlName.class.getSimpleName() + " annotation: " + clazz);
        }
        String string = wsdlName2.value();
        if (StringUtil.isNullOrWhitespace((String)string)) {
            throw new IllegalArgumentException("The provided VIM version's @" + wsdlName.class.getSimpleName() + " annotation doesn't specify a version number: " + clazz);
        }
        return string;
    }

    public static LoginSpec createVcLoginSpec(ServerInfoEx serverInfoEx) {
        LoginSpec loginSpec = new LoginSpec();
        loginSpec.endpoints = serverInfoEx.endpoints;
        loginSpec.serviceUrl = serverInfoEx.serviceUrl;
        loginSpec.thumbprint = serverInfoEx.thumbprint;
        loginSpec.sslTrustAnchor = serverInfoEx.sslTrustAnchor;
        loginSpec.vmodlVersion = serverInfoEx.vmodlVersion;
        if (serverInfoEx.vmodlVersion == null && serverInfoEx.version != null) {
            Class<?> clazz = VcServiceUtil.determineInternalVmodlVersionByStringVersion(serverInfoEx.version);
            if (clazz == null) {
                _logger.warn((Object)("Failed to determine the VMODL version of VC " + serverInfoEx.serviceUrl + " (guid:" + serverInfoEx.serviceGuid + ") whose string version is \"" + serverInfoEx.version + "\""));
            } else if (!VcServiceUtil.isOPVcOrLater(clazz)) {
                _logger.warn((Object)("The VC version of VC " + serverInfoEx.serviceUrl + " is too old (" + serverInfoEx.version + " / " + clazz.getName() + ") and it's not supported"));
            }
            loginSpec.vmodlVersion = clazz;
        }
        return loginSpec;
    }

    @Deprecated
    public static boolean isVc61OrLater(String string) {
        Version version = new Version(VcServiceUtil.getVersion(string));
        return VcServiceUtil.isVersion61OrLater(version);
    }

    @Deprecated
    public static boolean isVersion61OrLater(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Invalid version.");
        }
        return version.compareTo(new Version("6.1.0")) >= 0;
    }

    public static ServerInfoEx toServerInfoEx(VcService vcService) throws Exception {
        String string = vcService.getServiceGuid();
        ServiceDirectory.ServiceEndpoint serviceEndpoint = null;
        if (string != null) {
            serviceEndpoint = VcServiceUtil.getServiceEndpoint(string);
        }
        return VcServiceUtil.toServerInfoEx(vcService, serviceEndpoint);
    }

    public static ServerInfoEx toServerInfoEx(@Nonnull VcService vcService, @Nullable ServiceDirectory.ServiceEndpoint serviceEndpoint) {
        LinkedVcGroupRegistry linkedVcGroupRegistry;
        LinkedVcGroup linkedVcGroup;
        ServerInfoEx serverInfoEx = new ServerInfoEx();
        serverInfoEx.serviceGuid = vcService.getServiceGuid();
        String string = URI.create(vcService.getServiceUrl()).getHost();
        serverInfoEx.serviceUrl = MixedUtil.isLocalhost(string) && serviceEndpoint != null ? serviceEndpoint.url : vcService.getServiceUrl();
        VcServiceConnectionInfo vcServiceConnectionInfo = vcService.getConnectionInfo();
        serverInfoEx.serviceInstance = vcService.getServiceInstance()._getRef();
        serverInfoEx.sessionCookie = vcServiceConnectionInfo.getSessionCookie();
        serverInfoEx.thumbprint = vcService.getThumbprint();
        serverInfoEx.errorCode = vcServiceConnectionInfo.getErrorCode();
        if (!vcServiceConnectionInfo.getConnectionState() && "noError".equals(vcServiceConnectionInfo.getErrorCode()) && (linkedVcGroup = (linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry()).getLinkedGroupByServiceUuid(vcService.getServiceGuid())) != null) {
            serverInfoEx.errorCode = VcServiceUtil.getLinkedVcGroupErrorCode(linkedVcGroup);
        }
        serverInfoEx.name = serviceEndpoint != null ? serviceEndpoint.instanceName : string;
        linkedVcGroupRegistry = vcServiceConnectionInfo.getUserSession();
        if (linkedVcGroupRegistry != null) {
            serverInfoEx.sessionKey = ((UserSession)linkedVcGroupRegistry).key;
        }
        if ((linkedVcGroup = vcService.getServiceInstanceContent()) != null) {
            serverInfoEx.content = linkedVcGroup;
            serverInfoEx.version = linkedVcGroup.getAbout().getVersion();
        } else {
            serverInfoEx.version = vcService.getServiceVersion();
        }
        return serverInfoEx;
    }

    private static String getLinkedVcGroupErrorCode(LinkedVcGroup linkedVcGroup) {
        if (linkedVcGroup == null) {
            return "connectError";
        }
        VcService vcService = linkedVcGroup.getStartUpVcService();
        if (vcService == null) {
            return "connectError";
        }
        VcServiceConnectionInfo vcServiceConnectionInfo = vcService.getConnectionInfo();
        String string = vcServiceConnectionInfo.getErrorCode();
        if (!"noError".equals(vcServiceConnectionInfo.getErrorCode())) {
            return string;
        }
        return "connectError";
    }

    @Nonnull
    public static String fetchApiVersionFromVc(@Nonnull SSLConfigurationProvider sSLConfigurationProvider, @Nonnull String string, @Nullable String string2) throws IOException {
        String string3;
        String string4 = VcServiceUtil.downloadClientsXml(sSLConfigurationProvider, string, string2);
        if (!StringUtil.isNullOrEmpty((String)string4) && !StringUtil.isNullOrWhitespace((String)(string3 = VcServiceUtil.getApiVersionFromClientXml(string4)))) {
            return string3;
        }
        throw new IllegalStateException("Failed to extract the API version from XML:\n" + string4);
    }

    private static String downloadClientsXml(@Nonnull SSLConfigurationProvider sSLConfigurationProvider, @Nonnull String string, @Nullable String string2) throws IOException {
        String string3;
        Object object;
        URI uRI;
        try {
            uRI = new URI(string);
            object = new URIBuilder().setHost(uRI.getHost());
            int n = uRI.getPort();
            if (n >= 0) {
                object.setPort(n);
            }
            if (string2 != null) {
                object.setScheme("http");
            } else {
                object.setScheme("https");
            }
            object.setCustomQuery("/client/clients.xml");
            string3 = object.build().toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Invalid service URL: " + string, uRISyntaxException);
        }
        try {
            uRI = new SSLBuilder().sslConfigurationProvider(sSLConfigurationProvider).thumbprint(string2).buildHttpClientIgnoreErrors();
            object = uRI.executeMethod(string3, null, null);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("clients.xml downloaded successfully from " + string3 + ":\n" + (String)object));
            }
            return object;
        }
        catch (Exception exception) {
            throw new IOException("Error when downloading client's xml from " + string3, exception);
        }
    }

    private static String getApiVersionFromClientXml(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return null;
        }
        Document document = XMLUtil.parseXml((String)string);
        if (document == null) {
            _logger.error((Object)"Client xml is null.");
            return null;
        }
        NodeList nodeList = document.getElementsByTagName("apiVersion");
        if (nodeList.getLength() == 0) {
            return null;
        }
        Element element = (Element)nodeList.item(0);
        if (element == null) {
            return null;
        }
        String string2 = XMLUtil.getTagValue((Element)element);
        return string2;
    }

    static {
        VERSION_5_5 = new Version("5.5.0");
        VERSION_6_0 = new Version("6.0.0");
        VERSION_6_1 = new Version("6.1.0");
        VmodlVersionMap vmodlVersionMap = VmodlVersionMap.Factory.getVmodlVersionMap();
        if (vmodlVersionMap.getVersion(version7.class) == null) {
            vmodlVersionMap.addVersion(version7.class);
        }
        if (vmodlVersionMap.getVersion(version8.class) == null) {
            vmodlVersionMap.addVersion(version8.class);
        }
        if (vmodlVersionMap.getVersion(version9.class) == null) {
            vmodlVersionMap.addVersion(version9.class);
        }
        if (vmodlVersionMap.getVersion(version10.class) == null) {
            vmodlVersionMap.addVersion(version10.class);
        }
        if (vmodlVersionMap.getVersion(version11.class) == null) {
            vmodlVersionMap.addVersion(version11.class);
        }
        if (vmodlVersionMap.getVersion(versions.VIM_VERSION_STABLE) == null) {
            vmodlVersionMap.addVersion(versions.VIM_VERSION_STABLE);
        }
        VC_VERSION_5_0 = VcServiceUtil.getVmodlVersion(version7.class);
        VC_VERSION_5_1 = VcServiceUtil.getVmodlVersion(version8.class);
        VC_VERSION_5_5 = VcServiceUtil.getVmodlVersion(version9.class);
        VC_VERSION_6_0 = VcServiceUtil.getVmodlVersion(version10.class);
        VC_VERSION_6_5 = VcServiceUtil.getVmodlVersion(version11.class);
        KNOWN_VC_VMODL_VERSIONS = Arrays.asList(VC_VERSION_5_0, VC_VERSION_5_1, VC_VERSION_5_5, VC_VERSION_6_0, VC_VERSION_6_5);
    }
}

