/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons;

import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.session.SessionDataContainerMissingException;
import com.vmware.vise.util.session.SessionInvalidatedException;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.extensions.impl.LinkedVcGroupRegistryImpl;
import com.vmware.vise.vim.commons.security.NotAuthenticatedError;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.lang.invoke.MethodHandles;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VimSessionUtil {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    public static final String LINKED_VC_GROUP_REGISTRY = "LINKED_VC_GROUP_REGISTRY";
    public static final String SSO_TOKEN = "SSO_TOKEN";

    public static VcService getService(String string) {
        return VimSessionUtil.getService(string, null);
    }

    public static VcService getServiceByClientId(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistryByClientId(string2);
        if (linkedVcGroupRegistry == null) {
            return null;
        }
        LinkedVcGroup linkedVcGroup = linkedVcGroupRegistry.getLinkedGroupByServiceUuid(string);
        if (linkedVcGroup != null) {
            return linkedVcGroup.getVcService(string);
        }
        return null;
    }

    public static VcService getService(String string, HttpSession httpSession) {
        if (httpSession == null && (httpSession = SessionUtil.getHttpSession((boolean)false)) == null) {
            return null;
        }
        String string2 = SessionUtil.getClientId((HttpSession)httpSession);
        if (string2 == null) {
            return null;
        }
        return VimSessionUtil.getServiceByClientId(string, string2);
    }

    public static LinkedVcGroupRegistry getLinkedVcGroupRegistryByClientId(String string) {
        try {
            Object object;
            Object object2;
            if (string == null && (object2 = SessionUtil.getHttpSession((boolean)false)) != null) {
                string = SessionUtil.getClientId((HttpSession)object2);
            }
            if (string == null) {
                _logger.error((Object)("The clientId is null:\n" + ExceptionUtil.getCurrentStackTrace()));
                throw new NotAuthenticatedError();
            }
            object2 = (LinkedVcGroupRegistry)SessionUtil.getData((String)LINKED_VC_GROUP_REGISTRY, (String)string);
            if (object2 == null && (object = SessionUtil.setDataIfAbsent((String)LINKED_VC_GROUP_REGISTRY, (Object)(object2 = new LinkedVcGroupRegistryImpl()), (String)string, (boolean)true)) != null) {
                object2 = (LinkedVcGroupRegistry)object;
            }
            return object2;
        }
        catch (SessionDataContainerMissingException | SessionInvalidatedException | IllegalStateException throwable) {
            throw new NotAuthenticatedError(throwable);
        }
    }

    public static LinkedVcGroupRegistry getLinkedVcGroupRegistry(HttpSession httpSession) {
        if (httpSession == null) {
            httpSession = SessionUtil.getHttpSession((boolean)false);
        }
        if (httpSession == null) {
            _logger.error((Object)("The session is null:\n" + ExceptionUtil.getCurrentStackTrace()));
            throw new NotAuthenticatedError();
        }
        String string = SessionUtil.getClientId((HttpSession)httpSession);
        if (string == null) {
            _logger.error((Object)("The clientId is null:\n" + ExceptionUtil.getCurrentStackTrace()));
            throw new NotAuthenticatedError();
        }
        return VimSessionUtil.getLinkedVcGroupRegistryByClientId(string);
    }

    public static LinkedVcGroupRegistry getLinkedVcGroupRegistry() {
        return VimSessionUtil.getLinkedVcGroupRegistryByClientId(null);
    }

    public static LinkedVcGroupRegistry removeLinkedVcGroupRegistry(HttpSession httpSession) {
        return (LinkedVcGroupRegistry)SessionUtil.removeData((String)LINKED_VC_GROUP_REGISTRY, (HttpSession)httpSession);
    }

    public static HttpSession getHttpSession(boolean bl) {
        return SessionUtil.getHttpSession((boolean)bl);
    }

    public static HttpSession getHttpSession() {
        return SessionUtil.getHttpSession();
    }

    public static String getClientId(HttpSession httpSession) {
        return SessionUtil.getClientId((HttpSession)httpSession);
    }

    public static <T> T getData(String string) {
        return (T)SessionUtil.getData((String)string);
    }

    public static <T> T getData(String string, HttpSession httpSession) {
        return (T)SessionUtil.getData((String)string, (HttpSession)httpSession);
    }

    public static <T> T getData(String string, String string2) {
        return (T)SessionUtil.getData((String)string, (String)string2);
    }

    public static void setData(String string, Object object) {
        SessionUtil.setData((String)string, (Object)object);
    }

    public static void setData(String string, Object object, boolean bl) {
        SessionUtil.setData((String)string, (Object)object, (boolean)bl);
    }

    public static void setData(String string, Object object, HttpSession httpSession) {
        SessionUtil.setData((String)string, (Object)object, (HttpSession)httpSession);
    }

    public static void setData(String string, Object object, HttpSession httpSession, boolean bl) {
        SessionUtil.setData((String)string, (Object)object, (boolean)bl);
    }

    public static void setData(String string, Object object, String string2) {
        SessionUtil.setData((String)string, (Object)object, (String)string2);
    }

    public static void setData(String string, Object object, String string2, boolean bl) {
        SessionUtil.setData((String)string, (Object)object, (String)string2, (boolean)bl);
    }

    public static SamlToken getSsoToken() {
        return AuthSessionUtil.getSsoToken((HttpSession)null);
    }

    public static SamlToken getSsoToken(HttpSession httpSession) {
        return AuthSessionUtil.getSsoToken((HttpSession)httpSession);
    }

    public static SamlToken getSsoToken(String string) {
        return AuthSessionUtil.getSsoToken((String)string);
    }
}

