/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.extensions.impl;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistryListener;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LinkedVcGroupRegistryImpl
implements LinkedVcGroupRegistry {
    private static final Log _logger = LogFactory.getLog(LinkedVcGroupRegistryImpl.class);
    private static final String ALL_GROUPS_TAG = "ALL-GROUPS";
    private final Object _lock = new Object();
    private final Map<String, Set<LinkedVcGroup>> _vcGroupsByTag = new HashMap<String, Set<LinkedVcGroup>>();
    private final List<LinkedVcGroupRegistryListener> _listeners = new ArrayList<LinkedVcGroupRegistryListener>();
    private final Map<String, LinkedVcGroup> _vcGroupByServiceUuid = new HashMap<String, LinkedVcGroup>();
    private List<LinkedVcGroupRegistryListener.Event> _pendingNotifications = new ArrayList<LinkedVcGroupRegistryListener.Event>();
    private HttpSession _session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedVcGroupRegistryImpl() {
        Object object = this._lock;
        synchronized (object) {
            this._vcGroupsByTag.put(ALL_GROUPS_TAG, new HashSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHttpSession(HttpSession httpSession) {
        if (httpSession == null) {
            throw new IllegalArgumentException("session");
        }
        ArrayList<LinkedVcGroupRegistryListener> arrayList = null;
        ArrayList<LinkedVcGroupRegistryListener.Event> arrayList2 = null;
        Iterator iterator = this._lock;
        synchronized (iterator) {
            if (this._session != null) {
                throw new IllegalArgumentException("Session is already set for this LinkedVcGroupRegistry.");
            }
            this._session = httpSession;
            if (this._pendingNotifications == null) {
                return;
            }
            arrayList2 = new ArrayList<LinkedVcGroupRegistryListener.Event>(this._pendingNotifications);
            arrayList = new ArrayList<LinkedVcGroupRegistryListener>(this._listeners);
            this._pendingNotifications = null;
        }
        for (LinkedVcGroupRegistryListener.Event event : arrayList2) {
            event.session = this._session;
            this.notifyListeners(arrayList, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addLinkedVcGroup(LinkedVcGroup linkedVcGroup) {
        if (linkedVcGroup == null) {
            throw new IllegalArgumentException("group");
        }
        LinkedList<LinkedVcGroupRegistryListener> linkedList = null;
        HttpSession httpSession = null;
        Object object = this._lock;
        synchronized (object) {
            if (this._vcGroupsByTag.get(ALL_GROUPS_TAG).add(linkedVcGroup)) {
                for (ServiceEndpointEx serviceEndpointEx : linkedVcGroup.getServiceEndPoints()) {
                    this._vcGroupByServiceUuid.put(serviceEndpointEx.instanceUuid, linkedVcGroup);
                }
                linkedList = new LinkedList<LinkedVcGroupRegistryListener>();
                linkedList.addAll(this._listeners);
            }
            httpSession = this._session;
        }
        if (linkedList != null) {
            this.notifyListeners(linkedList, new LinkedVcGroupRegistryListener.Event(linkedVcGroup, "", httpSession, LinkedVcGroupRegistryListener.Event.GroupOp.add));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLinkedVcGroupRegistryListener(LinkedVcGroupRegistryListener linkedVcGroupRegistryListener) {
        if (linkedVcGroupRegistryListener == null) {
            throw new IllegalArgumentException("listener");
        }
        Object object = this._lock;
        synchronized (object) {
            this._listeners.add(linkedVcGroupRegistryListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedVcGroup[] getLinkedVcGroups() {
        Object object = this._lock;
        synchronized (object) {
            return this._vcGroupsByTag.get(ALL_GROUPS_TAG).toArray(new LinkedVcGroup[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedVcGroup[] getLinkedVcGroupsByTag(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            throw new IllegalArgumentException("tag");
        }
        LinkedVcGroup[] linkedVcGroupArray = new LinkedVcGroup[]{};
        Object object = this._lock;
        synchronized (object) {
            Set<LinkedVcGroup> set = this._vcGroupsByTag.get(string);
            if (set != null) {
                return set.toArray(linkedVcGroupArray);
            }
        }
        return linkedVcGroupArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLinkedVcGroup(LinkedVcGroup linkedVcGroup) {
        if (linkedVcGroup == null) {
            throw new IllegalArgumentException("group");
        }
        LinkedList<LinkedVcGroupRegistryListener> linkedList = null;
        HttpSession httpSession = null;
        Object object = this._lock;
        synchronized (object) {
            if (this._vcGroupsByTag.get(ALL_GROUPS_TAG).remove(linkedVcGroup)) {
                for (String string : this._vcGroupsByTag.keySet()) {
                    this._vcGroupsByTag.get(string).remove(linkedVcGroup);
                }
                for (ServiceEndpointEx serviceEndpointEx : linkedVcGroup.getServiceEndPoints()) {
                    this._vcGroupByServiceUuid.remove(serviceEndpointEx.instanceUuid);
                }
                linkedList = new LinkedList<LinkedVcGroupRegistryListener>();
                linkedList.addAll(this._listeners);
            }
            httpSession = this._session;
        }
        if (linkedList != null) {
            this.notifyListeners(linkedList, new LinkedVcGroupRegistryListener.Event(linkedVcGroup, "", httpSession, LinkedVcGroupRegistryListener.Event.GroupOp.remove));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLinkedVcGroupRegistryListener(LinkedVcGroupRegistryListener linkedVcGroupRegistryListener) {
        if (linkedVcGroupRegistryListener == null) {
            throw new IllegalArgumentException("listener");
        }
        Object object = this._lock;
        synchronized (object) {
            this._listeners.remove(linkedVcGroupRegistryListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedVcGroup getLinkedGroupByServiceUuid(String string) {
        if (string == null) {
            throw new IllegalArgumentException("serviceGuid");
        }
        LinkedVcGroup linkedVcGroup = null;
        Object object = this._lock;
        synchronized (object) {
            linkedVcGroup = this._vcGroupByServiceUuid.get(string);
        }
        return linkedVcGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addTag(LinkedVcGroup linkedVcGroup, String string) {
        if (linkedVcGroup == null) {
            throw new IllegalArgumentException("group");
        }
        if (StringUtil.isNullOrEmpty((String)string)) {
            throw new IllegalArgumentException("tag");
        }
        LinkedList<LinkedVcGroupRegistryListener> linkedList = null;
        HttpSession httpSession = null;
        Object object = this._lock;
        synchronized (object) {
            if (!this._vcGroupsByTag.get(ALL_GROUPS_TAG).contains(linkedVcGroup)) {
                throw new IllegalArgumentException("group not found in registry");
            }
            if (this._vcGroupsByTag.get(string) == null) {
                this._vcGroupsByTag.put(string, new HashSet());
            }
            if (this._vcGroupsByTag.get(string).add(linkedVcGroup)) {
                linkedList = new LinkedList<LinkedVcGroupRegistryListener>();
                linkedList.addAll(this._listeners);
            }
            httpSession = this._session;
        }
        if (linkedList != null) {
            this.notifyListeners(linkedList, new LinkedVcGroupRegistryListener.Event(linkedVcGroup, string, httpSession, LinkedVcGroupRegistryListener.Event.GroupOp.addTag));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTag(LinkedVcGroup linkedVcGroup, String string) {
        if (linkedVcGroup == null) {
            throw new IllegalArgumentException("group");
        }
        if (StringUtil.isNullOrEmpty((String)string)) {
            throw new IllegalArgumentException("tag");
        }
        LinkedList<LinkedVcGroupRegistryListener> linkedList = null;
        HttpSession httpSession = null;
        Object object = this._lock;
        synchronized (object) {
            if (this._vcGroupsByTag.get(string) == null) {
                return false;
            }
            if (this._vcGroupsByTag.get(string).remove(linkedVcGroup)) {
                linkedList = new LinkedList<LinkedVcGroupRegistryListener>();
                linkedList.addAll(this._listeners);
            }
            httpSession = this._session;
        }
        if (linkedList != null) {
            this.notifyListeners(linkedList, new LinkedVcGroupRegistryListener.Event(linkedVcGroup, string, httpSession, LinkedVcGroupRegistryListener.Event.GroupOp.removeTag));
            return true;
        }
        return false;
    }

    @Override
    public LinkedVcGroupRegistry.StartupGroupUtils getUtils() {
        return new UtilsImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(List<LinkedVcGroupRegistryListener> list, LinkedVcGroupRegistryListener.Event event) {
        assert (list != null);
        assert (event != null);
        Iterator<LinkedVcGroupRegistryListener> iterator = this._lock;
        synchronized (iterator) {
            if (this._session == null) {
                this._pendingNotifications.add(event);
                return;
            }
        }
        for (LinkedVcGroupRegistryListener linkedVcGroupRegistryListener : list) {
            try {
                linkedVcGroupRegistryListener.onGroupEvent(event);
            }
            catch (Exception exception) {
                _logger.error((Object)"Uncaught exception in linked vc group event listener: ", (Throwable)exception);
            }
        }
    }

    private class UtilsImpl
    implements LinkedVcGroupRegistry.StartupGroupUtils {
        private static final String STARTUP_GROUP_TAG = "STARTUP-GROUPS";

        private UtilsImpl() {
        }

        @Override
        public boolean addStartupLinkedVcGroup(LinkedVcGroup linkedVcGroup) {
            if (linkedVcGroup == null) {
                throw new IllegalArgumentException("group");
            }
            LinkedVcGroupRegistryImpl.this.addLinkedVcGroup(linkedVcGroup);
            return LinkedVcGroupRegistryImpl.this.addTag(linkedVcGroup, STARTUP_GROUP_TAG);
        }

        @Override
        public LinkedVcGroup[] getStartupLinkedVcGroups() {
            return LinkedVcGroupRegistryImpl.this.getLinkedVcGroupsByTag(STARTUP_GROUP_TAG);
        }

        @Override
        public boolean removeStartupLinkedVcGroup(LinkedVcGroup linkedVcGroup) {
            if (linkedVcGroup == null) {
                throw new IllegalArgumentException("group");
            }
            return LinkedVcGroupRegistryImpl.this.removeLinkedVcGroup(linkedVcGroup);
        }
    }
}

