/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.logging;

import ch.qos.logback.classic.Level;
import com.vmware.vise.util.logging.LogUtil;
import flex.messaging.log.AbstractTarget;
import flex.messaging.log.LogEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLoggingTarget
extends AbstractTarget {
    private static final Logger _logger = LoggerFactory.getLogger(Slf4jLoggingTarget.class);
    private final boolean _canSetLogLevelProgrammatically;
    private volatile boolean _alreadyLoggedError;

    public Slf4jLoggingTarget() {
        boolean bl;
        try {
            LogUtil.LogLevelSetter.setLogLevelStatic((String)"_dummy_logger_", (String)"DEBUG");
            bl = true;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            bl = false;
        }
        this._canSetLogLevelProgrammatically = bl;
    }

    public void logEvent(LogEvent logEvent) {
        String string = logEvent.logger.getCategory();
        Logger logger = LoggerFactory.getLogger((String)string);
        short s = logEvent.level;
        this.setLogLevel(logger, s);
        if (s >= 8) {
            logger.error(logEvent.message, logEvent.throwable);
        } else if (s >= 6) {
            logger.warn(logEvent.message, logEvent.throwable);
        } else if (s >= 4) {
            logger.info(logEvent.message, logEvent.throwable);
        } else if (s >= 2) {
            logger.debug(logEvent.message, logEvent.throwable);
        } else {
            logger.trace(logEvent.message, logEvent.throwable);
        }
    }

    private void setLogLevel(Logger logger, short s) {
        block10: {
            if (!this._canSetLogLevelProgrammatically) {
                return;
            }
            try {
                switch (s) {
                    case 8: 
                    case 1000: {
                        if (logger.isErrorEnabled()) break;
                        LogUtil.LogLevelSetter.setLogLevelStatic((String)logger.getName(), (String)Level.ERROR.levelStr);
                        break;
                    }
                    case 6: {
                        if (logger.isWarnEnabled()) break;
                        LogUtil.LogLevelSetter.setLogLevelStatic((String)logger.getName(), (String)Level.WARN.levelStr);
                        break;
                    }
                    case 4: {
                        if (logger.isInfoEnabled()) break;
                        LogUtil.LogLevelSetter.setLogLevelStatic((String)logger.getName(), (String)Level.INFO.levelStr);
                        break;
                    }
                    case 2: {
                        if (logger.isDebugEnabled()) break;
                        LogUtil.LogLevelSetter.setLogLevelStatic((String)logger.getName(), (String)Level.DEBUG.levelStr);
                        break;
                    }
                    case 0: {
                        if (logger.isTraceEnabled()) break;
                        LogUtil.LogLevelSetter.setLogLevelStatic((String)logger.getName(), (String)Level.TRACE.levelStr);
                    }
                }
            }
            catch (Exception exception) {
                if (this._alreadyLoggedError) break block10;
                _logger.error("Failed to set log level", (Throwable)exception);
                this._alreadyLoggedError = true;
            }
        }
    }
}

