/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.mks.tomcat;

import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.concurrent.QueuingCachedThreadPool;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.http.HttpUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.mks.tomcat.RemoteConsoleMessageInbound;
import com.vmware.vise.vim.commons.mks.util.AuthdClient;
import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WebSocketServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TomcatAuthdAdapterServlet
extends WebSocketServlet {
    private static final int DEFAULT_MAX_CONNECTIONS = 300;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private volatile Executor _executor;
    private volatile int _bufferSize;
    private static final Log _logger = LogFactory.getLog(TomcatAuthdAdapterServlet.class);
    private static final String TICKET = "ticket";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String CFG_FILE = "cfgFile";
    private static final String THUMBPRINT = "thumbprint";
    private static final String SUB_PROTOCOL = "binary";
    private static final String SOCKET = "socket";

    protected StreamInbound createWebSocketInbound(String string, HttpServletRequest httpServletRequest) {
        try {
            Socket socket = (Socket)httpServletRequest.getAttribute(SOCKET);
            return new RemoteConsoleMessageInbound(socket, this._executor, this._bufferSize);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected String selectSubProtocol(List<String> list) {
        return list.contains(SUB_PROTOCOL) ? SUB_PROTOCOL : null;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{httpServletRequest});
        TomcatAuthdAdapterServlet.validateRequireParams(httpServletRequest, HOST, PORT, CFG_FILE, TICKET, THUMBPRINT);
        if (HttpUtil.isSameOrigin((HttpServletRequest)httpServletRequest)) {
            _logger.debug((Object)("Session ID: " + SessionUtil.getHashedSessionId()));
            String string = TomcatAuthdAdapterServlet.sanitize(new String(httpServletRequest.getParameter(HOST).getBytes("ISO8859_1"), "UTF-8"));
            String string2 = TomcatAuthdAdapterServlet.sanitize(httpServletRequest.getParameter(PORT));
            int n = string2 != null ? Integer.parseInt(string2) : -1;
            String string3 = TomcatAuthdAdapterServlet.sanitize(new String(httpServletRequest.getParameter(CFG_FILE).getBytes("ISO8859_1"), "UTF-8"));
            String string4 = TomcatAuthdAdapterServlet.sanitize(httpServletRequest.getParameter(TICKET));
            String string5 = TomcatAuthdAdapterServlet.sanitize(httpServletRequest.getParameter(THUMBPRINT));
            try {
                Socket socket = TomcatAuthdAdapterServlet.createSocketConnection(string, n, string3, string4, string5);
                httpServletRequest.setAttribute(SOCKET, (Object)socket);
                super.doGet(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else {
            httpServletResponse.sendError(403);
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        int n = 0;
        String string = servletConfig.getInitParameter("maxConnections");
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 300;
        }
        this._executor = ThreadPoolFactory.newQueingCachedThreadPool((int)n, (ThreadFactory)new WorkerThreadFactory("remote-console-message-pool"), (long)2L, (TimeUnit)TimeUnit.SECONDS, (long)1L, (TimeUnit)TimeUnit.MINUTES, (QueuingCachedThreadPool.TaskExpirationPolicy)QueuingCachedThreadPool.TaskExpirationPolicy.CANCEL);
        String string2 = servletConfig.getInitParameter("bufferSize");
        try {
            this._bufferSize = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this._bufferSize = 4096;
        }
    }

    private static Socket createSocketConnection(String string, int n, String string2, String string3, String string4) throws Exception {
        AuthdClient authdClient = new AuthdClient(string, n, string2, string3, string4);
        return authdClient.connect();
    }

    private static String sanitize(String string) {
        if (string == null) {
            return null;
        }
        if ("".equals(string.trim())) {
            return null;
        }
        return string;
    }

    private static void validateRequireParams(HttpServletRequest httpServletRequest, String ... stringArray) {
        for (String string : stringArray) {
            if (httpServletRequest.getParameterMap().containsKey(string)) continue;
            _logger.debug((Object)("Required parameter '" + string + "' is missing."));
            throw new RuntimeException("Required parameter '" + string + "' is missing.");
        }
    }
}

