/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.vcservice.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.vmware.vim.binding.vim.InternalServiceInstanceContent;
import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vim.UserSession;
import com.vmware.vim.binding.vim.fault.InvalidLogin;
import com.vmware.vim.binding.vim.fault.NoPermission;
import com.vmware.vim.binding.vim.fault.NotAuthenticated;
import com.vmware.vim.binding.vim.version.internal.versions;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.NotSupported;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.common.ProtocolBinding;
import com.vmware.vim.vmomi.client.common.Session;
import com.vmware.vim.vmomi.client.exception.SslException;
import com.vmware.vim.vmomi.client.ext.AggregationInvocationInterceptor;
import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vim.vmomi.client.ext.InvocationInterceptor;
import com.vmware.vim.vmomi.client.ext.RequestContextProvider;
import com.vmware.vim.vmomi.client.ext.RequestRetryCallback;
import com.vmware.vim.vmomi.client.ext.ResultInterceptor;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.exception.CertificateValidationException;
import com.vmware.vim.vmomi.core.exception.InternalException;
import com.vmware.vim.vmomi.core.soap.Unmarshaller;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import com.vmware.vim.vmomi.core.types.impl.VmodlVersionImpl;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.OpIdUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.Version;
import com.vmware.vise.util.concurrent.BlockingCounter;
import com.vmware.vise.util.concurrent.QueuingCachedThreadPool;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.debug.TimeMonitor;
import com.vmware.vise.util.i18n.LocalizationUtil;
import com.vmware.vise.util.logging.LogUtil;
import com.vmware.vise.util.reflection.ReflectionUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.I18nUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.security.NotAuthenticatedError;
import com.vmware.vise.vim.commons.vcservice.LoginSpec;
import com.vmware.vise.vim.commons.vcservice.SSPIException;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vcservice.VcServiceConnectionInfo;
import com.vmware.vise.vim.commons.vcservice.impl.AuthenticationState;
import com.vmware.vise.vim.commons.vcservice.impl.VcServiceRelatedEndpointPredicate;
import com.vmware.vise.vim.commons.vcservice.impl.VcSessionListenerRegistry;
import com.vmware.vise.vim.commons.vmomi.ClientWithSharedHttpConfig;
import com.vmware.vise.vim.commons.vmomi.SharedHttpConfigPool;
import com.vmware.vise.vim.commons.vmomi.VmomiClientHelper;
import com.vmware.vise.vim.commons.vmomi.request.DelegatingRequestContextProvider;
import com.vmware.vise.vim.commons.vmomi.request.ManagedObjectContextHandler;
import com.vmware.vise.vim.commons.vmomi.request.OpIdContextHandler;
import com.vmware.vise.vim.commons.vmomi.request.SessionManagerContextHandler;
import com.vmware.vise.vim.commons.vmomi.response.ResultInterceptorImpl;
import com.vmware.vise.vim.commons.vmomi.vc.VcAwareSharedHttpConfigPool;
import com.vmware.vise.vim.commons.vsphere.internal.Config;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NoHttpResponseException;

public class VcServiceImpl
implements VcService {
    private static final AtomicInteger SERVICE_ID_GENERATOR = new AtomicInteger();
    private static final int MAX_LOGIN_ATTEMPTS = 3;
    private static final Log _logger = LogFactory.getLog(VcServiceImpl.class);
    private static final Log _opIdLogger = LogUtil.getOpIdLogger();
    private static final long CLIENT_TIMEOUT = 5L;
    private static final TimeUnit CLIENT_TIMEOUT_TIME_UNIT = TimeUnit.MINUTES;
    private static final String KEY_LOGIN_COUNT = "vsphere.vcService.loginCount";
    private final Object _lockObject = new Object();
    private final BlockingCounter _vmomiClientCounter = new BlockingCounter();
    private final AtomicReference<String> _logoutRecord = new AtomicReference();
    private Client _vmomiClient;
    private VcServiceConnectionInfo _connectionInfo;
    private AuthenticationState _authenticationState = AuthenticationState.NOT_AUTHENTICATED;
    private final LoginSpec _loginSpec;
    private final RequestRetryCallbackImpl _retryCallback = new RequestRetryCallbackImpl();
    private final DelegatingRequestContextProvider _requestContextProvider;
    private final AtomicReference<String> _vcDetails = new AtomicReference<String>("?");
    private final ResultInterceptorImpl _resultInterceptor = new ResultInterceptorImpl(this._vcDetails);
    private FutureTask<VcServiceConnectionInfo> _loginTask;
    private LoginType _loginType;
    private final AtomicInteger _loginCounter = new AtomicInteger(0);
    private final VmodlContext _vmodlContext;
    private final ServiceInstance _serviceInstance;
    private final ServiceInstanceContent _serviceInstanceContent;
    private final AtomicReference<ServiceEndpointEx[]> _endPointsRef;
    private final SessionManager _sessionManager;
    private final String _serviceUrl;
    private final String _thumbprint;
    private final boolean _ignoreSslErrors;
    private final String _serviceGuid;
    private final String _serviceVersion;
    private final VcSessionListenerRegistry _listenerRegistry;
    private final Class<?> _version;
    private final NotAuthenticatedCallback _notAuthenticatedCb;
    private final boolean _isSingleServerLogin;
    private final String _vcLocale;
    private final String _id;
    private final VmodlVersionMap versionMap = VmodlVersionMap.Factory.getVmodlVersionMap();
    private static final String POOL_NAME = "vc-service-pool";
    private static final ExecutorService EXECUTOR = ThreadPoolFactory.newQueingCachedThreadPool((int)100, (ThreadFactory)new WorkerThreadFactory("vc-service-pool"), (long)10L, (TimeUnit)TimeUnit.SECONDS, (long)1L, (TimeUnit)TimeUnit.MINUTES, (QueuingCachedThreadPool.TaskExpirationPolicy)QueuingCachedThreadPool.TaskExpirationPolicy.CALLER_RUNS);
    private static final AtomicReference<VcAwareSharedHttpConfigPool> _httpConfigPoolRef = new AtomicReference();

    public VcServiceImpl(LoginSpec loginSpec) throws Exception {
        this(loginSpec, null, null);
    }

    public VcServiceImpl(LoginSpec loginSpec, NotAuthenticatedCallback notAuthenticatedCallback, VcSessionListenerRegistry vcSessionListenerRegistry) throws Exception {
        this._id = String.valueOf(3000000 + SERVICE_ID_GENERATOR.incrementAndGet());
        this._notAuthenticatedCb = notAuthenticatedCallback;
        this._loginSpec = loginSpec;
        this._serviceUrl = this.constructServiceUrl(this._loginSpec.serviceUrl);
        this._thumbprint = this._loginSpec.thumbprint;
        this._ignoreSslErrors = this._loginSpec.ignoreSslThumbprint;
        if (loginSpec.vmodlVersion != null) {
            this._version = this._loginSpec.vmodlVersion;
        } else {
            _logger.warn((Object)("The VMODL version is not available for VC " + this._loginSpec.serviceUrl + " (" + this._loginSpec.serviceGuid + "). Assuming it is " + versions.VIM_VERSION_STABLE.getSimpleName()));
            this._version = versions.VIM_VERSION_STABLE;
        }
        this._listenerRegistry = vcSessionListenerRegistry;
        VmodlContext vmodlContext = null;
        try {
            vmodlContext = VmodlContext.getContext();
        }
        catch (IllegalStateException illegalStateException) {
            vmodlContext = VmodlContext.initContext((String[])new String[]{"com.vmware.vim.binding.vim"});
        }
        this._requestContextProvider = new DelegatingRequestContextProvider(new OpIdContextHandler(), new SessionManagerContextHandler(this._loginSpec));
        this._vmodlContext = vmodlContext;
        InitialProperties initialProperties = VcServiceImpl.initializeVmomi(this._serviceUrl, this._version, this._ignoreSslErrors, this._thumbprint, loginSpec.sslTrustAnchor, this._retryCallback, this._requestContextProvider, this._resultInterceptor, this._loginSpec.endpoints, this._loginCounter, this._loginSpec.locale, this._vcDetails, this._id);
        this._vmomiClient = initialProperties._vmomiClient;
        this._serviceInstance = initialProperties._serviceInstance;
        this._serviceInstanceContent = initialProperties._serviceInstanceContent;
        this._endPointsRef = new AtomicReference<ServiceEndpointEx[]>(initialProperties._endPoints);
        this._sessionManager = initialProperties._sessionManager;
        this._serviceGuid = initialProperties._serviceGuid;
        this._serviceVersion = initialProperties._serviceVersion;
        this._isSingleServerLogin = loginSpec.isSingleServerLogin;
        this._vcLocale = initialProperties._vcLocale;
        _logger.info((Object)("VC " + this._serviceUrl + " has guid " + this._serviceGuid));
        UserSession userSession = null;
        String string = initialProperties._errorCode;
        boolean bl = false;
        String string2 = VcServiceImpl.getSessionCookie(initialProperties._vmomiClient);
        this._connectionInfo = new VcServiceConnectionInfo(userSession, string, bl, string2);
    }

    @VisibleForTesting
    static void setHttpConfigPool(@Nullable VcAwareSharedHttpConfigPool vcAwareSharedHttpConfigPool) {
        _httpConfigPoolRef.set(vcAwareSharedHttpConfigPool);
    }

    private static VcAwareSharedHttpConfigPool getHttpConfigPool() {
        VcAwareSharedHttpConfigPool vcAwareSharedHttpConfigPool;
        boolean bl;
        do {
            if ((vcAwareSharedHttpConfigPool = _httpConfigPoolRef.get()) == null) continue;
            return vcAwareSharedHttpConfigPool;
        } while (!(bl = _httpConfigPoolRef.compareAndSet(null, vcAwareSharedHttpConfigPool = VcAwareSharedHttpConfigPool.builder().maxConnections(Config.VMOMI_HTTP_CONNECTION_POOL_SIZE_VC).timeoutInMillis(Config.VMOMI_HTTP_SOCKET_TIMEOUT_VC).connectionTimeoutInMillis(Config.VMOMI_HTTP_SOCKET_CONNECTION_TIMEOUT_VC).build())));
        return vcAwareSharedHttpConfigPool;
    }

    public Class<?> getVmodlVersion() {
        return this._version;
    }

    @Override
    public String getThumbprint() {
        return this._thumbprint;
    }

    @Override
    public ServiceInstance getServiceInstance() {
        return this._serviceInstance;
    }

    @Override
    public ServiceInstanceContent getServiceInstanceContent() {
        return this._serviceInstanceContent;
    }

    @Override
    public ServiceEndpointEx[] getServiceEndPoints() {
        ServiceEndpointEx[] serviceEndpointExArray = this._endPointsRef.get();
        serviceEndpointExArray = Arrays.copyOf(serviceEndpointExArray, serviceEndpointExArray.length);
        return serviceEndpointExArray;
    }

    boolean removeServiceEndpoints(@Nonnull Collection<? extends ServiceEndpointEx> collection) {
        ServiceEndpointEx[] serviceEndpointExArray;
        ServiceEndpointEx[] serviceEndpointExArray2;
        boolean bl;
        boolean bl2;
        Preconditions.checkArgument((collection != null ? 1 : 0) != 0);
        if (collection.isEmpty()) {
            return false;
        }
        while (!(bl2 = !(bl = (serviceEndpointExArray2 = (ServiceEndpointEx[])ArrayUtil.removeAll((Object[])(serviceEndpointExArray = this._endPointsRef.get()), collection)) != serviceEndpointExArray) ? true : this._endPointsRef.compareAndSet(serviceEndpointExArray, serviceEndpointExArray2))) {
        }
        return bl;
    }

    boolean removeServiceEndpointsRelatedToVcServices(@Nonnull Collection<VcService> collection) {
        VcServiceRelatedEndpointPredicate vcServiceRelatedEndpointPredicate;
        ServiceEndpointEx[] serviceEndpointExArray;
        ServiceEndpointEx[] serviceEndpointExArray2;
        boolean bl;
        boolean bl2;
        Preconditions.checkArgument((collection != null ? 1 : 0) != 0);
        if (collection.isEmpty()) {
            return false;
        }
        while (!(bl2 = !(bl = (serviceEndpointExArray2 = (ServiceEndpointEx[])ArrayUtil.removeAll((Object[])(serviceEndpointExArray = this._endPointsRef.get()), (Predicate)(vcServiceRelatedEndpointPredicate = new VcServiceRelatedEndpointPredicate(collection)))) != serviceEndpointExArray) ? true : this._endPointsRef.compareAndSet(serviceEndpointExArray, serviceEndpointExArray2))) {
        }
        return bl;
    }

    @Override
    public Unmarshaller getDeserializer() {
        VmodlVersionImpl vmodlVersionImpl = new VmodlVersionImpl(this._version, this.versionMap);
        return this._vmodlContext.createQSResponseUnmarshaller((VmodlVersion)vmodlVersionImpl, null);
    }

    @Override
    public String getServiceGuid() {
        return this._serviceGuid;
    }

    @Override
    public String getServiceUrl() {
        return this._serviceUrl;
    }

    @Override
    public String getServiceVersion() {
        return this._serviceVersion;
    }

    @Override
    public VcServiceConnectionInfo getConnectionInfo() {
        VcServiceConnectionInfo vcServiceConnectionInfo = this.getCurrentConnectionInfo();
        return vcServiceConnectionInfo;
    }

    public VcServiceConnectionInfo login() throws Exception {
        return this.doLogin(LoginType.REGULAR, null);
    }

    private VcServiceConnectionInfo doLogin(LoginType loginType, String string) throws Exception {
        this._retryCallback._vcService = this;
        VcServiceConnectionInfo vcServiceConnectionInfo = this.processLogin(loginType, string);
        _logger.info((Object)("Successfully logged in for session: " + SessionUtil.getHashedSessionId()));
        return vcServiceConnectionInfo;
    }

    private FutureTask<VcServiceConnectionInfo> createLoginTask(final LoginType loginType, final String string) {
        Callable<VcServiceConnectionInfo> callable = new Callable<VcServiceConnectionInfo>(){

            @Override
            public VcServiceConnectionInfo call() throws Exception {
                int n = 1;
                while (true) {
                    try {
                        VcServiceConnectionInfo vcServiceConnectionInfo = null;
                        if (loginType == LoginType.REGULAR) {
                            vcServiceConnectionInfo = VcServiceImpl.this.authenticate();
                        } else if (loginType == LoginType.TICKET) {
                            vcServiceConnectionInfo = VcServiceImpl.this.authenticateBySessionTicket(string);
                        } else {
                            throw new UnsupportedOperationException("Unsupported loginType: " + (Object)((Object)loginType));
                        }
                        _logger.info((Object)("logged in VC with id " + VcServiceImpl.this._id));
                        return vcServiceConnectionInfo;
                    }
                    catch (Exception exception) {
                        if (n >= 3) {
                            throw exception;
                        }
                        if (!ExceptionUtil.isCausedBy((Throwable)exception, NoHttpResponseException.class)) {
                            throw exception;
                        }
                        _logger.warn((Object)("Login attempt to VC " + VcServiceImpl.this._serviceUrl + " failed. Will retry."), (Throwable)exception);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            _logger.info((Object)"Retry aborted due to interruption.");
                            Thread.currentThread().interrupt();
                            throw exception;
                        }
                        ++n;
                        continue;
                    }
                    break;
                }
            }
        };
        FutureTask<VcServiceConnectionInfo> futureTask = new FutureTask<VcServiceConnectionInfo>(callable);
        return futureTask;
    }

    private static VcServiceConnectionInfo getResetConnectionInfo(VcServiceConnectionInfo vcServiceConnectionInfo) {
        UserSession userSession = null;
        String string = "noError";
        boolean bl = false;
        String string2 = vcServiceConnectionInfo.getSessionCookie();
        VcServiceConnectionInfo vcServiceConnectionInfo2 = new VcServiceConnectionInfo(userSession, string, bl, string2);
        return vcServiceConnectionInfo2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VcServiceConnectionInfo processLogin(LoginType loginType, String string) throws Exception {
        FutureTask<VcServiceConnectionInfo> futureTask = null;
        boolean bl = false;
        Object object = this._lockObject;
        synchronized (object) {
            if (AuthenticationState.LOGGED_OUT.equals((Object)this._authenticationState)) {
                _logger.error((Object)"Already logged out");
                String string2 = I18nUtil.getLocalizedString("vcService.cannotLogin", new String[0]);
                throw new IllegalStateException(string2);
            }
            if (AuthenticationState.AUTHENTICATED.equals((Object)this._authenticationState)) {
                return this._connectionInfo;
            }
            if (AuthenticationState.AUTHENTICATING.equals((Object)this._authenticationState) && !loginType.equals((Object)this._loginType)) {
                String string3 = I18nUtil.getLocalizedString("vcService.cannotLogin", new String[0]);
                throw new IllegalStateException(string3);
            }
            if (AuthenticationState.NOT_AUTHENTICATED.equals((Object)this._authenticationState)) {
                this.transitionAuthState(AuthenticationState.AUTHENTICATING);
                this._connectionInfo = VcServiceImpl.getResetConnectionInfo(this._connectionInfo);
                this._loginTask = this.createLoginTask(loginType, string);
                this._loginType = loginType;
                bl = true;
            }
            futureTask = this._loginTask;
        }
        if (bl) {
            futureTask.run();
        }
        object = futureTask.get();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VcServiceConnectionInfo authenticate() throws Exception {
        UserSession userSession = null;
        String string = "noError";
        Throwable throwable = null;
        try {
            if (!StringUtil.isNullOrEmpty((String)this._loginSpec.cloneSessionTicket)) {
                userSession = this.loginByCloneTicket(this._loginSpec.cloneSessionTicket);
            } else if (this.supportsLoginByToken() && this._loginSpec.token != null) {
                userSession = this.loginByToken();
            } else if (!StringUtil.isNullOrEmpty((String)this._loginSpec.base64SspiToken)) {
                if (!this._loginSpec.isSingleServerLogin) throw new SSPIException(this._serviceUrl);
                userSession = this.loginBySspi(this._loginSpec.base64SspiToken);
            } else {
                userSession = this.loginByUsername();
            }
        }
        catch (NoPermission noPermission) {
            string = "noPermission";
            throwable = noPermission;
        }
        catch (InvalidLogin invalidLogin) {
            string = "invalidCredentials";
            throwable = invalidLogin;
        }
        catch (SSPIException sSPIException) {
            string = "sspiError";
            throwable = sSPIException;
        }
        catch (Exception exception) {
            throwable = exception;
        }
        VcServiceConnectionInfo vcServiceConnectionInfo = null;
        Object object = this._lockObject;
        synchronized (object) {
            boolean bl = false;
            if (userSession != null) {
                bl = true;
                this.transitionAuthState(AuthenticationState.AUTHENTICATED);
                this._loginCounter.incrementAndGet();
            } else {
                this.transitionAuthState(AuthenticationState.NOT_AUTHENTICATED);
            }
            String string2 = VcServiceImpl.getSessionCookie(this._vmomiClient);
            this._connectionInfo = vcServiceConnectionInfo = new VcServiceConnectionInfo(userSession, string, bl, string2);
            this._loginSpec.userName = null;
            this._loginSpec.password = null;
            this._loginTask = null;
            this._loginType = null;
        }
        if (userSession != null) {
            this.notifyListeners();
        }
        if (throwable == null) return vcServiceConnectionInfo;
        throw throwable;
    }

    public VcServiceConnectionInfo loginBySessionTicket(String string) throws Exception {
        return this.doLogin(LoginType.TICKET, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VcServiceConnectionInfo authenticateBySessionTicket(String string) throws Exception {
        UserSession userSession = null;
        Exception exception = null;
        try {
            _logger.debug((Object)("Sending loginBySessionTicket request to vc - " + this._serviceUrl));
            userSession = this._sessionManager.loginBySessionTicket(string);
            _logger.debug((Object)("loginBySessionTicket successful on vc " + this._serviceUrl));
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        VcServiceConnectionInfo vcServiceConnectionInfo = null;
        Object object = this._lockObject;
        synchronized (object) {
            String string2 = "noError";
            boolean bl = false;
            if (userSession != null) {
                bl = true;
                this.transitionAuthState(AuthenticationState.AUTHENTICATED);
                this._loginCounter.incrementAndGet();
            } else {
                this.transitionAuthState(AuthenticationState.NOT_AUTHENTICATED);
            }
            String string3 = VcServiceImpl.getSessionCookie(this._vmomiClient);
            this._connectionInfo = vcServiceConnectionInfo = new VcServiceConnectionInfo(userSession, string2, bl, string3);
            this._loginTask = null;
            this._loginType = null;
        }
        if (userSession != null) {
            this.notifyListeners();
        }
        if (exception != null) {
            throw exception;
        }
        return vcServiceConnectionInfo;
    }

    private UserSession loginBySspi(String string) throws Exception {
        _logger.debug((Object)("Sending loginBySSPI request to vc - " + this._serviceUrl));
        UserSession userSession = this._sessionManager.loginBySSPI(string, this._vcLocale);
        _logger.debug((Object)("loginBySSPI successful on vc " + this._serviceUrl));
        return userSession;
    }

    private UserSession loginByUsername() throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Logging into vc using username - " + this._serviceUrl + " (" + this._serviceGuid + ")"));
        }
        this._loginSpec.userName = this.formatUsername(this._loginSpec.userName);
        UserSession userSession = this._sessionManager.login(this._loginSpec.userName, this._loginSpec.password, this._vcLocale);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("loginByUsername successful on vc " + this._serviceUrl));
        }
        return userSession;
    }

    private String formatUsername(String string) {
        int n = string.indexOf("@");
        if (n == -1) {
            return string;
        }
        _logger.debug((Object)("Username is in netbios format - " + string));
        string = string.substring(n + 1) + "\\" + string.substring(0, n);
        _logger.debug((Object)("Username is now transformed to Netbios format - " + string));
        return string;
    }

    private UserSession loginByToken() throws Exception {
        try {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Logging into vc using Saml token - " + this._serviceUrl + " (" + this._serviceGuid + ")"));
            }
            UserSession userSession = this._sessionManager.loginByToken(this._vcLocale);
            _logger.info((Object)("loginByToken successful on vc " + this._serviceUrl));
            return userSession;
        }
        catch (NotSupported notSupported) {
            _logger.debug((Object)("Login by token is not supported on the vc " + this._serviceUrl));
            if (!StringUtil.isNullOrEmpty((String)this._loginSpec.base64SspiToken)) {
                throw new SSPIException(this._serviceUrl);
            }
            UserSession userSession = this.loginByUsername();
            return userSession;
        }
    }

    private UserSession loginByCloneTicket(String string) throws Exception {
        _logger.debug((Object)("Sending cloneSession request to vc - " + this._serviceUrl));
        UserSession userSession = this._sessionManager.cloneSession(string);
        _logger.debug((Object)("cloneSession successful on vc " + this._serviceUrl));
        return userSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ManagedObject> T getManagedObject(ManagedObjectReference managedObjectReference) {
        if (managedObjectReference == null) {
            return null;
        }
        VmodlTypeMap vmodlTypeMap = VmodlTypeMap.Factory.getTypeMap();
        VmodlType vmodlType = vmodlTypeMap.getVmodlType(managedObjectReference.getType());
        Class clazz = vmodlType.getTypeClass();
        Client client = null;
        Object object = this._lockObject;
        synchronized (object) {
            if (AuthenticationState.LOGGED_OUT.equals((Object)this._authenticationState)) {
                _logger.error((Object)"Client is already logged out");
                throw new NotAuthenticatedError();
            }
            client = this._vmomiClient;
        }
        if (client == null) {
            _logger.error((Object)"Vmomi client is not initialized.");
            return null;
        }
        boolean bl = this._vmomiClientCounter.increment();
        if (!bl) {
            _logger.info((Object)("VC logout in progress: " + this._logoutRecord.get()));
            throw new NotAuthenticatedError();
        }
        try {
            ManagedObject managedObject = VmomiClientHelper.createStub((Client)client, (Class)clazz, (ManagedObjectReference)managedObjectReference, (ClassLoader)VcServiceImpl.class.getClassLoader());
            ManagedObject managedObject2 = managedObject = this.getProxy(managedObject);
            return (T)managedObject2;
        }
        finally {
            this._vmomiClientCounter.decrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() {
        String string = this.getVcContext();
        _logger.info((Object)("Logging out of VC " + string));
        Client client = null;
        boolean bl = false;
        TimeMonitor timeMonitor = new TimeMonitor();
        timeMonitor.init();
        Object object = this._lockObject;
        synchronized (object) {
            bl = this.transitionAuthState(AuthenticationState.LOGGED_OUT);
            client = this._vmomiClient;
            UserSession userSession = null;
            String string2 = "noError";
            boolean bl2 = false;
            String string3 = null;
            this._connectionInfo = new VcServiceConnectionInfo(userSession, string2, bl2, string3);
            this._vmomiClient = null;
        }
        boolean bl3 = bl;
        if (bl3) {
            this.waitForClientTasks(client);
            this.logoutVc();
            this.shutdownVmomiClient(client);
            this._logoutRecord.set(string);
            timeMonitor.logTime("VcServiceImpl logout");
        } else {
            _logger.info((Object)("VC: " + string + ", was not authenticated. Skipping VC logout."));
        }
    }

    @Override
    public boolean supportsLoginByToken() {
        boolean bl = !this._isSingleServerLogin;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceDirectory.ServiceEndpoint[] fetchServiceEndpoints() {
        Client client = null;
        Object object = this._lockObject;
        synchronized (object) {
            if (AuthenticationState.LOGGED_OUT.equals((Object)this._authenticationState)) {
                _logger.error((Object)"Client is already logged out");
                throw new NotAuthenticatedError();
            }
            client = this._vmomiClient;
        }
        if (client == null) {
            _logger.error((Object)"Vmomi client is not initialized.");
            return null;
        }
        boolean bl = this._vmomiClientCounter.increment();
        if (!bl) {
            _logger.info((Object)("VC logout in progress: " + this._logoutRecord.get()));
            throw new NotAuthenticatedError();
        }
        try {
            ServiceDirectory.ServiceEndpoint[] serviceEndpointArray;
            ServiceDirectory.ServiceEndpoint[] serviceEndpointArray2 = serviceEndpointArray = VcServiceImpl.fetchServiceEndpoints(this._serviceInstance, this._vmomiClient);
            return serviceEndpointArray2;
        }
        finally {
            this._vmomiClientCounter.decrement();
        }
    }

    @Override
    public Boolean getConnectionState() {
        VcServiceConnectionInfo vcServiceConnectionInfo = this.getCurrentConnectionInfo();
        Boolean bl = vcServiceConnectionInfo.getConnectionState();
        return bl;
    }

    @Override
    public String getErrorCode() {
        VcServiceConnectionInfo vcServiceConnectionInfo = this.getCurrentConnectionInfo();
        String string = vcServiceConnectionInfo.getErrorCode();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSessionCookie() {
        Object object = this._lockObject;
        synchronized (object) {
            return this._connectionInfo.getSessionCookie();
        }
    }

    @Override
    public UserSession getUserSession() {
        VcServiceConnectionInfo vcServiceConnectionInfo = this.getCurrentConnectionInfo();
        UserSession userSession = vcServiceConnectionInfo.getUserSession();
        return userSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Client getVmomiClient() {
        Object object = this._lockObject;
        synchronized (object) {
            return this._vmomiClient;
        }
    }

    public List<ManagedObjectContextHandler> getManagedObjectContextHandlers() {
        return this._requestContextProvider.getHandlers();
    }

    private void waitForClientTasks(Client client) {
        try {
            boolean bl;
            if (client != null && !(bl = this._vmomiClientCounter.blockUntilEmpty(5L, CLIENT_TIMEOUT_TIME_UNIT))) {
                _logger.warn((Object)"Timed out or interrupted while waiting for clients to release.");
            }
        }
        catch (Exception exception) {
            String string = String.format("Error waiting for clients to be released %1s.", this._serviceUrl);
            _logger.error((Object)string, (Throwable)exception);
        }
    }

    private void shutdownVmomiClient(Client client) {
        VcServiceImpl.shutdownVmomiClient(client, this._serviceUrl);
    }

    private static void shutdownVmomiClient(Client client, String string) {
        try {
            if (client != null) {
                client.shutdown();
            }
        }
        catch (Exception exception) {
            String string2 = String.format("Error stopping vmomi client at service url %1s.", string);
            _logger.error((Object)string2, (Throwable)exception);
        }
    }

    private void logoutVc() {
        try {
            if (this._sessionManager != null) {
                this._sessionManager.logout();
            }
        }
        catch (NotAuthenticated notAuthenticated) {
            _logger.warn((Object)("NotAuthenticated error when logging out on session - " + SessionUtil.getHashedSessionId()));
        }
        catch (Exception exception) {
            String string = String.format("Error when logging out session manager for vc %1s.", this._serviceUrl);
            _logger.error((Object)string, (Throwable)exception);
        }
    }

    private String getVcContext() {
        HttpSession httpSession = SessionUtil.getHttpSession();
        String string = SessionUtil.getHashedSessionId((HttpSession)httpSession);
        String string2 = SessionUtil.getHashedClientId((HttpSession)httpSession);
        String string3 = this._serviceUrl + " (guid " + this._serviceGuid + ", id " + this._id + ", username " + this._loginSpec.userName + ", sessionID " + string + ", clientId " + string2 + ")";
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VcServiceConnectionInfo getCurrentConnectionInfo() {
        FutureTask<VcServiceConnectionInfo> futureTask = null;
        Object object = this._lockObject;
        synchronized (object) {
            if (!AuthenticationState.AUTHENTICATING.equals((Object)this._authenticationState)) {
                return this._connectionInfo;
            }
            futureTask = this._loginTask;
        }
        try {
            object = futureTask.get();
            return object;
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof NoPermission) {
                _logger.info((Object)("NoPermission error when logging in to vc - " + this._serviceUrl));
            } else {
                _logger.error((Object)("Error while waiting for login: " + this._serviceUrl), (Throwable)executionException);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("Error while waiting for login: " + this._serviceUrl), (Throwable)exception);
        }
        Object object2 = this._lockObject;
        synchronized (object2) {
            return this._connectionInfo;
        }
    }

    private static String getSessionCookie(Client client) {
        if (client == null) {
            return null;
        }
        try {
            ProtocolBinding protocolBinding = client.getBinding();
            if (protocolBinding == null) {
                _logger.error((Object)"Null protocol binding returned by vc client");
                return null;
            }
            Session session = protocolBinding.getSession();
            if (session == null) {
                _logger.debug((Object)"Null session returned by protocol binding");
                return null;
            }
            String string = session.getId();
            return string;
        }
        catch (Exception exception) {
            _logger.error((Object)"Error in getSessionCookie", (Throwable)exception);
            return null;
        }
    }

    private String constructServiceUrl(String string) {
        if (string.indexOf("://") == -1) {
            string = "https://" + string;
        }
        if (string.indexOf("/sdk") == -1) {
            string = string + "/sdk";
        }
        return string.trim();
    }

    private static InitialProperties initializeVmomi(String string, Class<?> clazz, boolean bl, String string2, String string3, RequestRetryCallback requestRetryCallback, RequestContextProvider requestContextProvider, ResultInterceptor resultInterceptor, ServiceEndpointEx[] serviceEndpointExArray, final AtomicInteger atomicInteger, String string4, final AtomicReference<String> atomicReference, String string5) throws Exception {
        String string6;
        Object object;
        _logger.info((Object)("Initializing vmomi for vc - " + string + " at VMODL version " + clazz.getCanonicalName()));
        Client client = null;
        ServiceInstance serviceInstance = null;
        ServiceInstanceContent serviceInstanceContent = null;
        SessionManager sessionManager = null;
        String string7 = null;
        String string8 = null;
        String string9 = "noError";
        try {
            if (bl) {
                string2 = null;
            }
            object = VcServiceImpl.getHttpConfigPool();
            HttpConfiguration httpConfiguration = ((VcAwareSharedHttpConfigPool)object).getHttpConfig(string, clazz, string3, string2);
            URI uRI = URI.create(string);
            HttpClientConfiguration httpClientConfiguration = HttpClientConfiguration.Factory.newInstance();
            httpClientConfiguration.setExecutor((Executor)EXECUTOR);
            httpClientConfiguration.setHttpConfiguration(httpConfiguration);
            httpClientConfiguration.setRequestRetryCallback(requestRetryCallback);
            httpClientConfiguration.setRequestContextProvider(requestContextProvider);
            httpClientConfiguration.setResultInterceptor(resultInterceptor);
            AggregationInvocationInterceptor aggregationInvocationInterceptor = new AggregationInvocationInterceptor();
            httpClientConfiguration.setInvocationInterceptor((InvocationInterceptor)aggregationInvocationInterceptor);
            atomicReference.set(string + " (id=" + string5 + ")");
            aggregationInvocationInterceptor.addInvocationInterceptor(new InvocationInterceptor(){

                public void completeInvocation(InvocationContext invocationContext, boolean bl) {
                }

                public void beginInvocation(InvocationContext invocationContext) {
                    int n = atomicInteger.get();
                    invocationContext.putInvocationContextObject(VcServiceImpl.KEY_LOGIN_COUNT, (Object)n);
                    long l = System.nanoTime();
                    invocationContext.putInvocationContextObject("#invocation.start#", (Object)l);
                    this.logInvocation(invocationContext);
                }

                private Object getOpId(InvocationContext invocationContext) {
                    Object object = invocationContext.getInvocationContextObject("operationID");
                    return object;
                }

                private void logInvocation(InvocationContext invocationContext) {
                    Method method = invocationContext.getMethod().getMethod();
                    LogUtil.LogLevel logLevel = OpIdUtil.determineLogLevelFor((Log)_opIdLogger, (Method)method);
                    if (logLevel == LogUtil.LogLevel.OFF) {
                        return;
                    }
                    Object object = this.getOpId(invocationContext);
                    StringBuilder stringBuilder = new StringBuilder(200);
                    String string = (String)atomicReference.get();
                    String string2 = ReflectionUtil.getBasicSignatureInfo((Method)method);
                    stringBuilder.append("Invoking method '").append(string2).append("' for ").append(string).append(" for opId '").append(object).append("'  (").append(this.getClass().getName()).append(')');
                    if (logLevel == LogUtil.LogLevel.TRACE) {
                        _opIdLogger.trace((Object)stringBuilder);
                    } else {
                        _opIdLogger.debug((Object)stringBuilder);
                    }
                }
            });
            client = Client.Factory.createClient((URI)uRI, clazz, (ClientConfiguration)httpClientConfiguration);
            client = new ClientWithSharedHttpConfig(client, (SharedHttpConfigPool)object);
            ClassLoader classLoader = VcServiceImpl.class.getClassLoader();
            String string10 = "ServiceInstance";
            String string11 = "ServiceInstance";
            ManagedObjectReference managedObjectReference = new ManagedObjectReference(string10, string11, null);
            serviceInstance = (ServiceInstance)VmomiClientHelper.createStub((Client)client, ServiceInstance.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)classLoader);
            serviceInstanceContent = serviceInstance.retrieveContent();
            if (serviceInstanceContent == null) {
                throw new IllegalStateException("Null serviceInstanceContent returned for VC at " + string);
            }
            string8 = serviceInstanceContent.getAbout().getVersion();
            Class<?> clazz2 = VcServiceUtil.determineInternalVmodlVersionByStringVersion(string8);
            if (!(clazz2 == null || clazz != null && VcServiceUtil.areVersionsInSameRelease(clazz, clazz2))) {
                VcServiceImpl.shutdownVmomiClient(client, string);
                client = Client.Factory.createClient((URI)uRI, clazz2, (ClientConfiguration)httpClientConfiguration);
                client = new ClientWithSharedHttpConfig(client, (SharedHttpConfigPool)object);
                managedObjectReference = new ManagedObjectReference(string10, string11, null);
                serviceInstance = (ServiceInstance)VmomiClientHelper.createStub((Client)client, ServiceInstance.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)classLoader);
                serviceInstanceContent = serviceInstance.retrieveContent();
                if (serviceInstanceContent == null) {
                    throw new IllegalStateException("Null serviceInstanceContent returned for VC at " + string);
                }
                string8 = serviceInstanceContent.getAbout().getVersion();
            }
            string7 = serviceInstanceContent.getAbout().getInstanceUuid();
            atomicReference.set(string + " (guid=" + string7 + ", id=" + string5 + ")");
            managedObjectReference = new ManagedObjectReference(string10, string11, string7);
            serviceInstance = (ServiceInstance)VmomiClientHelper.createStub((Client)client, ServiceInstance.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)classLoader);
            ManagedObjectReference managedObjectReference2 = serviceInstanceContent.getSessionManager();
            sessionManager = (SessionManager)VmomiClientHelper.createStub((Client)client, SessionManager.class, (ManagedObjectReference)managedObjectReference2, (ClassLoader)classLoader);
            String[] stringArray = sessionManager.getMessageLocaleList();
            string6 = LocalizationUtil.selectSuitableSupportedLocale((String)string4, (String[])stringArray, (String)"en");
            if (!string6.equals(string4)) {
                _logger.warn((Object)("VC " + string + " doesn't support the requested locale \"" + string4 + "\". Will use \"" + string6 + "\" instead."));
            }
            serviceEndpointExArray = (serviceEndpointExArray = !VcServiceUtil.is60VcOrLater(new Version(string8)) ? VcServiceImpl.fetchServiceEndpoints(serviceInstance, client) : VcServiceImpl.adjustEndpointsForVC60OrLater(serviceEndpointExArray, string7, serviceInstance, client)) != null ? Arrays.copyOf(serviceEndpointExArray, serviceEndpointExArray.length) : ServiceEndpointEx.EMPTY_SERVICE_ENDPOINT_EX_ARRAY;
        }
        catch (Exception exception) {
            if (exception instanceof UndeclaredThrowableException) {
                UndeclaredThrowableException undeclaredThrowableException = (UndeclaredThrowableException)exception;
                if (undeclaredThrowableException.getUndeclaredThrowable() instanceof CertificateValidationException) {
                    string9 = "sslError";
                    throw (Exception)undeclaredThrowableException.getUndeclaredThrowable();
                }
            } else if ((exception instanceof SslException || exception instanceof InternalException) && exception.getCause() instanceof CertificateValidationException) {
                string9 = "sslError";
                throw (Exception)exception.getCause();
            }
            string9 = "connectError";
            throw exception;
        }
        _logger.info((Object)("Vmomi initialization successful for VC " + string + " (" + string7 + "), locale=" + string6));
        object = new InitialProperties();
        ((InitialProperties)object)._vmomiClient = client;
        ((InitialProperties)object)._serviceInstance = serviceInstance;
        ((InitialProperties)object)._serviceInstanceContent = serviceInstanceContent;
        ((InitialProperties)object)._endPoints = serviceEndpointExArray;
        ((InitialProperties)object)._sessionManager = sessionManager;
        ((InitialProperties)object)._serviceGuid = string7;
        ((InitialProperties)object)._serviceVersion = string8;
        ((InitialProperties)object)._errorCode = string9;
        ((InitialProperties)object)._vcLocale = string6;
        return object;
    }

    private static ServiceEndpointEx[] adjustEndpointsForVC60OrLater(ServiceEndpointEx[] serviceEndpointExArray, String string, ServiceInstance serviceInstance, Client client) {
        if (VcServiceImpl.containsGuid(serviceEndpointExArray, string)) {
            return serviceEndpointExArray;
        }
        ServiceEndpointEx[] serviceEndpointExArray2 = VcServiceImpl.fetchServiceEndpoints(serviceInstance, client);
        if (serviceEndpointExArray2 == null || serviceEndpointExArray2.length == 0) {
            return serviceEndpointExArray;
        }
        ArrayList<ServiceEndpointEx> arrayList = new ArrayList<ServiceEndpointEx>(10);
        for (ServiceEndpointEx serviceEndpointEx : serviceEndpointExArray2) {
            String string2 = serviceEndpointEx.getInstanceUuid();
            if (string2 == null || VcServiceImpl.containsGuid(serviceEndpointExArray, string2)) continue;
            arrayList.add(serviceEndpointEx);
        }
        if (arrayList.size() == 0) {
            return serviceEndpointExArray;
        }
        if (serviceEndpointExArray == null) {
            return arrayList.toArray(ServiceEndpointEx.EMPTY_SERVICE_ENDPOINT_EX_ARRAY);
        }
        if (serviceEndpointExArray.length > 0) {
            arrayList.addAll(Arrays.asList(serviceEndpointExArray));
        }
        ServiceEndpointEx[] serviceEndpointExArray3 = arrayList.toArray(ServiceEndpointEx.EMPTY_SERVICE_ENDPOINT_EX_ARRAY);
        return serviceEndpointExArray3;
    }

    private static boolean containsGuid(ServiceEndpointEx[] serviceEndpointExArray, String string) {
        if (serviceEndpointExArray == null || string == null) {
            return false;
        }
        for (ServiceEndpointEx serviceEndpointEx : serviceEndpointExArray) {
            if (!string.equals(serviceEndpointEx.getInstanceUuid())) continue;
            return true;
        }
        return false;
    }

    private void notifyListeners() {
        if (this._listenerRegistry == null) {
            return;
        }
        this._listenerRegistry.notifyListeners(this._serviceGuid);
    }

    private boolean transitionAuthState(AuthenticationState authenticationState) {
        boolean bl = AuthenticationState.isTransitionOk(this._authenticationState, authenticationState);
        if (bl) {
            AuthenticationState authenticationState2 = this._authenticationState;
            this._authenticationState = authenticationState;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("VC " + this.getServiceUrl() + " transitioned from authentication state " + (Object)((Object)authenticationState2) + " to state " + (Object)((Object)authenticationState)));
            }
            return true;
        }
        return false;
    }

    private boolean transitionAuthStateIfStateIs(AuthenticationState authenticationState, AuthenticationState authenticationState2) {
        if (!authenticationState2.equals((Object)this._authenticationState)) {
            return false;
        }
        boolean bl = this.transitionAuthState(authenticationState);
        return bl;
    }

    private static ServiceEndpointEx[] fetchServiceEndpoints(ServiceInstance serviceInstance, Client client) {
        ServiceInstance serviceInstance2 = serviceInstance;
        if (serviceInstance2 == null) {
            return ServiceEndpointEx.EMPTY_SERVICE_ENDPOINT_EX_ARRAY;
        }
        InternalServiceInstanceContent internalServiceInstanceContent = serviceInstance2.retrieveInternalContent();
        ManagedObjectReference managedObjectReference = internalServiceInstanceContent.getServiceDirectory();
        if (managedObjectReference == null) {
            return ServiceEndpointEx.EMPTY_SERVICE_ENDPOINT_EX_ARRAY;
        }
        ServiceDirectory serviceDirectory = (ServiceDirectory)VmomiClientHelper.createStub((Client)client, ServiceDirectory.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)VcServiceImpl.class.getClassLoader());
        if (serviceDirectory == null) {
            return ServiceEndpointEx.EMPTY_SERVICE_ENDPOINT_EX_ARRAY;
        }
        ServiceDirectory.ServiceEndpoint[] serviceEndpointArray = serviceDirectory.queryServiceEndpointList();
        if (serviceEndpointArray == null || serviceEndpointArray.length == 0) {
            return ServiceEndpointEx.EMPTY_SERVICE_ENDPOINT_EX_ARRAY;
        }
        int n = serviceEndpointArray.length;
        ServiceEndpointEx[] serviceEndpointExArray = new ServiceEndpointEx[n];
        for (int i = 0; i < n; ++i) {
            ServiceEndpointEx serviceEndpointEx;
            serviceEndpointExArray[i] = serviceEndpointEx = ServiceEndpointEx.toServiceEndpointEx(serviceEndpointArray[i]);
        }
        return serviceEndpointExArray;
    }

    private <T extends ManagedObject> T getProxy(T t) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{t});
        ManagedObjectHandler managedObjectHandler = new ManagedObjectHandler(this, t);
        ClassLoader classLoader = t.getClass().getClassLoader();
        Class<?> clazz = ManagedObjectUtil.getType(t._getRef());
        ManagedObject managedObject = (ManagedObject)Proxy.newProxyInstance(classLoader, new Class[]{clazz}, (InvocationHandler)managedObjectHandler);
        return (T)managedObject;
    }

    private class FutureWrapper<T>
    implements Future<T> {
        private final Future<T> _originalFuture;
        private final BlockingCounter _counter;
        private final AtomicBoolean _shouldDecrementedCounter = new AtomicBoolean(false);
        private final ManagedObject _managedObject;
        private final Method _method;

        public FutureWrapper(Future<T> future, BlockingCounter blockingCounter, ManagedObject managedObject, Method method) {
            ValidationUtil.paramsNotNull((Object[])new Object[]{future, blockingCounter, managedObject});
            this._originalFuture = future;
            this._counter = blockingCounter;
            this._method = method;
            this._managedObject = managedObject;
        }

        private void decrementCounter() {
            boolean bl = this._shouldDecrementedCounter.compareAndSet(false, true);
            if (bl) {
                this._counter.decrement();
            }
        }

        public boolean cancel(boolean bl) {
            String string = this.getOpIdFromRequestContext();
            _opIdLogger.warn((Object)("Canceling invocation of method " + this._method + "' for " + VcServiceImpl.this.getVcContext() + " for opId " + string));
            boolean bl2 = this._originalFuture.cancel(bl);
            if (bl2) {
                this.decrementCounter();
            }
            return bl2;
        }

        public boolean isCancelled() {
            return this._originalFuture.isCancelled();
        }

        public boolean isDone() {
            return this._originalFuture.isDone();
        }

        public T get() throws InterruptedException, ExecutionException {
            return (T)this._originalFuture.get();
        }

        public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return (T)this._originalFuture.get(l, timeUnit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(T t) {
            try {
                this._originalFuture.set(t);
            }
            finally {
                this.decrementCounter();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set() {
            try {
                this._originalFuture.set();
            }
            finally {
                this.decrementCounter();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setException(Exception exception) {
            try {
                this._originalFuture.setException(exception);
            }
            finally {
                this.decrementCounter();
            }
        }

        @Nullable
        private String getOpIdFromRequestContext() {
            Stub stub = (Stub)this._managedObject;
            RequestContext requestContext = stub._getRequestContext();
            String string = (String)requestContext.get((Object)"operationID");
            return string;
        }
    }

    private static class ManagedObjectHandler<T extends ManagedObject>
    implements InvocationHandler {
        private final T _managedObject;
        final /* synthetic */ VcServiceImpl this$0;

        ManagedObjectHandler(T t) {
            this.this$0 = var1_1;
            this._managedObject = t;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            int n;
            Object object2;
            boolean bl = this.this$0._vmomiClientCounter.increment();
            if (!bl) {
                _logger.info((Object)("Already logged out of VC: " + (String)this.this$0._logoutRecord.get()));
                throw new NotAuthenticatedError();
            }
            boolean bl2 = true;
            if (objectArray != null && objectArray.length > 0 && (object2 = objectArray[(n = objectArray.length) - 1]) instanceof Future) {
                bl2 = false;
                Future future = (Future)object2;
                FutureWrapper futureWrapper = this.this$0.new FutureWrapper(future, this.this$0._vmomiClientCounter, (ManagedObject)this._managedObject, method);
                objectArray = Arrays.copyOf(objectArray, n);
                objectArray[n - 1] = futureWrapper;
            }
            try {
                Object object3;
                object2 = object3 = method.invoke(this._managedObject, objectArray);
                return object2;
            }
            catch (Exception exception) {
                object2 = exception;
                if (exception instanceof InvocationTargetException) {
                    object2 = exception.getCause();
                }
                throw object2;
            }
            finally {
                if (bl2) {
                    this.this$0._vmomiClientCounter.decrement();
                }
            }
        }
    }

    private static class InitialProperties {
        Client _vmomiClient;
        ServiceInstance _serviceInstance;
        ServiceInstanceContent _serviceInstanceContent;
        ServiceEndpointEx[] _endPoints;
        SessionManager _sessionManager;
        String _serviceGuid;
        String _serviceVersion;
        String _errorCode;
        String _vcLocale;

        private InitialProperties() {
        }
    }

    private static class RequestRetryCallbackImpl
    implements RequestRetryCallback {
        private volatile VcServiceImpl _vcService;

        private RequestRetryCallbackImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retry(Exception exception, InvocationContext invocationContext, int n) {
            Object object;
            Object object2;
            if (_logger.isDebugEnabled()) {
                object2 = invocationContext.getMethod();
                object = object2 != null ? object2.getName() : "???";
                _logger.debug((Object)("Will determine whether to retry managed method " + (String)object + " for moref " + invocationContext.getMoRef() + ". The failure was " + exception.getClass().getName() + ": " + exception.getMessage()));
            }
            if (!(exception instanceof NotAuthenticated)) {
                _logger.debug((Object)"Will not retry because of the failure type");
                return false;
            }
            object2 = this._vcService;
            if (object2 == null) {
                return false;
            }
            if (((VcServiceImpl)object2)._notAuthenticatedCb == null) {
                return false;
            }
            object = (Integer)invocationContext.getInvocationContextObject(VcServiceImpl.KEY_LOGIN_COUNT);
            int n2 = object != null ? (Integer)object : Integer.MAX_VALUE;
            Object object3 = ((VcServiceImpl)object2)._lockObject;
            synchronized (object3) {
                int n3 = this._vcService._loginCounter.get();
                if (n3 > n2) {
                    return true;
                }
                AuthenticationState authenticationState = ((VcServiceImpl)object2)._authenticationState;
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("The VC " + this._vcService._serviceUrl + " authentication state is " + (Object)((Object)authenticationState)));
                }
                if (AuthenticationState.LOGGED_OUT.equals((Object)authenticationState)) {
                    return false;
                }
                ((VcServiceImpl)object2).transitionAuthStateIfStateIs(AuthenticationState.NOT_AUTHENTICATED, AuthenticationState.AUTHENTICATED);
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("After the transition, the VC authentication state is: " + (Object)((Object)((VcServiceImpl)object2)._authenticationState)));
                }
            }
            boolean bl = ((VcServiceImpl)object2)._notAuthenticatedCb.retry((VcServiceImpl)object2);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("The NotAuthenticatedCallback returned: " + bl));
            }
            return bl;
        }
    }

    private static enum LoginType {
        REGULAR,
        TICKET;

    }

    public static interface NotAuthenticatedCallback {
        public boolean retry(VcServiceImpl var1);
    }
}

