/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.vcservice.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.vmware.vise.vim.commons.ServiceEndpointType;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class VcServiceRelatedEndpointPredicate
implements Predicate<ServiceEndpointEx> {
    private static final VcService[] EMPTY_VCSERVICE_ARRAY = new VcService[0];
    private final VcService[] _vcServices;

    public VcServiceRelatedEndpointPredicate(VcService ... vcServiceArray) {
        Preconditions.checkArgument((vcServiceArray != null ? 1 : 0) != 0, (Object)"vcServices is null");
        Preconditions.checkArgument((vcServiceArray.length > 0 ? 1 : 0) != 0, (Object)"vcServices is empty");
        this._vcServices = vcServiceArray;
    }

    public VcServiceRelatedEndpointPredicate(@Nonnull Collection<VcService> collection) {
        Preconditions.checkArgument((collection != null ? 1 : 0) != 0, (Object)"vcServices is null");
        Preconditions.checkArgument((collection.size() > 0 ? 1 : 0) != 0, (Object)"vcServices is empty");
        this._vcServices = collection.toArray(EMPTY_VCSERVICE_ARRAY);
    }

    public boolean apply(@Nullable ServiceEndpointEx serviceEndpointEx) {
        if (serviceEndpointEx == null) {
            return false;
        }
        ServiceEndpointType serviceEndpointType = serviceEndpointEx.getServiceEndpointType();
        for (VcService vcService : this._vcServices) {
            String string = vcService.getServiceGuid();
            if (string == null) continue;
            if (serviceEndpointType == ServiceEndpointType.VC && string.equals(serviceEndpointEx.getInstanceUuid())) {
                return true;
            }
            if (serviceEndpointType != ServiceEndpointType.IS || !string.equals(serviceEndpointEx.getVcGuid())) continue;
            return true;
        }
        return false;
    }
}

