/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.chassisRackVSphere;

import com.vmware.samples.chassisRackVSphere.ChassisService;
import com.vmware.samples.chassisRackVSphere.ModelObjectUriResolver;
import com.vmware.samples.chassisRackVSphere.ObjectStore;
import com.vmware.samples.chassisRackVSphere.model.Chassis;
import com.vmware.samples.chassisRackVSphere.model.ChassisInfo;
import com.vmware.samples.chassisRackVSphere.model.ModelObject;
import com.vmware.samples.chassisRackVSphere.model.Rack;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChassisServiceImpl
implements ChassisService {
    private static final Log _logger = LogFactory.getLog(ChassisServiceImpl.class);
    private final ModelObjectUriResolver _uriResolver;
    private final ObjectStore _objectStore;

    public ChassisServiceImpl(ModelObjectUriResolver modelObjectUriResolver, ObjectStore objectStore) {
        this._uriResolver = modelObjectUriResolver;
        this._objectStore = objectStore;
    }

    @Override
    public URI createChassis(ChassisInfo chassisInfo, URI uRI) {
        Object object;
        Rack rack = null;
        if (uRI != null && (rack = this._objectStore.getRack((String)(object = this._uriResolver.getUid(uRI)))) == null) {
            throw new IllegalArgumentException("Rack not found during create chassis operation: " + (String)object);
        }
        object = this._objectStore.createChassis(chassisInfo, rack, true);
        if (object == null) {
            _logger.info((Object)("Chassis not created because this name is taken: " + chassisInfo.name));
            return null;
        }
        _logger.info((Object)("Chassis created: " + object.toString()));
        return ((ModelObject)object).getUri(this._uriResolver);
    }

    @Override
    public boolean editChassis(URI uRI) {
        String string = this._uriResolver.getUid(uRI);
        Chassis chassis = this._objectStore.getChassis(string);
        if (chassis == null) {
            _logger.info((Object)("Chassis not found during edit operation: " + string));
            return false;
        }
        ChassisInfo chassisInfo = new ChassisInfo(new String[]{chassis.getName(), chassis.getServerType() + "_X", chassis.getDimensions()});
        return this._objectStore.replaceChassis(string, chassisInfo);
    }

    @Override
    public boolean deleteChassis(URI uRI) {
        String string = this._uriResolver.getUid(uRI);
        Chassis chassis = this._objectStore.removeChassis(string);
        if (chassis == null) {
            _logger.info((Object)("Chassis not found during delete operation: " + string));
            return false;
        }
        return true;
    }

    @Override
    public boolean addHost(Object object, URI uRI) {
        String string = this._uriResolver.getUid(uRI);
        return this._objectStore.addHostToChassis(object, string);
    }
}

