/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.bindings.type;

import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.bindings.type.TypeVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;

public class IdType
implements Type {
    private String resourceType;
    private List<String> resourceTypes;
    private String resourceTypeFieldName;

    public IdType(String resourceType) {
        Validate.notNull((Object)resourceType, (String)"resourceType must not be null");
        this.resourceType = resourceType;
    }

    public IdType(String[] resourceTypes, String resourceTypeFieldName) {
        Validate.isTrue((resourceTypes != null && resourceTypes.length != 0 || resourceTypeFieldName != null ? 1 : 0) != 0, (String)"IdType requires either resource types or resource type holder field specified.");
        if (resourceTypes != null) {
            this.resourceTypes = Collections.unmodifiableList(Arrays.asList(resourceTypes));
        }
        this.resourceTypeFieldName = resourceTypeFieldName;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public List<String> getResourceTypes() {
        return this.resourceTypes;
    }

    public String getResourceTypeFieldName() {
        return this.resourceTypeFieldName;
    }
}

