/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.data;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.data.BooleanValue;
import com.vmware.vapi.data.DataType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DoubleValue;
import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.SecretValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.ValueVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class ListValue
implements DataValue,
Iterable<DataValue> {
    private static final long serialVersionUID = 1L;
    private final List<DataValue> list = new LinkedList<DataValue>();

    @Override
    public DataType getType() {
        return DataType.LIST;
    }

    public void add(DataValue value) {
        this.list.add(value);
    }

    public void addAll(Collection<? extends DataValue> c) {
        this.list.addAll(c);
    }

    public boolean equals(Object o) {
        if (o instanceof ListValue) {
            ListValue otherList = (ListValue)o;
            return this.list.equals(otherList.list);
        }
        return false;
    }

    public DataValue get(int index) {
        return this.list.get(index);
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<DataValue> iterator() {
        return Collections.unmodifiableList(this.list).iterator();
    }

    public int size() {
        return this.list.size();
    }

    public String toString() {
        return this.list.toString();
    }

    public List<DataValue> getList() {
        return Collections.unmodifiableList(this.list);
    }

    public List<Long> getIntegerList() {
        LinkedList<Long> intList = new LinkedList<Long>();
        for (DataValue dv : this.list) {
            if (dv instanceof OptionalValue) {
                intList.add(((OptionalValue)dv).getIntegerOrNull());
                continue;
            }
            if (dv instanceof IntegerValue) {
                intList.add(((IntegerValue)dv).getValue());
                continue;
            }
            throw new CoreException("vapi.data.list.get.mismatch", "Integer", dv.getType().toString());
        }
        return intList;
    }

    public List<Double> getDoubleList() {
        LinkedList<Double> dblList = new LinkedList<Double>();
        for (DataValue dv : this.list) {
            if (dv instanceof OptionalValue) {
                dblList.add(((OptionalValue)dv).getDoubleOrNull());
                continue;
            }
            if (dv instanceof DoubleValue) {
                dblList.add(((DoubleValue)dv).getValue());
                continue;
            }
            throw new CoreException("vapi.data.list.get.mismatch", "Double", dv.getType().toString());
        }
        return dblList;
    }

    public List<Boolean> getBooleanList() {
        LinkedList<Boolean> boolList = new LinkedList<Boolean>();
        for (DataValue dv : this.list) {
            if (dv instanceof OptionalValue) {
                boolList.add(((OptionalValue)dv).getBooleanOrNull());
                continue;
            }
            if (dv instanceof BooleanValue) {
                boolList.add(((BooleanValue)dv).getValue());
                continue;
            }
            throw new CoreException("vapi.data.list.get.mismatch", "Boolean", dv.getType().toString());
        }
        return boolList;
    }

    public List<String> getStringList() {
        LinkedList<String> strList = new LinkedList<String>();
        for (DataValue dv : this.list) {
            if (dv instanceof OptionalValue) {
                strList.add(((OptionalValue)dv).getStringOrNull());
                continue;
            }
            if (dv instanceof StringValue) {
                strList.add(((StringValue)dv).getValue());
                continue;
            }
            throw new CoreException("vapi.data.list.get.mismatch", "String", dv.getType().toString());
        }
        return strList;
    }

    public List<char[]> getSecretList() {
        LinkedList<char[]> secretList = new LinkedList<char[]>();
        for (DataValue dv : this.list) {
            if (dv instanceof OptionalValue) {
                secretList.add(((OptionalValue)dv).getSecretOrNull());
                continue;
            }
            if (dv instanceof SecretValue) {
                secretList.add(((SecretValue)dv).getValue());
                continue;
            }
            throw new CoreException("vapi.data.list.get.mismatch", "Secret", dv.getType().toString());
        }
        return secretList;
    }

    public static ListValue integerList(List<Long> intList) {
        ListValue listValue = new ListValue();
        for (Long val : intList) {
            listValue.add(new IntegerValue(val));
        }
        return listValue;
    }

    public static ListValue doubleList(List<Double> dblList) {
        ListValue listValue = new ListValue();
        for (Double val : dblList) {
            listValue.add(new DoubleValue(val));
        }
        return listValue;
    }

    public static ListValue booleanList(List<Boolean> boolList) {
        ListValue listValue = new ListValue();
        for (Boolean val : boolList) {
            listValue.add(BooleanValue.getInstance(val));
        }
        return listValue;
    }

    public static ListValue stringList(List<String> strList) {
        ListValue listValue = new ListValue();
        for (String val : strList) {
            listValue.add(new StringValue(val));
        }
        return listValue;
    }

    public static ListValue secretList(List<char[]> secretList) {
        ListValue listValue = new ListValue();
        for (char[] val : secretList) {
            listValue.add(new SecretValue(val));
        }
        return listValue;
    }

    public static ListValue optionalIntegerList(List<Long> intList) {
        ListValue listValue = new ListValue();
        for (Long val : intList) {
            listValue.add(new OptionalValue(val));
        }
        return listValue;
    }

    public static ListValue optionalDoubleList(List<Double> dblList) {
        ListValue listValue = new ListValue();
        for (Double val : dblList) {
            listValue.add(new OptionalValue(val));
        }
        return listValue;
    }

    public static ListValue optionalBooleanList(List<Boolean> boolList) {
        ListValue listValue = new ListValue();
        for (Boolean val : boolList) {
            listValue.add(new OptionalValue(val));
        }
        return listValue;
    }

    public static ListValue optionalStringList(List<String> strList) {
        ListValue listValue = new ListValue();
        for (String val : strList) {
            listValue.add(new OptionalValue(val));
        }
        return listValue;
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ListValue copy() {
        ListValue result = new ListValue();
        for (DataValue element : this.list) {
            result.add(element.copy());
        }
        return result;
    }
}

