/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.internal.bindings.convert.NameToTypeResolver;
import com.vmware.vapi.util.StructTypeUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class MapBasedNameToTypeResolver
implements NameToTypeResolver {
    public static final Map<String, StructType> STANDARD_ERRORS;
    private final Map<String, StructType> typeMap;

    public MapBasedNameToTypeResolver(Map<String, StructType> typeMap) {
        Validate.notNull(typeMap);
        Validate.noNullElements(typeMap.keySet());
        Validate.noNullElements(typeMap.values());
        this.typeMap = Collections.unmodifiableMap(typeMap);
    }

    @Override
    public Type resolve(String name) {
        Validate.notEmpty((String)name);
        return this.typeMap.get(name);
    }

    static {
        HashMap<String, StructType> typeMap = new HashMap<String, StructType>();
        StructTypeUtil.populateCanonicalNameToStructTypeMap(typeMap);
        HashMap errorMap = new HashMap();
        for (Map.Entry e : typeMap.entrySet()) {
            if (!((String)e.getKey()).startsWith("com.vmware.vapi.std.errors")) continue;
            errorMap.put(e.getKey(), e.getValue());
        }
        STANDARD_ERRORS = Collections.unmodifiableMap(errorMap);
    }
}

