/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.common;

import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.core.abort.AbortListener;
import com.vmware.vapi.internal.core.abort.RequestAbortedException;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient;
import org.apache.commons.lang.Validate;
import org.apache.http.client.methods.HttpPost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static Logger logger = LoggerFactory.getLogger(Util.class);

    public static boolean checkRequestAborted(AbortHandle abortHandle, CorrelatingClient.ResponseCallback cb) {
        if (abortHandle != null && abortHandle.isAborted()) {
            cb.failed(new RequestAbortedException("Request aborted, aborting execution."));
            return true;
        }
        return false;
    }

    public static void registerAbortListerner(final CorrelatingClient.ResponseCallback cb, final HttpPost post, AbortHandle abortHandle) {
        Validate.notNull((Object)cb);
        Validate.notNull((Object)post);
        if (abortHandle == null) {
            return;
        }
        abortHandle.addAbortListener(new AbortListener(){

            @Override
            public void onAbort() {
                if (logger.isDebugEnabled()) {
                    logger.debug("Request aborted, aborting HTTP post execution.");
                }
                cb.failed(new RequestAbortedException("Http request aborted."));
                post.abort();
            }
        });
    }
}

