/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.provider.introspection;

import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.DecoratorApiProvider;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorDefinition;
import com.vmware.vapi.internal.provider.introspection.IntrospectionDataFactory;
import com.vmware.vapi.util.async.DecoratorAsyncHandle;
import java.util.Set;
import org.apache.commons.lang.Validate;

public final class ErrorAugmentingFilter
extends DecoratorApiProvider {
    private final Iterable<DataValue> extraErrors;

    public ErrorAugmentingFilter(ApiProvider decoratedProvider, Set<ErrorDefinition> extraErrors) {
        super(decoratedProvider);
        Validate.notNull(extraErrors);
        this.extraErrors = IntrospectionDataFactory.toDataDefinitionList(extraErrors);
    }

    @Override
    public void invoke(String serviceId, String operationId, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle) {
        MethodIdentifier method = new MethodIdentifier(new InterfaceIdentifier(serviceId), operationId);
        if (IntrospectionDataFactory.OPERATION_GET_METHOD_ID.equals(method)) {
            asyncHandle = new DecoratorAsyncHandle<MethodResult>(asyncHandle){

                @Override
                public void setResult(MethodResult result) {
                    if (result.success()) {
                        try {
                            IntrospectionDataFactory.addErrorsToOperationInfo(result.getOutput(), ErrorAugmentingFilter.this.extraErrors);
                        }
                        catch (RuntimeException ex) {
                            this.decorated.setError(ex);
                            return;
                        }
                    }
                    this.decorated.setResult(result);
                }
            };
        }
        this.decoratedProvider.invoke(serviceId, operationId, input, ctx, (AsyncHandle<MethodResult>)asyncHandle);
    }
}

