/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.security;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public interface AuthenticationConfig {
    public Map<String, List<AuthnScheme>> getPackageAuthenticationRules();

    public Map<String, List<AuthnScheme>> getIFaceAuthenticationRules();

    public Map<String, List<AuthnScheme>> getOperationAuthenticationRules();

    public static final class AuthnScheme {
        private static final AuthnScheme NO_AUTHN_SCHEME = new AuthnScheme(Collections.singletonList("com.vmware.vapi.std.security.no_authentication"));
        private final List<String> authnSchemeList;

        public AuthnScheme(List<String> authnSchemeList) {
            Validate.notNull(authnSchemeList);
            Validate.notEmpty(authnSchemeList);
            Validate.noNullElements(authnSchemeList);
            this.authnSchemeList = Collections.unmodifiableList(authnSchemeList);
        }

        public boolean isAllowed(AuthnScheme userScheme) {
            Validate.notNull((Object)userScheme);
            for (String schemeId : this.authnSchemeList) {
                for (String userSchemeId : userScheme.authnSchemeList) {
                    if (!schemeId.equalsIgnoreCase(userSchemeId)) continue;
                    return true;
                }
            }
            return false;
        }

        public static AuthnScheme getNoAuthenticationScheme() {
            return NO_AUTHN_SCHEME;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("AuthenticationScheme[");
            for (String scheme : this.authnSchemeList) {
                sb.append(scheme).append(", ");
            }
            sb.delete(sb.length() - 2, sb.length());
            sb.append("]");
            return sb.toString();
        }

        public int hashCode() {
            return this.authnSchemeList.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AuthnScheme other = (AuthnScheme)obj;
            return this.authnSchemeList.equals(other.authnSchemeList);
        }
    }
}

