/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw;

import com.vmware.vise.extensionfw.BundleInfo;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BundlePackageInfo {
    private static final Log _logger = LogFactory.getLog(BundlePackageInfo.class);
    private static final String EXPORT_PACKAGE = "Export-Package";
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private Set<String> _exportPackages;
    private Set<String> _importPackages;
    private String _bundleSymbolicName;

    public BundlePackageInfo(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        if (attributes == null) {
            return;
        }
        this._bundleSymbolicName = attributes.getValue(BUNDLE_SYMBOLIC_NAME);
        this._exportPackages = this.extractPackages(attributes.getValue(EXPORT_PACKAGE));
    }

    public BundlePackageInfo(BundleInfo bundleInfo) {
        this._bundleSymbolicName = bundleInfo.getId();
        this._exportPackages = this.extractPackages(bundleInfo.getExportPackage());
        this._importPackages = this.extractPackages(bundleInfo.getImportPackage());
    }

    public Set<String> getExportPackages() {
        return this._exportPackages;
    }

    public Set<String> getImportPackages() {
        return this._importPackages;
    }

    public String getBundleSymbolicName() {
        return this._bundleSymbolicName;
    }

    private Set<String> extractPackages(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (string == null) {
            return hashSet;
        }
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        while (n < cArray.length) {
            if (cArray[n] == ',') {
                hashSet.add(this.normalizePackage(stringBuffer.toString()));
                stringBuffer.setLength(0);
                ++n;
                continue;
            }
            if (cArray[n] == ';') {
                int n2 = string.indexOf("\"", n + 1);
                if (n2 == -1) {
                    _logger.error((Object)("Invalid packages list in MANIFEST.MF of bundle: " + this._bundleSymbolicName + "\n" + string));
                    stringBuffer.setLength(0);
                    break;
                }
                int n3 = string.indexOf("\"", n2 + 1);
                if (n3 == -1) {
                    _logger.error((Object)("Invalid packages list in MANIFEST.MF of bundle: " + this._bundleSymbolicName + "\n" + string));
                    stringBuffer.setLength(0);
                    break;
                }
                n = n3 + 1;
                continue;
            }
            stringBuffer.append(cArray[n]);
            ++n;
        }
        if (stringBuffer.length() > 0) {
            hashSet.add(this.normalizePackage(stringBuffer.toString()));
        }
        return hashSet;
    }

    private String normalizePackage(String string) {
        return string.replace(" ", "").replace("\n", "");
    }
}

