/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw;

import com.vmware.vise.extensionfw.DeploymentUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeploymentFilter
implements Filter {
    private static final Log _logger = LogFactory.getLog(DeploymentFilter.class);
    private static final String NOT_FOUND_PAGE_PATH = "/notfound.jsp";
    private boolean _allPackagesDeployed = false;
    private List<Pattern> _excludeUrls;
    private String _contextPath;

    public void init(FilterConfig filterConfig) throws ServletException {
        _logger.info((Object)"initialized");
        this._excludeUrls = DeploymentFilter.getExcludeUrls(filterConfig);
        this._contextPath = filterConfig.getServletContext().getContextPath();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this._allPackagesDeployed || this.matchExcludeUrls(servletRequest)) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            String string = ((HttpServletRequest)servletRequest).getRequestURI();
            if (DeploymentUtil.allPackagesDeployed()) {
                this._allPackagesDeployed = true;
                filterChain.doFilter(servletRequest, servletResponse);
            } else if (!NOT_FOUND_PAGE_PATH.equals(string)) {
                servletRequest.getRequestDispatcher(NOT_FOUND_PAGE_PATH).forward(servletRequest, servletResponse);
            }
        }
    }

    public void destroy() {
    }

    private boolean matchExcludeUrls(ServletRequest servletRequest) {
        if (this._excludeUrls.isEmpty()) {
            return false;
        }
        String string = ((HttpServletRequest)servletRequest).getRequestURI();
        String string2 = string.replaceFirst(this._contextPath, "");
        for (Pattern pattern : this._excludeUrls) {
            if (!pattern.matcher(string2).matches()) continue;
            return true;
        }
        return false;
    }

    private static List<Pattern> getExcludeUrls(FilterConfig filterConfig) {
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        Enumeration enumeration = filterConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith("excludeUrl.") || (string = filterConfig.getInitParameter(string2)) == null) continue;
            arrayList.add(Pattern.compile(string));
        }
        return arrayList;
    }
}

