/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw;

import com.vmware.vise.extensionfw.BundleDeployer;
import com.vmware.vise.extensionfw.BundleInfo;
import com.vmware.vise.extensionfw.BundlePackageInfo;
import com.vmware.vise.extensionfw.CombinedExtensionPointInfo;
import com.vmware.vise.extensionfw.ExtensionFilter;
import com.vmware.vise.extensionfw.ExtensionFilterSpec;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionListener;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.ExtensionPersistenceProvider;
import com.vmware.vise.extensionfw.ExtensionPointInfo;
import com.vmware.vise.extensionfw.IExtensionInfoMetadataParser;
import com.vmware.vise.extensionfw.IExtensionObjectParser;
import com.vmware.vise.extensionfw.PluginInfo;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.extensionfw.PluginPackageSource;
import com.vmware.vise.extensionfw.PluginPackageStateInfo;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.extensionfw.compatibility.CompatibilityStatus;
import com.vmware.vise.extensionfw.compatibility.PluginPackageCompatibilityService;
import com.vmware.vise.extensionfw.impl.BundleInfoLoader;
import com.vmware.vise.extensionfw.impl.ExtensionMetadataParser;
import com.vmware.vise.extensionfw.impl.ExtensionObjectParser;
import com.vmware.vise.extensionfw.impl.ExtensionSorter;
import com.vmware.vise.extensionfw.impl.Filterer;
import com.vmware.vise.extensionfw.impl.OsgiUsageValidationService;
import com.vmware.vise.extensionfw.impl.PackageDeployData;
import com.vmware.vise.extensionfw.impl.PackageManifest;
import com.vmware.vise.extensionfw.impl.PackageManifestParser;
import com.vmware.vise.extensionfw.impl.PackagesDeployer;
import com.vmware.vise.extensionfw.impl.PluginManifest;
import com.vmware.vise.extensionfw.impl.PluginManifestParser;
import com.vmware.vise.extensionfw.impl.TemplateInfo;
import com.vmware.vise.extensionfw.impl.TemplateInstanceInfo;
import com.vmware.vise.extensionfw.impl.TemplateInstantiator;
import com.vmware.vise.extensionfw.impl.TemplateMerger;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.Version;
import com.vmware.vise.util.XMLUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.serialization.ClassDeserializationValidatorHelper;
import com.vmware.vise.util.service.ClassLoaderService;
import com.vmware.vise.util.service.ServiceListener;
import com.vmware.vise.util.service.ServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtensionManager {
    private static final String PLUGIN_PACKAGE_NAME = "pluginPackageName";
    private static final String PLUGIN_PACKAGE_ID = "pluginPackageId";
    private static final String DEPLOYMENT_STATUS_KEY = "deploymentStatus";
    private static final String COMPATIBILITY_STATUS_KEY = "compatibilityStatus";
    public static final String PLUGIN_MANIFEST_NAME = "plugin.xml";
    public static final String PACKAGE_MANIFEST_URI = "plugin-package.xml";
    private static final String LEGACY_PACKAGE_MANIFEST_URI = "pluginPackage.xml";
    private static final String PACKAGE_MANIFEST_LOCAL_URI = "pluginPackage.local.xml";
    private static final String DEFAULT_PLUGIN_PACKAGE_ID = "com.vmware.__defaultPluginPackage__";
    public static final String PLUGINS_URI = "plugins";
    private static final String SERVER_GUIDS = "vcServerGuids";
    private static final String FILTERS_EXTENSION_POINT = "vmware.extension.filters";
    private ClassDeserializationValidatorHelper _classDeserializationValidatorHelper;
    private IExtensionObjectParser _eoParser;
    private IExtensionInfoMetadataParser _eiMetadataParser;
    private boolean _useH5MetadataParser = false;
    private final AtomicReference<Map<String, PropertyInfo>> _filterPropertiesMapRef = new AtomicReference();
    private ServiceRegistry _serviceRegistry;
    private ClassLoaderService _classLoaderService;
    private PluginPackageCompatibilityService _pluginCompatibilityService;
    private ExtensionPersistenceProvider _persistenceProvider;
    private Object _extensionObjectFilterLockObj = new Object();
    private Object _filterLockObj = new Object();
    private Object _listenerLockObj = new Object();
    private Object _pluginSourceLockObj = new Object();
    private List<ExtensionObjectFilter> _extensionObjectFilters;
    private List<ExtensionFilter> _filters;
    private List<ExtensionListener> _listeners;
    private List<PluginPackageSource> _pluginSources;
    private final ConcurrentHashMap<IdVersionPair, PluginInfo> _pluginByRef = new ConcurrentHashMap();
    private final ConcurrentMap<String, ExtensionPointInfo> _pointById = new ConcurrentHashMap<String, ExtensionPointInfo>();
    private final ConcurrentMap<String, ExtensionList> _extensionsByPointId = new ConcurrentHashMap<String, ExtensionList>();
    private final ConcurrentHashMap<Locale, ConcurrentHashMap<String, Object>> _extensionObjectMapByLocale = new ConcurrentHashMap();
    private final ConcurrentMap<String, TemplateInfo> _templateById = new ConcurrentHashMap<String, TemplateInfo>();
    private final ConcurrentMap<IdVersionPair, PackageDeployData> _packageDeployDataByRef = new ConcurrentHashMap<IdVersionPair, PackageDeployData>();
    private List<PluginPackageInfo> _incompatiblePackages = new ArrayList<PluginPackageInfo>();
    private Set<IdVersionPair> _deployedBundlesRefs = Collections.newSetFromMap(new ConcurrentHashMap());
    private OsgiUsageValidationService _usageValidationService;
    private ConcurrentLinkedQueue<PendingTemplateInstanceInfo> _pendingTemplateInstances = new ConcurrentLinkedQueue();
    private static final Log _logger = LogFactory.getLog(ExtensionManager.class);
    private ExecutorService _packageDeployExecutorService;
    private BundleDeployer _bundleDeployer;

    public void setClassDeserializationValidatorHelper(ClassDeserializationValidatorHelper classDeserializationValidatorHelper) {
        this._classDeserializationValidatorHelper = classDeserializationValidatorHelper;
    }

    ExtensionManager() {
    }

    public static ExtensionManager getInstance() {
        return ExtensionManagerHolder._instance;
    }

    public ExecutorService getPackageDeployExecutorService() {
        return this._packageDeployExecutorService;
    }

    public void setPackageDeployExecutorService(ExecutorService executorService) {
        this._packageDeployExecutorService = executorService;
    }

    public BundleDeployer getBundleDeployer() {
        return this._bundleDeployer;
    }

    public void setBundleDeployer(BundleDeployer bundleDeployer) {
        this._bundleDeployer = bundleDeployer;
    }

    public void setExtensionObjectParser(IExtensionObjectParser iExtensionObjectParser) {
        this._eoParser = iExtensionObjectParser;
    }

    public void setExtensionInfoMetadataParser(IExtensionInfoMetadataParser iExtensionInfoMetadataParser) {
        this._eiMetadataParser = iExtensionInfoMetadataParser;
    }

    public boolean getUseH5MetadataParser() {
        return this._useH5MetadataParser;
    }

    public void setUseH5MetadataParser(boolean bl) {
        this._useH5MetadataParser = bl;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this._serviceRegistry = serviceRegistry;
        this.registerServiceListeners();
    }

    public void setClassLoaderService(ClassLoaderService classLoaderService) {
        this._classLoaderService = classLoaderService;
    }

    public void setCompatibilityService(PluginPackageCompatibilityService pluginPackageCompatibilityService) {
        this._pluginCompatibilityService = pluginPackageCompatibilityService;
    }

    private void registerServiceListeners() {
        this._serviceRegistry.registerServiceListener(ExtensionFilter.class.getName(), new ServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceAdded(Object object) {
                Object object2 = ExtensionManager.getInstance()._filterLockObj;
                synchronized (object2) {
                    ExtensionManager.this._filters = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceRemoved(Object object) {
                Object object2 = ExtensionManager.getInstance()._filterLockObj;
                synchronized (object2) {
                    ExtensionManager.this._filters = null;
                }
            }
        });
        this._serviceRegistry.registerServiceListener(ExtensionListener.class.getName(), new ServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceAdded(Object object) {
                Object object2 = ExtensionManager.getInstance()._listenerLockObj;
                synchronized (object2) {
                    ExtensionManager.this._listeners = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceRemoved(Object object) {
                Object object2 = ExtensionManager.getInstance()._listenerLockObj;
                synchronized (object2) {
                    ExtensionManager.this._listeners = null;
                }
            }
        });
        this._serviceRegistry.registerServiceListener(PluginPackageSource.class.getName(), new ServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceAdded(Object object) {
                Object object2 = ExtensionManager.getInstance()._pluginSourceLockObj;
                synchronized (object2) {
                    ExtensionManager.this._pluginSources = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceRemoved(Object object) {
                Object object2 = ExtensionManager.getInstance()._pluginSourceLockObj;
                synchronized (object2) {
                    ExtensionManager.this._pluginSources = null;
                }
            }
        });
        this._serviceRegistry.registerServiceListener(ExtensionObjectFilter.class.getName(), new ServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceAdded(Object object) {
                Object object2 = ExtensionManager.getInstance()._extensionObjectFilterLockObj;
                synchronized (object2) {
                    ExtensionManager.this._extensionObjectFilters = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceRemoved(Object object) {
                Object object2 = ExtensionManager.getInstance()._extensionObjectFilterLockObj;
                synchronized (object2) {
                    ExtensionManager.this._extensionObjectFilters = null;
                }
            }
        });
    }

    public Set<IdVersionPair> deployNewPackages() {
        HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>();
        List<PluginPackageSource> list = this.getPluginSources();
        for (PluginPackageSource pluginPackageSource : list) {
            try {
                Set<IdVersionPair> set = pluginPackageSource.deployNewPackages();
                hashSet.addAll(set);
            }
            catch (Exception exception) {
                _logger.error((Object)"Error deploying plugin packages", (Throwable)exception);
            }
        }
        return hashSet;
    }

    public synchronized Set<IdVersionPair> addPluginPackages(PluginPackageInfo[] pluginPackageInfoArray) {
        IdVersionPair idVersionPair;
        ArrayList<PackageDeployData> arrayList = new ArrayList<PackageDeployData>(pluginPackageInfoArray.length);
        HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>();
        for (PluginPackageInfo pluginPackageInfo : pluginPackageInfoArray) {
            try {
                PackageDeployData packageDeployData = this.getPackageDeployData(pluginPackageInfo, false);
                if (packageDeployData == null) continue;
                idVersionPair = (packageDeployData = this.preAddPluginPackage(packageDeployData)).getPackageRef();
                if (this._packageDeployDataByRef.containsKey(idVersionPair)) {
                    _logger.info((Object)("Plugin package  " + idVersionPair + " is already added in ExtensionManager, skip."));
                    hashSet.add(idVersionPair);
                    continue;
                }
                if (this.isPluginPackageIncompatible(idVersionPair)) {
                    this.rememberPluginPackageAsIncompatible(packageDeployData.getPackageInfo());
                    _logger.warn((Object)("Plugin package " + packageDeployData.getPackageRef() + " not deployed:" + " it is marked incompatible either in your setup's compatibility-matrix.xml" + " or internally in this release."));
                    continue;
                }
                if (this._useH5MetadataParser && !"html".equals(packageDeployData.getManifest().type) && !this.isPluginPackageCompatible(idVersionPair)) {
                    _logger.info((Object)("Plugin package " + packageDeployData.getPackageRef() + " was not deployed because attribute" + " type=\"html\" is missing, which is normal if this is a Flex plugin."));
                    continue;
                }
                this.forgetPluginPackageAsIncompatible(packageDeployData.getPackageInfo());
                arrayList.add(packageDeployData);
            }
            catch (Exception exception) {
                _logger.error((Object)("Error retrieving deployment data for the plugin package at " + pluginPackageInfo.getDirectory()), (Throwable)exception);
            }
        }
        HashSet<IdVersionPair> hashSet2 = new HashSet<IdVersionPair>(this._packageDeployDataByRef.keySet());
        for (PackageDeployData arrayList2 : arrayList) {
            if (arrayList2 == null) continue;
            this._packageDeployDataByRef.put(arrayList2.getPackageRef(), arrayList2);
        }
        Set<IdVersionPair> set = PackagesDeployer.deploy(this._packageDeployExecutorService, this._bundleDeployer, arrayList, hashSet2, this._deployedBundlesRefs);
        ArrayList<PluginPackageInfo> arrayList2 = new ArrayList<PluginPackageInfo>(set.size());
        for (PackageDeployData packageDeployData : arrayList) {
            idVersionPair = packageDeployData.getPackageRef();
            if (!set.contains(idVersionPair)) {
                this._packageDeployDataByRef.remove(idVersionPair);
                continue;
            }
            arrayList2.add(packageDeployData.getPackageInfo());
        }
        PluginPackageInfo[] pluginPackageInfoArray2 = arrayList2.toArray(new PluginPackageInfo[0]);
        this.dispatchPackageEvent("pluginPackageDeployed", pluginPackageInfoArray2);
        set.addAll(hashSet);
        this._usageValidationService.validate(arrayList, this._packageDeployDataByRef.values());
        return set;
    }

    public synchronized void addDeployedPluginPackage(PluginPackageInfo pluginPackageInfo) {
        try {
            PackageDeployData packageDeployData = this.getPackageDeployData(pluginPackageInfo, true);
            if (packageDeployData == null) {
                _logger.warn((Object)("PackageDeployData is null for plugin package  - " + pluginPackageInfo.getDirectory()));
                return;
            }
            this._packageDeployDataByRef.put(packageDeployData.getPackageRef(), packageDeployData);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error adding deployed plugin package " + pluginPackageInfo.getDirectory()), (Throwable)exception);
        }
    }

    public void updateExtensionObject(String string, Callable<String> callable) throws Exception {
        if (string == null || callable == null) {
            return;
        }
        ExtensionInfo extensionInfo = this.getExtensionInfo(string);
        String string2 = callable.call();
        if (!this.isValidXml(string2)) {
            throw new RuntimeException("Malformed XML error");
        }
        extensionInfo.setObjectXmlStr(string2);
    }

    private boolean isValidXml(String string) {
        return XMLUtil.parseXml((String)string) != null;
    }

    public void bundleStarted(BundleInfo bundleInfo, URL uRL) throws IOException {
        List<IdVersionPair> list;
        boolean bl = false;
        IdVersionPair idVersionPair = bundleInfo.getBundleRef();
        if (this._deployedBundlesRefs.add(idVersionPair)) {
            if (uRL == null) {
                list = new BundlePackageInfo(bundleInfo);
                if (this._classDeserializationValidatorHelper != null) {
                    this._classDeserializationValidatorHelper.addAllowClassPatterns(((BundlePackageInfo)((Object)list)).getExportPackages());
                }
            } else {
                bl = true;
            }
        }
        if (uRL == null || bundleInfo.getContextPath() == null) {
            return;
        }
        list = this.getPackageRefsContainingBundle(bundleInfo.getBundleRef());
        if (list.size() > 1) {
            _logger.error((Object)("The extensions in the bundle " + bundleInfo.getBundleRef() + " will not be processed because it is contained in multiple" + " plugin packages (" + list + ")"));
            return;
        }
        IdVersionPair idVersionPair2 = !list.isEmpty() ? (IdVersionPair)list.get(0) : null;
        boolean bl2 = this.addPlugin(uRL, bundleInfo, idVersionPair2, null);
        if (bl2 && bl) {
            PluginPackageInfo pluginPackageInfo = new PluginPackageInfo(bundleInfo.getLocation());
            pluginPackageInfo.setId(bundleInfo.getId());
            pluginPackageInfo.setVersion(bundleInfo.getVersion());
            pluginPackageInfo.setName(bundleInfo.getId());
            this.dispatchPackageEvent("pluginPackageDeployed", new PluginPackageInfo[]{pluginPackageInfo});
        }
    }

    public synchronized void bundleStopped(BundleInfo bundleInfo) {
        Object object;
        this._deployedBundlesRefs.remove(bundleInfo.getBundleRef());
        this._classLoaderService.expireCache();
        this._extensionObjectMapByLocale.clear();
        if (bundleInfo.getContextPath() == null) {
            return;
        }
        PluginInfo pluginInfo = this.getPluginInfoByContextPath(bundleInfo.getContextPath());
        if (pluginInfo == null) {
            return;
        }
        IdVersionPair idVersionPair = pluginInfo.getPluginRef();
        PluginInfo pluginInfo2 = this._pluginByRef.remove(idVersionPair);
        if (pluginInfo2 == null) {
            return;
        }
        Object object2 = this._pointById.entrySet().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!((ExtensionPointInfo)object.getValue()).getPluginRef().equals((Object)idVersionPair)) continue;
            object2.remove();
        }
        object2 = new ArrayList();
        for (Map.Entry entry : this._extensionsByPointId.values()) {
            object2.addAll(((ExtensionList)((Object)entry)).removeByPluginRef(idVersionPair));
        }
        object = this._templateById.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry;
            entry = object.next();
            if (!((TemplateInfo)entry.getValue()).getPluginRef().equals((Object)idVersionPair)) continue;
            object.remove();
        }
    }

    public ExtensionPointInfo getExtensionPointInfo(String string) {
        return (ExtensionPointInfo)this._pointById.get(string);
    }

    public CombinedExtensionPointInfo[] getAllCombinedExtensionPointInfos() {
        long l = System.currentTimeMillis();
        _logger.info((Object)"Start getAllCombinedExtensionPointInfos");
        this.getExtensionInfos(FILTERS_EXTENSION_POINT, false);
        ArrayList<CombinedExtensionPointInfo> arrayList = new ArrayList<CombinedExtensionPointInfo>(this._pointById.size());
        for (Map.Entry entry : this._pointById.entrySet()) {
            CombinedExtensionPointInfo combinedExtensionPointInfo = new CombinedExtensionPointInfo();
            combinedExtensionPointInfo.setPoint((ExtensionPointInfo)entry.getValue());
            ExtensionInfo[] extensionInfoArray = this.getExtensionInfos((String)entry.getKey(), false);
            combinedExtensionPointInfo.setExtensions(extensionInfoArray);
            arrayList.add(combinedExtensionPointInfo);
        }
        long l2 = System.currentTimeMillis() - l;
        _logger.info((Object)String.format("End getAllCombinedExtensionPointInfos, elapsed time (ms): %d ", l2));
        return arrayList.toArray(new CombinedExtensionPointInfo[0]);
    }

    public ExtensionInfo[] getExtensionInfos(String string) {
        return this.getExtensionInfos(string, true);
    }

    private ExtensionInfo[] getExtensionInfos(String string, boolean bl) {
        Map<String, PropertyInfo> map;
        Object object;
        if (bl) {
            this.getExtensionInfos(FILTERS_EXTENSION_POINT, false);
        }
        Set<IdVersionPair> set = this.getRelevantPackagesRefs();
        ExtensionList extensionList = (ExtensionList)this._extensionsByPointId.get(string);
        if (extensionList == null) {
            return new ExtensionInfo[0];
        }
        if (extensionList.sort()) {
            if (this._eoParser != null) {
                this._eoParser.parse((ExtensionPointInfo)this._pointById.get(string), extensionList);
            }
            if (this._eiMetadataParser != null && !this._useH5MetadataParser) {
                object = this._filterPropertiesMapRef.get();
                if (FILTERS_EXTENSION_POINT.equals(string)) {
                    map = this.getFilterProperties(extensionList);
                    this._filterPropertiesMapRef.compareAndSet((Map<String, PropertyInfo>)object, map);
                } else {
                    this._eiMetadataParser.parse(extensionList, (Map<String, PropertyInfo>)object);
                }
            }
        }
        object = new ArrayList();
        for (Object object2 : extensionList) {
            if (!this.isRelevantExtension((ExtensionInfo)object2, set)) continue;
            object.add(object2);
        }
        if (this._useH5MetadataParser) {
            Object object2;
            map = this.getExtensionObjectFilters();
            object2 = this.getFilterPropertiesFromFilters((List<ExtensionObjectFilter>)((Object)map));
            ExtensionInfo[] extensionInfoArray = object.toArray(new ExtensionInfo[object.size()]);
            ExtensionMetadataParser.parse(this._classLoaderService, extensionInfoArray, (Map<String, PropertyInfo>)object2);
            return extensionInfoArray;
        }
        return object.toArray(new ExtensionInfo[object.size()]);
    }

    public ExtensionInfo getExtensionInfo(String string) {
        ExtensionInfo extensionInfo = this.findExtensionInfo(string);
        if (extensionInfo == null) {
            return null;
        }
        Set<IdVersionPair> set = this.getRelevantPackagesRefs();
        if (!this.isRelevantExtension(extensionInfo, set)) {
            return null;
        }
        return extensionInfo;
    }

    public PluginInfo getPluginInfo(IdVersionPair idVersionPair) {
        return this._pluginByRef.get(idVersionPair);
    }

    public PluginInfo[] getPluginInfos() {
        Set<IdVersionPair> set = this.getRelevantPackagesRefs();
        ArrayList<PluginInfo> arrayList = new ArrayList<PluginInfo>(this._pluginByRef.size());
        for (PluginInfo pluginInfo : this._pluginByRef.values()) {
            IdVersionPair idVersionPair = pluginInfo.getPackageRef();
            if (idVersionPair != null && !set.contains(idVersionPair)) continue;
            arrayList.add(pluginInfo);
        }
        return arrayList.toArray(new PluginInfo[0]);
    }

    public PluginPackageInfo getPluginPackageInfo(IdVersionPair idVersionPair) {
        PackageDeployData packageDeployData = (PackageDeployData)this._packageDeployDataByRef.get(idVersionPair);
        if (packageDeployData == null) {
            return null;
        }
        return packageDeployData.getPackageInfo();
    }

    public PluginPackageInfo[] getPluginPackageInfos() throws Exception {
        Set<IdVersionPair> set = this.getRelevantPackagesRefs();
        ArrayList<PluginPackageInfo> arrayList = new ArrayList<PluginPackageInfo>(set.size());
        for (PackageDeployData packageDeployData : this._packageDeployDataByRef.values()) {
            if (!set.contains(packageDeployData.getPackageRef())) continue;
            arrayList.add(packageDeployData.getPackageInfo());
        }
        return arrayList.toArray(new PluginPackageInfo[0]);
    }

    public PluginPackageInfo[] getAllPluginPackageInfos() throws Exception {
        ArrayList<PluginPackageInfo> arrayList = new ArrayList<PluginPackageInfo>(this._packageDeployDataByRef.size());
        for (PackageDeployData packageDeployData : this._packageDeployDataByRef.values()) {
            arrayList.add(packageDeployData.getPackageInfo());
        }
        return arrayList.toArray(new PluginPackageInfo[0]);
    }

    public PluginPackageInfo[] getAllKnownPluginPackageInfos() throws Exception {
        PluginPackageStateInfo[] pluginPackageStateInfoArray = this.getPackageStates();
        ArrayList<PluginPackageInfo> arrayList = new ArrayList<PluginPackageInfo>(this._deployedBundlesRefs.size() + this._incompatiblePackages.size());
        for (PackageDeployData object : this._packageDeployDataByRef.values()) {
            PluginPackageInfo pluginPackageInfo = object.getPackageInfo();
            if (this.isPackageStateEnabled(pluginPackageStateInfoArray, object.getPackageRef())) {
                pluginPackageInfo.getMetadata().put(DEPLOYMENT_STATUS_KEY, DeploymentStatus.deployedAndEnabled.name());
            } else {
                pluginPackageInfo.getMetadata().put(DEPLOYMENT_STATUS_KEY, DeploymentStatus.deployedAndDisabled.name());
            }
            pluginPackageInfo.getMetadata().put(COMPATIBILITY_STATUS_KEY, CompatibilityStatus.unknown.name());
            arrayList.add(pluginPackageInfo);
        }
        for (PluginPackageInfo pluginPackageInfo : this._incompatiblePackages) {
            pluginPackageInfo.getMetadata().put(DEPLOYMENT_STATUS_KEY, DeploymentStatus.undeployed.name());
            pluginPackageInfo.getMetadata().put(COMPATIBILITY_STATUS_KEY, CompatibilityStatus.incompatible.name());
            arrayList.add(pluginPackageInfo);
        }
        return arrayList.toArray(new PluginPackageInfo[arrayList.size()]);
    }

    private boolean isPackageStateEnabled(PluginPackageStateInfo[] pluginPackageStateInfoArray, IdVersionPair idVersionPair) {
        if (pluginPackageStateInfoArray == null || pluginPackageStateInfoArray.length == 0) {
            return true;
        }
        for (PluginPackageStateInfo pluginPackageStateInfo : pluginPackageStateInfoArray) {
            if (!idVersionPair.equals((Object)pluginPackageStateInfo.getPackageRef())) continue;
            return pluginPackageStateInfo.getState();
        }
        return true;
    }

    public PluginPackageInfo[] getDisabledPluginPackageInfos() throws Exception {
        PluginPackageStateInfo[] pluginPackageStateInfoArray = this.getPackageStates();
        if (pluginPackageStateInfoArray == null) {
            return new PluginPackageInfo[0];
        }
        ArrayList<PluginPackageInfo> arrayList = new ArrayList<PluginPackageInfo>();
        for (PluginPackageStateInfo pluginPackageStateInfo : pluginPackageStateInfoArray) {
            boolean bl = pluginPackageStateInfo.getState();
            if (bl) continue;
            PackageDeployData packageDeployData = (PackageDeployData)this._packageDeployDataByRef.get(pluginPackageStateInfo.getPackageRef());
            arrayList.add(packageDeployData.getPackageInfo());
        }
        return arrayList.toArray(new PluginPackageInfo[0]);
    }

    public void setPackageStates(PluginPackageStateInfo[] pluginPackageStateInfoArray) throws Exception {
        ExtensionPersistenceProvider extensionPersistenceProvider = this.getPersistenceProvider();
        if (extensionPersistenceProvider != null) {
            extensionPersistenceProvider.setPackageStates(pluginPackageStateInfoArray);
        }
    }

    public ExtensionInfo[][] getExtensionHosts(String string) throws Exception {
        ExtensionInfo extensionInfo = this.findExtensionInfo(string);
        if (extensionInfo == null) {
            throw new Exception("Invalid extension id: " + string);
        }
        List<ExtensionInfo[]> list = this.getExtensionPaths(extensionInfo);
        return (ExtensionInfo[][])list.toArray((T[])new ExtensionInfo[0][]);
    }

    private List<ExtensionInfo[]> getExtensionPaths(ExtensionInfo extensionInfo) throws Exception {
        String[] stringArray;
        ArrayList<ExtensionInfo[]> arrayList = new ArrayList<ExtensionInfo[]>();
        for (String string : stringArray = extensionInfo.getExtendedPointIds()) {
            ExtensionInfo[] extensionInfoArray;
            IdVersionPair idVersionPair = extensionInfo.getPluginRef();
            ExtensionInfo extensionInfo2 = this.getExtensionInfoByHostedPointId(string, idVersionPair, this.getPluginInfo(idVersionPair).getPackageRef());
            if (extensionInfo2 == null) {
                extensionInfoArray = new ExtensionInfo[]{extensionInfo};
                arrayList.add(extensionInfoArray);
                continue;
            }
            extensionInfoArray = this.getExtensionPaths(extensionInfo2);
            for (ExtensionInfo[] extensionInfoArray2 : extensionInfoArray) {
                ExtensionInfo[] extensionInfoArray3 = Arrays.copyOf(extensionInfoArray2, extensionInfoArray2.length + 1);
                extensionInfoArray3[extensionInfoArray2.length] = extensionInfo;
                arrayList.add(extensionInfoArray3);
            }
        }
        return arrayList;
    }

    private Map<String, PropertyInfo> getFilterProperties(Iterable<ExtensionInfo> iterable) {
        HashMap<String, PropertyInfo> hashMap = new HashMap<String, PropertyInfo>();
        for (ExtensionInfo extensionInfo : iterable) {
            if (extensionInfo.object == null || !(extensionInfo.object instanceof ExtensionFilterSpec)) continue;
            ExtensionFilterSpec extensionFilterSpec = (ExtensionFilterSpec)extensionInfo.object;
            if (extensionFilterSpec.filterProperties == null) continue;
            for (PropertyInfo propertyInfo : extensionFilterSpec.filterProperties) {
                hashMap.put(propertyInfo.name, propertyInfo);
            }
        }
        return hashMap;
    }

    private PluginPackageStateInfo[] getPackageStates() {
        try {
            ExtensionPersistenceProvider extensionPersistenceProvider = this.getPersistenceProvider();
            if (extensionPersistenceProvider != null) {
                return extensionPersistenceProvider.getPackageStates();
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when getting package states", (Throwable)exception);
        }
        return null;
    }

    private ExtensionPersistenceProvider getPersistenceProvider() {
        if (this._persistenceProvider != null) {
            return this._persistenceProvider;
        }
        try {
            List list = this._serviceRegistry.getServices(ExtensionPersistenceProvider.class.getName());
            if (list != null && list.size() > 0) {
                this._persistenceProvider = (ExtensionPersistenceProvider)list.get(0);
                return this._persistenceProvider;
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when getting persistence provider", (Throwable)exception);
        }
        return null;
    }

    public boolean addPlugin(URL uRL, BundleInfo bundleInfo, IdVersionPair idVersionPair, String string) throws IOException {
        String string2;
        Map<String, String> map;
        String string3;
        PluginManifestParser pluginManifestParser = new PluginManifestParser(this._useH5MetadataParser);
        String string4 = bundleInfo != null ? bundleInfo.getId() : null;
        PluginManifest pluginManifest = pluginManifestParser.getPluginManifest(uRL, string4, string3 = idVersionPair != null ? idVersionPair.getVersion() : null, map = this.computeExtraExtensionInfoMetadata(string2 = idVersionPair != null ? idVersionPair.getId() : null, string4));
        if (pluginManifest == null) {
            return false;
        }
        IdVersionPair idVersionPair2 = new IdVersionPair(pluginManifest.pluginId, string3);
        PluginInfo pluginInfo = new PluginInfo();
        String string5 = bundleInfo != null ? bundleInfo.getContextPath() : string;
        pluginInfo.setId(pluginManifest.pluginId);
        pluginInfo.setType(pluginManifest.pluginType);
        pluginInfo.setManifestURL(uRL);
        pluginInfo.setVersion(string3);
        pluginInfo.setContextPath(string5);
        pluginInfo.setSecurityPolicyURI(pluginManifest.securityPolicyURI);
        pluginInfo.setModuleURI(pluginManifest.moduleURI);
        pluginInfo.setDependencies(pluginManifest.dependencies);
        pluginInfo.setResourceXml(pluginManifest.resourceXml);
        pluginInfo.setDefaultBundle(pluginManifest.defaultBundle);
        pluginInfo.setExportedClasses(pluginManifest.exportedClasses.toArray(new String[0]));
        pluginInfo.setMetadata(pluginManifest.metadata);
        pluginInfo.setPackageRef(idVersionPair);
        pluginInfo = this._pluginByRef.putIfAbsent(idVersionPair2, pluginInfo);
        if (pluginInfo != null) {
            throw new IOException("Plugin " + idVersionPair2 + " is already added in ExtensionManager.");
        }
        this.addExtensionPoints(pluginManifest.extensionPoints);
        this.addTemplates(pluginManifest.templateInfos);
        this.processPendingTemplateInstances();
        this.addTemplateInstances(pluginManifest.templateInstanceInfos, map);
        this.addExtensions(pluginManifest.extensions);
        return true;
    }

    public <T> List<T> getExtensionObjects(String string, Map<String, Object> map, boolean bl) {
        ExtensionPointInfo extensionPointInfo = this.getExtensionPointInfo(string);
        if (extensionPointInfo == null) {
            throw new IllegalArgumentException("ExtensionPointInfo not found for pointId: " + string);
        }
        ExtensionInfo[] extensionInfoArray = this.getExtensionInfos(string);
        return this.getExtensionObjectsInternal(extensionPointInfo, extensionInfoArray, map, bl);
    }

    public <T> T getExtensionObject(ExtensionInfo extensionInfo, Map<String, Object> map, boolean bl) {
        ExtensionInfo[] extensionInfoArray;
        if (extensionInfo.getExtendedPointIds().length > 1) {
            throw new IllegalArgumentException("Extension info that extend multiple extension points are not supported by this api: " + extensionInfo.getId());
        }
        String string = extensionInfo.getExtendedPointIds()[0];
        ExtensionPointInfo extensionPointInfo = this.getExtensionPointInfo(string);
        List<T> list = this.getExtensionObjectsInternal(extensionPointInfo, extensionInfoArray = new ExtensionInfo[]{extensionInfo}, map, bl);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public <T> List<T> getExtensionObjects(List<ExtensionInfo> list, Map<String, Object> map, boolean bl) {
        String string = null;
        for (ExtensionInfo extensionInfo : list) {
            if (extensionInfo.getExtendedPointIds().length > 1) {
                throw new IllegalArgumentException("Extension info that extend multiple extension points are not supported by this api: " + extensionInfo.getId());
            }
            if (string == null) {
                string = extensionInfo.getExtendedPointIds()[0];
            }
            if (string.equals(extensionInfo.getExtendedPointIds()[0])) continue;
            throw new IllegalArgumentException("This api does not support ExtensionInfos from different extension points.");
        }
        ExtensionPointInfo extensionPointInfo = this.getExtensionPointInfo(string);
        return this.getExtensionObjectsInternal(extensionPointInfo, list.toArray(new ExtensionInfo[list.size()]), map, bl);
    }

    private <T> List<T> getExtensionObjectsInternal(ExtensionPointInfo extensionPointInfo, ExtensionInfo[] extensionInfoArray, Map<String, Object> map, boolean bl) {
        List<ExtensionObjectFilter> list = this.getExtensionObjectFilters();
        Map<String, PropertyInfo> map2 = this.getFilterPropertiesFromFilters(list);
        ExtensionMetadataParser.parse(this._classLoaderService, extensionInfoArray, map2);
        if (map != null) {
            extensionInfoArray = this.runExtensionObjectFilters(extensionInfoArray, map, list);
        }
        ConcurrentHashMap<String, Object> concurrentHashMap = this.getExtensionObjectsMapForCurrentLocale();
        List list2 = ExtensionObjectParser.parse(extensionPointInfo, extensionInfoArray, this._classLoaderService, concurrentHashMap, bl);
        return list2;
    }

    private ConcurrentHashMap<String, Object> getExtensionObjectsMapForCurrentLocale() {
        Locale locale = ResourceUtil.getLocale();
        if (locale == null) {
            locale = ResourceUtil.DEFAULT_LOCALE;
        }
        if (this._extensionObjectMapByLocale.containsKey(locale)) {
            return this._extensionObjectMapByLocale.get(locale);
        }
        ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
        ConcurrentHashMap concurrentHashMap2 = this._extensionObjectMapByLocale.putIfAbsent(locale, concurrentHashMap);
        if (concurrentHashMap2 != null) {
            concurrentHashMap = concurrentHashMap2;
        }
        return concurrentHashMap;
    }

    private ExtensionInfo[] runExtensionObjectFilters(ExtensionInfo[] extensionInfoArray, Map<String, Object> map, List<ExtensionObjectFilter> list) {
        List<ExtensionInfo> list2 = Arrays.asList(extensionInfoArray);
        Filterer filterer = new Filterer(true);
        List<ExtensionInfo> list3 = filterer.filter(list2, map, list);
        filterer = new Filterer(false);
        list3 = filterer.filter(list3, map, list);
        return list3.toArray(new ExtensionInfo[0]);
    }

    private Map<String, PropertyInfo> getFilterPropertiesFromFilters(List<ExtensionObjectFilter> list) {
        HashMap<String, PropertyInfo> hashMap = new HashMap<String, PropertyInfo>();
        for (ExtensionObjectFilter extensionObjectFilter : list) {
            if (extensionObjectFilter.getFilterProperties() == null) continue;
            for (PropertyInfo propertyInfo : extensionObjectFilter.getFilterProperties()) {
                hashMap.put(propertyInfo.name, propertyInfo);
            }
        }
        return hashMap;
    }

    private void addExtensionPoints(List<ExtensionPointInfo> list) {
        for (ExtensionPointInfo extensionPointInfo : list) {
            String string = extensionPointInfo.getId();
            ExtensionPointInfo extensionPointInfo2 = this._pointById.putIfAbsent(string, extensionPointInfo);
            if (extensionPointInfo2 == null || extensionPointInfo.equalsDefinition(extensionPointInfo2)) continue;
            _logger.error((Object)("The plugin " + extensionPointInfo.getPluginRef() + " contains " + " a duplicate of the extension point " + string + " (already added by " + extensionPointInfo2.getPluginRef() + ")"));
        }
    }

    private void addExtensions(List<ExtensionInfo> list) {
        HashMap hashMap = new HashMap();
        for (ExtensionInfo object : list) {
            for (String string : object.getExtendedPointIds()) {
                if (!hashMap.containsKey(string)) {
                    hashMap.put(string, new ArrayList());
                }
                ((List)hashMap.get(string)).add(object);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            ExtensionList extensionList;
            String string = (String)entry.getKey();
            ExtensionList extensionList2 = this._extensionsByPointId.putIfAbsent(string, extensionList = new ExtensionList());
            if (extensionList2 != null) {
                extensionList = extensionList2;
            }
            List list2 = (List)entry.getValue();
            extensionList.append(list2);
        }
    }

    private void addTemplates(List<TemplateInfo> list) {
        Map<String, TemplateInfo> map = Collections.unmodifiableMap(this._templateById);
        TemplateMerger templateMerger = new TemplateMerger(map);
        for (TemplateInfo templateInfo : list) {
            if ((templateInfo = templateMerger.getMergedTemplateInfo(templateInfo)) == null) continue;
            this._templateById.put(templateInfo.getId(), templateInfo);
        }
    }

    private void addTemplateInstances(List<TemplateInstanceInfo> list, Map<String, String> map) {
        for (TemplateInstanceInfo templateInstanceInfo : list) {
            String string = templateInstanceInfo.getTemplateId();
            TemplateInfo templateInfo = (TemplateInfo)this._templateById.get(string);
            if (templateInfo == null) {
                _logger.warn((Object)("The template '" + string + "' referenced by the template " + "instance '" + templateInstanceInfo.getId() + "' could not be found. Will put it in the queue and try again."));
                this._pendingTemplateInstances.add(new PendingTemplateInstanceInfo(templateInstanceInfo, map));
                continue;
            }
            TemplateInstantiator templateInstantiator = new TemplateInstantiator(templateInfo, templateInstanceInfo, this._useH5MetadataParser);
            templateInstantiator.instantiate(map);
            List<ExtensionPointInfo> list2 = templateInstantiator.getExtensionPointInfos();
            List<ExtensionInfo> list3 = templateInstantiator.getExtensionInfos();
            this.addExtensionPoints(list2);
            this.addExtensions(list3);
        }
    }

    private void processPendingTemplateInstances() {
        if (this._pendingTemplateInstances.isEmpty()) {
            return;
        }
        PendingTemplateInstanceInfo[] pendingTemplateInstanceInfoArray = this._pendingTemplateInstances.toArray(new PendingTemplateInstanceInfo[0]);
        this._pendingTemplateInstances.clear();
        for (PendingTemplateInstanceInfo pendingTemplateInstanceInfo : pendingTemplateInstanceInfoArray) {
            ArrayList<TemplateInstanceInfo> arrayList = new ArrayList<TemplateInstanceInfo>(1);
            arrayList.add(pendingTemplateInstanceInfo.getTemplateInstanceInfo());
            _logger.info((Object)("Try processing templateInstance with id - " + pendingTemplateInstanceInfo.getTemplateInstanceInfo().getId()));
            this.addTemplateInstances(arrayList, pendingTemplateInstanceInfo.getMetadata());
        }
    }

    private File getPluginPackageManifestFile(File file) {
        File file2 = new File(file, PACKAGE_MANIFEST_LOCAL_URI);
        if (!file2.exists() && !(file2 = new File(file, PACKAGE_MANIFEST_URI)).exists()) {
            file2 = new File(file, LEGACY_PACKAGE_MANIFEST_URI);
            if (!file2.exists()) {
                return null;
            }
            _logger.warn((Object)("pluginPackage.xml file name is deprecated: " + file2.getAbsolutePath() + ", please use " + PACKAGE_MANIFEST_URI));
        }
        return file2;
    }

    private PackageDeployData getPackageDeployData(PluginPackageInfo pluginPackageInfo, boolean bl) throws IOException {
        List<BundleInfo> list;
        Object object;
        File file = pluginPackageInfo.getDirectory();
        assert (file != null);
        if (file == null) {
            return null;
        }
        File file2 = this.getPluginPackageManifestFile(file);
        if (file2 == null) {
            _logger.error((Object)("plugin-package.xml is missing here: " + file.getAbsolutePath() + ", ignoring it as a non-package folder!\n(If you registered this plugin with " + "VC, please check that the .zip file contains plugin-package.xml at its root)"));
            return null;
        }
        PackageManifestParser packageManifestParser = new PackageManifestParser();
        PackageManifest packageManifest = packageManifestParser.parse(file2, pluginPackageInfo);
        File file3 = new File(file, PLUGINS_URI);
        if (file3.exists()) {
            object = new BundleInfoLoader();
            list = ((BundleInfoLoader)object).getSortedBundleInfos(file3, packageManifest.orderedBundleIds);
        } else {
            list = Collections.emptyList();
        }
        if (list == null) {
            return null;
        }
        object = new PackageDeployData(packageManifest, list, file);
        return object;
    }

    private PluginInfo getPluginInfoByContextPath(String string) {
        for (PluginInfo pluginInfo : this._pluginByRef.values()) {
            if (!string.equals(pluginInfo.getContextPath())) continue;
            return pluginInfo;
        }
        return null;
    }

    public BundleInfo getBundleInfo(IdVersionPair idVersionPair) {
        for (PackageDeployData packageDeployData : this._packageDeployDataByRef.values()) {
            for (BundleInfo bundleInfo : packageDeployData.getBundlesInfo()) {
                if (!bundleInfo.getBundleRef().equals((Object)idVersionPair)) continue;
                return bundleInfo;
            }
        }
        return null;
    }

    private List<IdVersionPair> getPackageRefsContainingBundle(IdVersionPair idVersionPair) {
        ArrayList<IdVersionPair> arrayList = new ArrayList<IdVersionPair>();
        block0: for (PackageDeployData packageDeployData : this._packageDeployDataByRef.values()) {
            for (BundleInfo bundleInfo : packageDeployData.getBundlesInfo()) {
                if (!bundleInfo.getBundleRef().equals((Object)idVersionPair)) continue;
                arrayList.add(packageDeployData.getPackageRef());
                continue block0;
            }
        }
        return arrayList;
    }

    private ExtensionInfo findExtensionInfo(String string) {
        for (Iterable iterable : this._extensionsByPointId.values()) {
            for (ExtensionInfo extensionInfo : iterable) {
                if (!string.equals(extensionInfo.getId())) continue;
                return extensionInfo;
            }
        }
        return null;
    }

    private boolean isRelevantExtension(ExtensionInfo extensionInfo, Set<IdVersionPair> set) {
        PluginInfo pluginInfo;
        IdVersionPair idVersionPair = null;
        IdVersionPair idVersionPair2 = extensionInfo.getPluginRef();
        if (idVersionPair2 != null && (pluginInfo = this.getPluginInfo(idVersionPair2)) != null) {
            idVersionPair = pluginInfo.getPackageRef();
        }
        return idVersionPair == null || set.contains(idVersionPair);
    }

    private ExtensionInfo getExtensionInfoByHostedPointId(String string, IdVersionPair idVersionPair, IdVersionPair idVersionPair2) {
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        Set<IdVersionPair> set = this.getRelevantPackagesRefs();
        for (Object object : this._extensionsByPointId.values()) {
            Iterator object2 = object.iterator();
            while (object2.hasNext()) {
                String[] stringArray;
                ExtensionInfo extensionInfo = (ExtensionInfo)object2.next();
                if (!this.isRelevantExtension(extensionInfo, set) || (stringArray = extensionInfo.getHostedPointsIds()) == null || !Arrays.asList(stringArray).contains(string)) continue;
                arrayList.add(extensionInfo);
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() > 1) {
            Object object = null;
            for (ExtensionInfo extensionInfo : arrayList) {
                if (idVersionPair.equals((Object)extensionInfo.getPluginRef())) {
                    return extensionInfo;
                }
                if (object != null || idVersionPair2 == null || !idVersionPair2.equals((Object)this.getPluginInfo(extensionInfo.getPluginRef()).getPackageRef())) continue;
                object = extensionInfo;
            }
            if (object != null) {
                return object;
            }
        }
        return (ExtensionInfo)arrayList.get(0);
    }

    private Set<IdVersionPair> getRelevantPackagesRefs() {
        HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>(this._packageDeployDataByRef.keySet());
        List<ExtensionFilter> list = this.getFilters();
        for (ExtensionFilter pluginPackageStateInfoArray : list) {
            pluginPackageStateInfoArray.filterPackages(hashSet);
        }
        PluginPackageStateInfo[] pluginPackageStateInfoArray = this.getPackageStates();
        if (pluginPackageStateInfoArray != null) {
            for (PluginPackageStateInfo pluginPackageStateInfo : pluginPackageStateInfoArray) {
                if (pluginPackageStateInfo.getState()) continue;
                _logger.info((Object)("Package is filtered out - " + pluginPackageStateInfo.getPackageRef()));
                hashSet.remove(pluginPackageStateInfo.getPackageRef());
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ExtensionObjectFilter> getExtensionObjectFilters() {
        Object object = this._extensionObjectFilterLockObj;
        synchronized (object) {
            if (this._extensionObjectFilters == null) {
                this._extensionObjectFilters = this._serviceRegistry.getServices(ExtensionObjectFilter.class.getName());
                if (this._extensionObjectFilters == null) {
                    this._extensionObjectFilters = Collections.emptyList();
                }
            }
            return this._extensionObjectFilters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ExtensionFilter> getFilters() {
        Object object = this._filterLockObj;
        synchronized (object) {
            if (this._filters == null) {
                this._filters = this._serviceRegistry.getServices(ExtensionFilter.class.getName());
                if (this._filters == null) {
                    this._filters = Collections.emptyList();
                }
            }
            return this._filters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExtensionListener> getListeners() {
        Object object = this._listenerLockObj;
        synchronized (object) {
            if (this._listeners == null) {
                this._listeners = this._serviceRegistry.getServices(ExtensionListener.class.getName());
                if (this._listeners == null) {
                    this._listeners = Collections.emptyList();
                }
            }
            return this._listeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PluginPackageSource> getPluginSources() {
        Object object = this._pluginSourceLockObj;
        synchronized (object) {
            if (this._pluginSources == null) {
                this._pluginSources = this._serviceRegistry.getServices(PluginPackageSource.class.getName());
                if (this._pluginSources == null) {
                    this._pluginSources = Collections.emptyList();
                }
            }
            return this._pluginSources;
        }
    }

    private void dispatchPackageEvent(String string, PluginPackageInfo[] pluginPackageInfoArray) {
        if (pluginPackageInfoArray.length == 0) {
            return;
        }
        List<ExtensionListener> list = this.getListeners();
        if (list.isEmpty()) {
            return;
        }
        PluginPackageEvent pluginPackageEvent = new PluginPackageEvent(string, pluginPackageInfoArray);
        for (ExtensionListener extensionListener : list) {
            try {
                extensionListener.handleEvent(pluginPackageEvent);
            }
            catch (Exception exception) {
                _logger.error((Object)(extensionListener.getClass().getName() + " failed to handle the '" + string + "' event."), (Throwable)exception);
            }
        }
    }

    private PackageDeployData preAddPluginPackage(PackageDeployData packageDeployData) throws Exception {
        IdVersionPair idVersionPair = packageDeployData.getPackageRef();
        PackageDeployData packageDeployData2 = this.getPackageDeployDataById(idVersionPair.getId());
        if (packageDeployData2 == null) {
            return packageDeployData;
        }
        Version version = new Version(idVersionPair.getVersion());
        IdVersionPair idVersionPair2 = packageDeployData2.getPackageRef();
        Version version2 = new Version(idVersionPair2.getVersion());
        int n = version2.compareTo(version);
        if (n >= 0) {
            _logger.info((Object)("Use the plugin package " + idVersionPair2 + " instead of the older " + idVersionPair));
            return packageDeployData2;
        }
        this.undeployPackage(idVersionPair2);
        Map<String, Object> map = packageDeployData2.getPackageInfo().getMetadata();
        if (map != null && map.containsKey(SERVER_GUIDS)) {
            String[] stringArray = (String[])map.get(SERVER_GUIDS);
            PluginPackageInfo pluginPackageInfo = packageDeployData.getPackageInfo();
            Map<String, Object> map2 = pluginPackageInfo.getMetadata();
            if (map2 == null) {
                map2 = new HashMap<String, Object>();
                pluginPackageInfo.setMetadata(map2);
            }
            map2.put(SERVER_GUIDS, stringArray);
        }
        return packageDeployData;
    }

    private void undeployPackage(IdVersionPair idVersionPair) {
        PackageDeployData packageDeployData = (PackageDeployData)this._packageDeployDataByRef.get(idVersionPair);
        if (packageDeployData == null) {
            _logger.error((Object)("The plugin package " + idVersionPair + " cannot be undeployed because it is not deployed."));
            return;
        }
        List<BundleInfo> list = packageDeployData.getBundlesInfo();
        ArrayList<BundleInfo> arrayList = new ArrayList<BundleInfo>(list.size());
        Collections.reverse(list);
        for (BundleInfo bundleInfo : list) {
            IdVersionPair idVersionPair2 = bundleInfo.getBundleRef();
            List<IdVersionPair> list2 = this.getPackageRefsContainingBundle(idVersionPair2);
            if (list2.size() != 1) continue;
            arrayList.add(bundleInfo);
        }
        try {
            _logger.info((Object)("Undeploying plugin package '" + idVersionPair + "'."));
            this._bundleDeployer.undeploy(arrayList);
            this._packageDeployDataByRef.remove(idVersionPair);
            _logger.info((Object)("Undeployed plugin package '" + idVersionPair + "'."));
            this.dispatchPackageEvent("pluginPackageUndeployed", new PluginPackageInfo[]{packageDeployData.getPackageInfo()});
        }
        catch (Exception exception) {
            _logger.error((Object)("Error undeploying the bundles for the plugin package " + packageDeployData.getPackageDir()), (Throwable)exception);
        }
    }

    private PackageDeployData getPackageDeployDataById(String string) {
        for (PackageDeployData packageDeployData : this._packageDeployDataByRef.values()) {
            IdVersionPair idVersionPair = packageDeployData.getPackageRef();
            if (!string.equals(idVersionPair.getId())) continue;
            return packageDeployData;
        }
        return null;
    }

    private Map<String, String> computeExtraExtensionInfoMetadata(String string, String string2) {
        String string3;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null) {
            PackageDeployData packageDeployData = this.getPackageDeployDataById(string);
            string3 = packageDeployData.getPackageInfo().getName();
        } else {
            string3 = string2;
            int n = string2.lastIndexOf(46) + 1;
            if (n > 0 && n < string2.length()) {
                string3 = string2.substring(n);
            }
            string = DEFAULT_PLUGIN_PACKAGE_ID;
        }
        hashMap.put(PLUGIN_PACKAGE_ID, string);
        hashMap.put(PLUGIN_PACKAGE_NAME, string3);
        return hashMap;
    }

    private boolean isPluginPackageIncompatible(IdVersionPair idVersionPair) {
        if (this._pluginCompatibilityService == null) {
            return false;
        }
        CompatibilityStatus compatibilityStatus = this._pluginCompatibilityService.getStatus(idVersionPair);
        return CompatibilityStatus.incompatible.equals((Object)compatibilityStatus);
    }

    private boolean isPluginPackageCompatible(IdVersionPair idVersionPair) {
        if (this._pluginCompatibilityService == null) {
            return false;
        }
        CompatibilityStatus compatibilityStatus = this._pluginCompatibilityService.getStatus(idVersionPair);
        return CompatibilityStatus.compatible.equals((Object)compatibilityStatus);
    }

    private void rememberPluginPackageAsIncompatible(PluginPackageInfo pluginPackageInfo) {
        IdVersionPair idVersionPair = pluginPackageInfo.getPackageRef();
        for (PluginPackageInfo pluginPackageInfo2 : this._incompatiblePackages) {
            if (!idVersionPair.equals((Object)pluginPackageInfo2.getPackageRef())) continue;
            return;
        }
        this._incompatiblePackages.add(pluginPackageInfo);
    }

    private void forgetPluginPackageAsIncompatible(PluginPackageInfo pluginPackageInfo) {
        IdVersionPair idVersionPair = pluginPackageInfo.getPackageRef();
        for (PluginPackageInfo pluginPackageInfo2 : this._incompatiblePackages) {
            if (!idVersionPair.equals((Object)pluginPackageInfo2.getPackageRef())) continue;
            this._incompatiblePackages.remove(pluginPackageInfo2);
            break;
        }
    }

    public OsgiUsageValidationService getUsageValidationService() {
        return this._usageValidationService;
    }

    public void setUsageValidationService(OsgiUsageValidationService osgiUsageValidationService) {
        this._usageValidationService = osgiUsageValidationService;
    }

    private static class PendingTemplateInstanceInfo {
        private TemplateInstanceInfo _templateInstanceInfo = null;
        private Map<String, String> _metadata = null;

        public PendingTemplateInstanceInfo(TemplateInstanceInfo templateInstanceInfo, Map<String, String> map) {
            this._templateInstanceInfo = templateInstanceInfo;
            this._metadata = map;
        }

        public TemplateInstanceInfo getTemplateInstanceInfo() {
            return this._templateInstanceInfo;
        }

        public Map<String, String> getMetadata() {
            return this._metadata;
        }
    }

    private static class ExtensionList
    implements Iterable<ExtensionInfo> {
        private final CopyOnWriteArrayList<ExtensionInfo> _list = new CopyOnWriteArrayList();
        private final ReentrantLock _lock = new ReentrantLock();
        private volatile boolean _isSorted = true;

        private ExtensionList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void append(Collection<ExtensionInfo> collection) {
            ReentrantLock reentrantLock = this._lock;
            try {
                reentrantLock.lock();
                this._list.addAll(collection);
                this._isSorted = false;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean sort() {
            ReentrantLock reentrantLock = this._lock;
            try {
                reentrantLock.lock();
                if (!this._isSorted) {
                    new ExtensionSorter().sort(this._list);
                    this._isSorted = true;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<String> removeByPluginRef(IdVersionPair idVersionPair) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ReentrantLock reentrantLock = this._lock;
            try {
                reentrantLock.lock();
                ArrayList<ExtensionInfo> arrayList2 = new ArrayList<ExtensionInfo>(this._list.size());
                for (ExtensionInfo extensionInfo : this) {
                    if (!extensionInfo.getPluginRef().equals((Object)idVersionPair)) continue;
                    arrayList2.add(extensionInfo);
                    arrayList.add(extensionInfo.getId());
                }
                if (!arrayList2.isEmpty()) {
                    this._list.removeAll(arrayList2);
                    this._isSorted = false;
                }
            }
            finally {
                reentrantLock.unlock();
            }
            return arrayList;
        }

        @Override
        public Iterator<ExtensionInfo> iterator() {
            return this._list.iterator();
        }
    }

    private static class ExtensionManagerHolder {
        private static final ExtensionManager _instance = new ExtensionManager();

        private ExtensionManagerHolder() {
        }
    }

    private static enum DeploymentStatus {
        undeployed,
        deployedAndEnabled,
        deployedAndDisabled;

    }
}

