/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.BundleInfo;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.io.StreamUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BundleInfoLoader {
    private static final Log _logger = LogFactory.getLog(BundleInfoLoader.class);
    private static final String MANIFEST_URI = "META-INF/MANIFEST.MF";
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String BUNDLE_VENDOR = "Bundle-Vendor";
    private static final String BUNDLE_CLASSPATH = "Bundle-Classpath";
    public static final String BUNDLE_VERSION = "Bundle-Version";
    public static final String WEB_CONTEXT_PATH = "Web-ContextPath";
    private static final String EXPORT_PACKAGE = "Export-Package";
    private static final String IMPORT_PACKAGE = "Import-Package";
    private static final String DYNAMIC_IMPORT_PACKAGE = "DynamicImport-Package";
    private static final String REQUIRE_BUNDLE = "Require-Bundle";

    public List<BundleInfo> getSortedBundleInfos(File file, List<String> list) throws IOException {
        Object object;
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return Collections.emptyList();
        }
        HashMap<String, Pair> hashMap = new HashMap<String, Pair>();
        for (File object22 : fileArray) {
            object = this.getManifest(object22);
            if (object == null) continue;
            Attributes attributes = ((Manifest)object).getMainAttributes();
            String string = attributes.getValue(BUNDLE_SYMBOLIC_NAME);
            hashMap.put(string, new Pair(object, (Object)object22));
        }
        ArrayList arrayList = new ArrayList();
        for (String string : list) {
            if (!hashMap.containsKey(string)) continue;
            Pair pair = (Pair)hashMap.remove(string);
            object = this.getBundleInfoFromManifest((Manifest)pair.first, (File)pair.second, true);
            arrayList.add(object);
        }
        for (Pair pair : hashMap.values()) {
            BundleInfo bundleInfo = this.getBundleInfoFromManifest((Manifest)pair.first, (File)pair.second, false);
            arrayList.add(bundleInfo);
        }
        return arrayList;
    }

    public BundleInfo getBundleInfo(File file) throws IOException {
        Manifest manifest = this.getManifest(file);
        if (manifest == null) {
            return null;
        }
        BundleInfo bundleInfo = this.getBundleInfoFromManifest(manifest, file, false);
        return bundleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest getManifest(File file) throws IOException {
        if (file.isDirectory()) {
            File file2 = new File(file, MANIFEST_URI);
            if (!file2.exists()) {
                return null;
            }
            FileInputStream fileInputStream = new FileInputStream(file2);
            try {
                Manifest manifest = new Manifest();
                manifest.read(fileInputStream);
                Manifest manifest2 = manifest;
                return manifest2;
            }
            finally {
                StreamUtil.close((Closeable)fileInputStream);
            }
        }
        String string = file.getName();
        if (!string.endsWith(".jar") && !string.endsWith(".war")) {
            return null;
        }
        JarFile jarFile = new JarFile(file);
        try {
            Manifest manifest;
            Manifest manifest3 = manifest = jarFile.getManifest();
            return manifest3;
        }
        finally {
            StreamUtil.close((ZipFile)jarFile);
        }
    }

    private BundleInfo getBundleInfoFromManifest(Manifest manifest, File file, boolean bl) throws IOException {
        Attributes attributes = manifest.getMainAttributes();
        String string = attributes.getValue(BUNDLE_SYMBOLIC_NAME);
        String string2 = attributes.getValue(BUNDLE_VERSION);
        if (string == null || string2 == null) {
            throw new IOException("The bundle at " + file + " should have Bundle-SymbolicName and Bundle-Version" + " headers in its MANIFEST.MF");
        }
        String string3 = attributes.getValue(BUNDLE_VENDOR);
        String string4 = attributes.getValue(BUNDLE_CLASSPATH);
        String string5 = attributes.getValue(WEB_CONTEXT_PATH);
        if (StringUtil.isNullOrEmpty((String)string5)) {
            string5 = file.getParentFile().getName();
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Context path from bundle's MANIFEST.MF was null, will just use the directory name - " + file.getAbsolutePath()));
            }
        }
        String string6 = attributes.getValue(EXPORT_PACKAGE);
        String string7 = attributes.getValue(IMPORT_PACKAGE);
        String string8 = attributes.getValue(DYNAMIC_IMPORT_PACKAGE);
        String string9 = attributes.getValue(REQUIRE_BUNDLE);
        BundleInfo bundleInfo = new BundleInfo(string, string2, string5, file, string3, string4, string6, string7, string8, string9, bl);
        return bundleInfo;
    }
}

