/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.BundleInfo;
import com.vmware.vise.extensionfw.DeploymentUtil;
import com.vmware.vise.extensionfw.ExtensionManager;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Dictionary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ExtensionBundleActivator
implements EventHandler {
    public static final String USER_REGION_EVENT = "org/eclipse/virgo/kernel/userregion/userartifacts/DEPLOYED";
    private static final String PACKAGES_FOLDER_NAME = "plugin-packages";
    private static final Log _logger = LogFactory.getLog(ExtensionBundleActivator.class);

    public ExtensionBundleActivator(BundleContext bundleContext) {
        if (bundleContext != null) {
            bundleContext.addBundleListener((BundleListener)new PluginBundleListener());
        }
    }

    public void handleEvent(Event event) {
        if (event == null || !USER_REGION_EVENT.equals(event.getTopic())) {
            _logger.warn((Object)("Unexpected event handled: " + event));
        } else {
            PluginActivatorThread pluginActivatorThread = new PluginActivatorThread();
            pluginActivatorThread.start();
        }
    }

    private static class PluginBundleListener
    implements BundleListener {
        private static final String MANIFEST_FILE_URI = "/plugin.xml";

        private PluginBundleListener() {
        }

        public void bundleChanged(BundleEvent bundleEvent) {
            Bundle bundle = bundleEvent.getBundle();
            int n = bundleEvent.getType();
            if (n == 2) {
                try {
                    this.bundleStarted(bundle);
                }
                catch (Exception exception) {
                    if (_logger.isErrorEnabled()) {
                        _logger.error((Object)("Error from bundleStarted: " + bundleEvent.getBundle()), (Throwable)exception);
                    }
                }
            } else if (n == 4) {
                this.bundleStopped(bundle);
            }
        }

        private void bundleStarted(Bundle bundle) throws Exception {
            BundleInfo bundleInfo = this.getBundleInfo(bundle);
            URL uRL = bundle.getEntry(MANIFEST_FILE_URI);
            ExtensionManager.getInstance().bundleStarted(bundleInfo, uRL);
        }

        private void bundleStopped(Bundle bundle) {
            BundleInfo bundleInfo = this.getBundleInfo(bundle);
            ExtensionManager.getInstance().bundleStopped(bundleInfo);
        }

        private BundleInfo getBundleInfo(Bundle bundle) {
            Dictionary dictionary = bundle.getHeaders();
            String string = (String)dictionary.get("Bundle-SymbolicName");
            String string2 = (String)dictionary.get("Bundle-Version");
            String string3 = (String)dictionary.get("Web-ContextPath");
            File file = new File(bundle.getLocation());
            String string4 = (String)dictionary.get("Export-Package");
            String string5 = (String)dictionary.get("Import-Package");
            BundleInfo bundleInfo = new BundleInfo(string, string2, string3, file, string4, string5);
            return bundleInfo;
        }
    }

    private static class PluginActivatorThread
    extends Thread {
        private PluginActivatorThread() {
        }

        @Override
        public void run() {
            File file;
            long l = System.currentTimeMillis();
            File file2 = DeploymentUtil.getStatusFile();
            if (file2 != null) {
                if (file2.exists()) {
                    file2.delete();
                }
                file2.deleteOnExit();
            }
            if ((file = this.getPackagesDir()) != null) {
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    ArrayList<PluginPackageInfo> arrayList = new ArrayList<PluginPackageInfo>(fileArray.length);
                    for (File file3 : fileArray) {
                        if (!Files.isDirectory(file3.toPath(), new LinkOption[0])) continue;
                        PluginPackageInfo pluginPackageInfo = new PluginPackageInfo(file3);
                        arrayList.add(pluginPackageInfo);
                    }
                    Serializable[] serializableArray = arrayList.toArray(new PluginPackageInfo[arrayList.size()]);
                    ExtensionManager.getInstance().addPluginPackages((PluginPackageInfo[])serializableArray);
                }
                long l2 = System.currentTimeMillis() - l;
                _logger.info((Object)String.format("Internal plugins deployment done in (ms): %d", l2));
            }
            try {
                if (file2 != null) {
                    file2.createNewFile();
                }
            }
            catch (IOException iOException) {
                _logger.error((Object)("Could not create the status file " + file2));
            }
            this.invokeExtensionParsing();
        }

        private void invokeExtensionParsing() {
            ExtensionManager.getInstance().getAllCombinedExtensionPointInfos();
        }

        private File getPackagesDir() {
            Object object;
            File file;
            block6: {
                URL uRL = this.getClass().getProtectionDomain().getCodeSource().getLocation();
                file = null;
                try {
                    file = new File(uRL.toURI());
                }
                catch (URISyntaxException uRISyntaxException) {
                    object = uRL.toString();
                    if (((String)object).contains(" ")) {
                        object = ((String)object).replace(" ", "%20");
                        try {
                            file = new File(new URI((String)object));
                        }
                        catch (URISyntaxException uRISyntaxException2) {
                            // empty catch block
                        }
                    }
                    if (file != null) break block6;
                    _logger.error((Object)"Could not compute jar file", (Throwable)uRISyntaxException);
                    return null;
                }
            }
            File file2 = file;
            while (file2 != null && (file2 = file2.getParentFile()) != null) {
                object = new File(file2, ExtensionBundleActivator.PACKAGES_FOLDER_NAME);
                if (!((File)object).exists() || !((File)object).isDirectory()) continue;
                return object;
            }
            _logger.warn((Object)"Plugin package directory not found.");
            return null;
        }
    }
}

