/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.ExtensionInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExtensionSorter {
    private static final String FIRST_ID = "NULL";
    private List<ExtensionInfo> _extensions;
    private Map<String, List<ExtensionInfo>> _buckets = new HashMap<String, List<ExtensionInfo>>();
    private List<ExtensionInfo> _sortedExtensions;
    private Set<String> _sortedExtensionIds;

    public void sort(List<ExtensionInfo> list) {
        this._extensions = list;
        LinkedList<ExtensionInfo> linkedList = new LinkedList<ExtensionInfo>(list);
        for (ExtensionInfo list22 : this._extensions) {
            String string;
            Set<String> set = list22.getPrecedingIds();
            if (set == null || (string = this.getPrecedingExtensionId(set)) == null) continue;
            this.addToBucket(string, list22, linkedList);
        }
        if (this._buckets.isEmpty()) {
            return;
        }
        int n = this._extensions.size();
        this._sortedExtensions = new ArrayList<ExtensionInfo>(n);
        this._sortedExtensionIds = new HashSet<String>(n);
        List<ExtensionInfo> list2 = this._buckets.get(FIRST_ID);
        if (list2 != null) {
            this.addSortedExtensions(list2);
        }
        this.addSortedExtensions(linkedList);
        this._extensions.clear();
        this._extensions.addAll(this._sortedExtensions);
    }

    public List<ExtensionInfo> getSortedExtensions() {
        return this._sortedExtensions;
    }

    private String getPrecedingExtensionId(Set<String> set) {
        if (set.contains(FIRST_ID)) {
            return FIRST_ID;
        }
        for (ExtensionInfo extensionInfo : this._extensions) {
            if (!set.contains(extensionInfo.getId())) continue;
            return extensionInfo.getId();
        }
        return null;
    }

    private void addToBucket(String string, ExtensionInfo extensionInfo, List<ExtensionInfo> list) {
        List<ExtensionInfo> list2 = this._buckets.get(string);
        if (list2 == null) {
            list2 = new ArrayList<ExtensionInfo>();
            this._buckets.put(string, list2);
        }
        list2.add(extensionInfo);
        list.remove(extensionInfo);
    }

    private void addSortedExtensions(List<ExtensionInfo> list) {
        for (ExtensionInfo extensionInfo : list) {
            String string = extensionInfo.getId();
            if (!this._sortedExtensionIds.add(string)) continue;
            this._sortedExtensions.add(extensionInfo);
            List<ExtensionInfo> list2 = this._buckets.get(string);
            if (list2 == null) continue;
            this.addSortedExtensions(list2);
        }
    }
}

