/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionPointInfo;
import com.vmware.vise.extensionfw.PluginDependency;
import com.vmware.vise.extensionfw.impl.PackageManifestParser;
import com.vmware.vise.extensionfw.impl.PluginManifest;
import com.vmware.vise.extensionfw.impl.TemplateInfo;
import com.vmware.vise.extensionfw.impl.TemplateInstanceInfo;
import com.vmware.vise.extensionfw.impl.TemplateVariableInfo;
import com.vmware.vise.util.DocumentBuilderFactorySource;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.XMLUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PluginManifestParser {
    private final DocumentBuilderFactorySource _builderFactorySource = DocumentBuilderFactorySource.INSTANCE;
    private boolean _useH5MetadataParser;
    private static final Log _logger = LogFactory.getLog(PluginManifestParser.class);
    private static final Pattern COLUMN_TAIL_PATTERN = Pattern.compile("</com.vmware.ui.lists.ColumnDataSourceInfo>.*", 32);
    private static final Pattern ACTION_TAIL_PATTERN = Pattern.compile("</com.vmware.actionsfw.ActionSpec>.*", 32);
    private static final Pattern PROP_PATTERN = Pattern.compile("<requestedProperties>(.*)<");
    private static final Pattern SORT_PATTERN = Pattern.compile("<sortProperty>(.*)<");
    private static final Pattern UID_PATTERN = Pattern.compile("<uid>(.*)<");
    private static final Pattern ACTIONURL_PATTERN = Pattern.compile("<actionUrl>(.*)<");
    private static final Pattern DIALOGTITLE_PATTERN = Pattern.compile("<dialogTitle>(.*)<");
    private static final Pattern DIALOGSIZE_PATTERN = Pattern.compile("<dialogSize>(.*)<");
    private static final Pattern DIALOGICON_PATTERN = Pattern.compile("<dialogIcon>(.*)<");

    public PluginManifestParser(boolean bl) {
        this._useH5MetadataParser = bl;
    }

    public PluginManifest getPluginManifest(URL uRL, String string, String string2, Map<String, String> map) throws IOException {
        Element element;
        Document document;
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = this._builderFactorySource.createDocumentBuilder();
            document = documentBuilder.parse(uRL.toString());
            element = document.getDocumentElement();
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        PluginManifest pluginManifest = new PluginManifest();
        String string3 = XMLUtil.getAttribute((Element)element, (String)"id");
        if (string3 != null) {
            string = string3;
        }
        if (string == null) {
            throw new IOException("The plugin manifest at " + uRL + " should specify a plugin id attribute.");
        }
        IdVersionPair idVersionPair = new IdVersionPair(string, string2);
        String string4 = XMLUtil.getAttribute((Element)element, (String)"type");
        if (string4 != null) {
            pluginManifest.pluginType = string4;
        }
        pluginManifest.pluginId = string;
        pluginManifest.securityPolicyURI = XMLUtil.getAttribute((Element)element, (String)"securityPolicyUri");
        pluginManifest.moduleURI = XMLUtil.getAttribute((Element)element, (String)"moduleUri");
        if (this._useH5MetadataParser && pluginManifest.moduleURI != null && !this.hasHtmlViewOrAction(element)) {
            _logger.warn((Object)("Ignoring plugin " + string + " because it doesn't contain any HTML view or action"));
            return null;
        }
        Element element2 = XMLUtil.getChildTag((Node)element, (String)"resources");
        if (element2 != null) {
            Document document2 = documentBuilder.newDocument();
            document2.appendChild(document2.importNode(element2, true));
            pluginManifest.resourceXml = document2;
        }
        pluginManifest.defaultBundle = XMLUtil.getAttribute((Element)element, (String)"defaultBundle");
        pluginManifest.extensionPoints = this.getExtensionPointInfos(element, idVersionPair);
        pluginManifest.extensions = this.getExtensionInfos(element, idVersionPair, document, map);
        pluginManifest.templateInfos = this.getTemplateInfos(element, idVersionPair);
        pluginManifest.templateInstanceInfos = this.getTemplateInstanceInfos(element, idVersionPair);
        pluginManifest.exportedClasses = this.getExportedClasses(element);
        pluginManifest.dependencies = this.getDependencies(XMLUtil.getChildTag((Node)element, (String)"dependencies"));
        pluginManifest.metadata = PackageManifestParser.parseMetadata(element);
        return pluginManifest;
    }

    private boolean hasHtmlViewOrAction(Element element) throws IOException {
        List list = XMLUtil.getChildTags((Node)element, (String)"extension");
        for (Element element2 : list) {
            String string = XMLUtil.xmlToString((Node)element2);
            if (string.contains("com.vmware.vsphere.client.htmlbridge.HtmlView")) {
                return true;
            }
            if (!string.contains("com.vmware.vsphere.client.htmlbridge.HtmlActionDelegate")) continue;
            return true;
        }
        return false;
    }

    public List<ExtensionPointInfo> getExtensionPointInfos(Element element, IdVersionPair idVersionPair) throws IOException {
        List list = XMLUtil.getChildTags((Node)element, (String)"extensionPoint");
        ArrayList<ExtensionPointInfo> arrayList = new ArrayList<ExtensionPointInfo>(list.size());
        for (Element element2 : list) {
            String string = XMLUtil.getAttribute((Element)element2, (String)"id");
            if (string == null) {
                throw new IOException("The extensionPoint tag should specify an id attribute.");
            }
            String string2 = null;
            Element element3 = XMLUtil.getChildTag((Node)element2, (String)"objectType");
            if (element3 != null) {
                string2 = XMLUtil.getAttribute((Element)element3, (String)"class");
            }
            if (string2 == null) {
                throw new IOException("The extension-point " + string + " should specify an " + "objectType tag with a class attribute.");
            }
            ExtensionPointInfo extensionPointInfo = new ExtensionPointInfo();
            extensionPointInfo.setId(string);
            extensionPointInfo.setPluginRef(idVersionPair);
            extensionPointInfo.setObjectType(string2);
            arrayList.add(extensionPointInfo);
        }
        return arrayList;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public List<ExtensionInfo> getExtensionInfos(Element var1_1, IdVersionPair var2_2, Document var3_3, Map<String, String> var4_4) throws IOException {
        var5_5 = XMLUtil.getChildTags((Node)var1_1, (String)"extension");
        var6_6 = new ArrayList<ExtensionInfo>(var5_5.size());
        for (Element var8_8 : var5_5) {
            block14: {
                block16: {
                    block15: {
                        var9_9 = XMLUtil.getAttribute((Element)var8_8, (String)"id");
                        if (var9_9 == null) {
                            throw new IOException("The extension tag should specify an extension id.");
                        }
                        var10_10 = this.getTagValues(var8_8, "extendedPoint");
                        if (var10_10 == null) {
                            throw new IOException("The extension tag should specify an extendedPoint tag.");
                        }
                        if (this._useH5MetadataParser) {
                            for (var11_12 = 0; var11_12 < var10_10.length; ++var11_12) {
                                var12_13 = var10_10[var11_12];
                                if (!var12_13.endsWith(".html")) continue;
                                var10_10[var11_12] = var12_13.substring(0, var12_13.lastIndexOf(".html"));
                            }
                        }
                        if ((var11_11 = XMLUtil.getChildTag((Node)var8_8, (String)"object")) == null) {
                            throw new IOException("The extension tag should have a nested object tag.");
                        }
                        var12_13 = XMLUtil.getAttribute((Element)var11_11, (String)"type");
                        var11_11.removeAttribute("type");
                        var13_14 = XMLUtil.xmlToString((Node)var11_11);
                        var14_15 = true;
                        var15_16 = null;
                        if (!this._useH5MetadataParser) break block14;
                        if (!var13_14.contains("<componentClass")) break block15;
                        if ((var13_14 = this.convertComponentClassXml(var13_14, var9_9, var2_2)) == null) {
                            PluginManifestParser._logger.warn((Object)("Ignoring Flex view id " + var9_9 + " in plugin " + var2_2.getId()));
                            continue;
                        }
                        break block14;
                    }
                    if (!var13_14.contains("com.vmware.ui.lists.ColumnContainer")) break block16;
                    var14_15 = false;
                    var15_16 = this.convertColumnContainerXml(var13_14, var9_9);
                    break block14;
                }
                if (!var10_10[0].equals("vise.actions.sets")) ** GOTO lbl44
                var14_15 = false;
                if (var13_14.contains("com.vmware.vsphere.client.htmlbridge.HtmlActionDelegate")) {
                    var13_14 = this.convertRootPath(var13_14, "<actionUrl>", var9_9, var2_2);
                    var15_16 = this.convertActionSet(var13_14, var9_9);
                    var10_10 = new String[]{"vise.actions.specs"};
                } else {
                    PluginManifestParser._logger.warn((Object)("Ignoring Flex actions set id " + var9_9 + " in plugin " + var2_2.getId()));
                    continue;
lbl44:
                    // 1 sources

                    if (var10_10[0].equals("vsphere.core.menus.solutionMenus")) {
                        var13_14 = this.convertSolutionMenus(var13_14, var9_9, var2_2);
                        var10_10 = new String[]{"vise.menus.context.solutionMenus"};
                    } else if (var10_10[0].equals("vise.relateditems.specs")) {
                        var13_14 = this.convertRelatedItems(var13_14);
                    }
                }
            }
            if (var14_15) {
                var16_17 = this.createExtensionInfo(var8_8, var9_9, var10_10, var2_2, var12_13, var13_14);
                this.addMetadata(var16_17, var3_3, var8_8, var4_4);
                var6_6.add(var16_17);
                continue;
            }
            for (Pair var17_18 : var15_16) {
                var18_19 = (String)var17_18.first;
                var19_20 = (String)var17_18.second;
                var20_21 = this.createExtensionInfo(var8_8, var18_19, var10_10, var2_2, var12_13, var19_20);
                this.addMetadata(var20_21, var3_3, var8_8, var4_4);
                var6_6.add(var20_21);
            }
        }
        return var6_6;
    }

    private ExtensionInfo createExtensionInfo(Element element, String string, String[] stringArray, IdVersionPair idVersionPair, String string2, String string3) throws IOException {
        String[] stringArray2 = this.getTagValues(element, "hostedPoint");
        ExtensionInfo extensionInfo = new ExtensionInfo();
        extensionInfo.setId(string);
        extensionInfo.setExtendedPointIds(stringArray);
        extensionInfo.setHostedPointsIds(stringArray2);
        extensionInfo.setPluginRef(idVersionPair);
        extensionInfo.setObjectType(string2);
        extensionInfo.setObjectXmlStr(string3);
        extensionInfo.setPrecedingIds(this.getPrecedingExtensions(element));
        return extensionInfo;
    }

    private void addMetadata(ExtensionInfo extensionInfo, Document document, Element element, Map<String, String> map) throws IOException {
        Element element2 = XMLUtil.getChildTag((Node)element, (String)"metadata");
        if (map != null) {
            if (element2 == null) {
                element2 = document.createElement("metadata");
            }
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                Element element3 = document.createElement(string);
                Text text = document.createTextNode((String)entry.getValue());
                element3.appendChild(text);
                element2.appendChild(element3);
            }
        }
        if (element2 != null) {
            String string = XMLUtil.xmlToString((Node)element2);
            extensionInfo.setMetadataXmlStr(string);
        }
    }

    private String convertSolutionMenus(String string, String string2, IdVersionPair idVersionPair) {
        string = string.replaceAll("<children>", "<type>MENU</type>\n  <children>");
        string = string.replaceAll("<Array>", "");
        string = string.replaceAll("</Array>", "");
        string = string.replaceAll("com.vmware.actionsfw.ActionMenuItemSpec", "object");
        string = string.replaceAll("<type>action</type>", "<type>ACTION</type>");
        string = string.replaceAll("<type>separator</type>", "<type>SEPARATOR</type>");
        return string;
    }

    private String convertRelatedItems(String string) {
        String string2 = "com.vmware.ui.relateditems.model.RelationSpec";
        if (!string.contains(string2)) {
            return string;
        }
        string = string.replaceAll("<relationSpecs>", "");
        string = string.replaceAll("</relationSpecs>", "");
        string = string.replaceAll(string2, "relationSpecs");
        return string;
    }

    private String convertComponentClassXml(String string, String string2, IdVersionPair idVersionPair) {
        if (string.contains("com.vmware.vsphere.client.htmlbridge.HtmlView")) {
            string = string.replaceAll("componentClass", "contentSpec");
            string = string.replaceAll("<object>[\\s]*<root>", "");
            string = string.replaceAll("</root>[\\s]*</object>", "<sandbox>true</sandbox>");
            string = this.convertRootPath(string, "<url>", string2, idVersionPair);
        } else if (string.contains("<componentClass")) {
            return null;
        }
        return string;
    }

    private String convertRootPath(String string, String string2, String string3, IdVersionPair idVersionPair) {
        String string4 = string2 + "/ui/";
        String string5 = string2 + "/vsphere-client/";
        if (string.contains(string5)) {
            string = string.replaceAll(string5, string4);
        } else if (string.contains(string4)) {
            _logger.warn((Object)("Plugin '" + idVersionPair.getId() + "' should not hard-code URL path '/ui/' in extension: " + string3 + ",\n it should either be a relative path (plugin-name/...), or start with /vsphere-client/plugin-name " + "for Flex client compatibility."));
        } else {
            _logger.warn((Object)("Plugin '" + idVersionPair.getId() + "' is missing URL path '/vsphere-client/' in extension: " + string3 + ",\n this is required for Flex client compatibility."));
        }
        return string;
    }

    private List<Pair<String, String>> convertActionSet(String string, String string2) {
        ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
        String[] stringArray = string.split("<com.vmware.actionsfw.ActionSpec>");
        for (int i = 1; i < stringArray.length; ++i) {
            String string3 = ACTION_TAIL_PATTERN.matcher(stringArray[i]).replaceAll("");
            Matcher matcher = UID_PATTERN.matcher(string3);
            if (!matcher.find()) {
                _logger.error((Object)("Skipping ActionSpec because <uid> is missing, in extension " + string2));
                continue;
            }
            String string4 = matcher.group(1);
            ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
            matcher = ACTIONURL_PATTERN.matcher(string3);
            if (!matcher.find()) {
                _logger.error((Object)("Skipping ActionSpec because <actionUrl> is missing, in extension " + string2));
                continue;
            }
            arrayList2.add(new Pair((Object)"actionUrl", (Object)matcher.group(1)));
            matcher = DIALOGTITLE_PATTERN.matcher(string3);
            if (matcher.find()) {
                arrayList2.add(new Pair((Object)"dialogTitle", (Object)matcher.group(1)));
            }
            if ((matcher = DIALOGSIZE_PATTERN.matcher(string3)).find()) {
                arrayList2.add(new Pair((Object)"dialogSize", (Object)matcher.group(1)));
            }
            if ((matcher = DIALOGICON_PATTERN.matcher(string3)).find()) {
                arrayList2.add(new Pair((Object)"dialogIcon", (Object)matcher.group(1)));
            }
            string3 = string3 + "\n<additionalData>";
            for (Pair pair : arrayList2) {
                string3 = string3 + "\n<entry><key>" + (String)pair.first + "</key>";
                string3 = string3 + "\n<value>" + (String)pair.second + "</value></entry>";
            }
            string3 = string3 + "\n</additionalData>";
            string3 = string3 + "\n<invoker>com.vmware.vsphere.client.htmlbridge.HtmlActionDelegate</invoker>";
            string3 = string3.replaceAll("conditionalProperty>", "availabilityProperty>");
            string3 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<object>" + string3 + "\n</object>";
            arrayList.add((Pair<String, String>)new Pair((Object)string4, (Object)string3));
        }
        return arrayList;
    }

    private List<Pair<String, String>> convertColumnContainerXml(String string, String string2) {
        ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
        String[] stringArray = string.split("<com.vmware.ui.lists.ColumnDataSourceInfo>");
        int n = 1;
        for (int i = 1; i < stringArray.length; ++i) {
            Matcher matcher;
            String string3 = COLUMN_TAIL_PATTERN.matcher(stringArray[i]).replaceAll("");
            if (string3.contains("<String>")) {
                string3 = string3.replaceAll("<requestedProperties>[\\s]*<String>(.*)</String>[\\s]*<", "<requestedProperties>$1<");
            }
            if ((matcher = SORT_PATTERN.matcher(string3 = (matcher = PROP_PATTERN.matcher(string3)).find() && "name".equals(matcher.group(1)) ? string3.replace("<requestedProperties>name</requestedProperties>", "<requestedProperties>id</requestedProperties>\n<requestedProperties>primaryIconId</requestedProperties>\n<requestedProperties>name</requestedProperties>\n<requestedProperties>labelIds</requestedProperties>\n<columnRenderer>object-name</columnRenderer>") : string3.replace("</requestedProperties>", "</requestedProperties>\n<columnRenderer>text</columnRenderer>"))).find() && "name".equals(matcher.group(1))) {
                string3 = string3 + "\n<width>250</width>";
                string3 = string3 + "\n<sortedByDefault>true</sortedByDefault>";
            }
            string3 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<object>" + string3 + "\n</object>";
            String string4 = string2 + '_' + n++;
            arrayList.add((Pair<String, String>)new Pair((Object)string4, (Object)string3));
        }
        return arrayList;
    }

    private String[] getTagValues(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string2 = XMLUtil.getTagValue((Element)element2);
            if (string2 == null) continue;
            arrayList.add(string2);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[0]);
    }

    private Set<String> getPrecedingExtensions(Element element) {
        NodeList nodeList = element.getElementsByTagName("precedingExtension");
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = XMLUtil.getTagValue((Element)element2);
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private List<TemplateInfo> getTemplateInfos(Element element, IdVersionPair idVersionPair) throws IOException {
        List list = XMLUtil.getChildTags((Node)element, (String)"template");
        ArrayList<TemplateInfo> arrayList = new ArrayList<TemplateInfo>(list.size());
        for (Element element2 : list) {
            String string = XMLUtil.getAttribute((Element)element2, (String)"id");
            if (string == null) {
                throw new IOException("The template tag should specify a template id.");
            }
            String string2 = XMLUtil.getChildTagValue((Node)element2, (String)"inheritedTemplate");
            String string3 = XMLUtil.xmlToString((Node)element2);
            TemplateVariableInfo[] templateVariableInfoArray = this.getTemplateVariableInfos(element2);
            TemplateInfo templateInfo = new TemplateInfo();
            templateInfo.setId(string);
            templateInfo.setInheritedTemplateId(string2);
            templateInfo.setPluginRef(idVersionPair);
            templateInfo.setVariableInfos(templateVariableInfoArray);
            templateInfo.setTemplateXmlStr(string3);
            arrayList.add(templateInfo);
        }
        return arrayList;
    }

    private List<TemplateInstanceInfo> getTemplateInstanceInfos(Element element, IdVersionPair idVersionPair) throws IOException {
        List list = XMLUtil.getChildTags((Node)element, (String)"templateInstance");
        ArrayList<TemplateInstanceInfo> arrayList = new ArrayList<TemplateInstanceInfo>(list.size());
        for (Element element2 : list) {
            String string = XMLUtil.getAttribute((Element)element2, (String)"id");
            if (string == null) {
                throw new IOException("The templateInstance tag should specify an id attribute.");
            }
            String string2 = XMLUtil.getChildTagValue((Node)element2, (String)"templateId");
            if (string2 == null) {
                throw new IOException("The templateInstance tag should specify a templateId child node.");
            }
            Pair<String, String>[] pairArray = this.getTemplateInstanceVariables(element2);
            String[] stringArray = this.getTagValues(element2, "excludedExtension");
            TemplateInstanceInfo templateInstanceInfo = new TemplateInstanceInfo();
            templateInstanceInfo.setId(string);
            templateInstanceInfo.setTemplateId(string2);
            templateInstanceInfo.setPluginRef(idVersionPair);
            templateInstanceInfo.setVariableNameValues(pairArray);
            templateInstanceInfo.setExcludedExtensionIds(stringArray);
            arrayList.add(templateInstanceInfo);
        }
        return arrayList;
    }

    private List<String> getExportedClasses(Element element) {
        Element element2 = XMLUtil.getChildTag((Node)element, (String)"export");
        if (element2 == null) {
            return Collections.emptyList();
        }
        NodeList nodeList = element.getElementsByTagName("class");
        int n = nodeList.getLength();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Element element3 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttribute((Element)element3, (String)"name");
            arrayList.add(string);
        }
        return arrayList;
    }

    private PluginDependency[] getDependencies(Element element) throws IOException {
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getElementsByTagName("dependency");
        int n = nodeList.getLength();
        ArrayList<PluginDependency> arrayList = new ArrayList<PluginDependency>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttribute((Element)element2, (String)"type");
            String string2 = XMLUtil.getAttribute((Element)element2, (String)"uri");
            if (string == null || string2 == null) {
                throw new IOException("The dependency tag should specify a type and uri attributes.");
            }
            PluginDependency pluginDependency = new PluginDependency(string, string2);
            arrayList.add(pluginDependency);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new PluginDependency[0]);
    }

    private TemplateVariableInfo[] getTemplateVariableInfos(Element element) throws IOException {
        NodeList nodeList = element.getElementsByTagName("variable");
        int n = nodeList.getLength();
        ArrayList<TemplateVariableInfo> arrayList = new ArrayList<TemplateVariableInfo>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttribute((Element)element2, (String)"name");
            if (string == null) {
                throw new IOException("The variable tag should specify a name attribute.");
            }
            boolean bl = XMLUtil.getBooleanAttribute((Element)element2, (String)"required", (boolean)true);
            String string2 = XMLUtil.getAttribute((Element)element2, (String)"defaultValue");
            TemplateVariableInfo templateVariableInfo = new TemplateVariableInfo(string);
            templateVariableInfo.setRequired(bl);
            templateVariableInfo.setDefaultValue(string2);
            arrayList.add(templateVariableInfo);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new TemplateVariableInfo[0]);
    }

    private Pair<String, String>[] getTemplateInstanceVariables(Element element) throws IOException {
        NodeList nodeList = element.getElementsByTagName("variable");
        int n = nodeList.getLength();
        ArrayList<Pair> arrayList = new ArrayList<Pair>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttribute((Element)element2, (String)"name");
            if (string == null) {
                throw new IOException("The variable tag should specify a name attribute.");
            }
            String string2 = XMLUtil.getAttribute((Element)element2, (String)"value");
            Pair pair = new Pair((Object)string, (Object)string2);
            arrayList.add(pair);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new Pair[0]);
    }
}

