/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.BundleInfo;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.extensionfw.impl.PackageDeployData;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.IdentityHashSet;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PluginMetadataLookup {
    private static final char DIRECTIVE_DELIMITER = ';';
    private static final String MANIFEST_DELIMITER = ",";
    private static final String REGEX_PACKAGE_USES = "^uses\\s*:\\s*=.*$";
    private static final Log _logger = LogFactory.getLog(PluginMetadataLookup.class);
    private final Set<IdVersionPair> _deployedPluginIds;
    private final Map<IdVersionPair, PluginPackageInfo> _pluginInfos = new HashMap<IdVersionPair, PluginPackageInfo>();
    private final Map<IdVersionPair, List<BundleInfo>> _bundlesPerPlugin = new HashMap<IdVersionPair, List<BundleInfo>>();
    private final Map<String, Map<IdVersionPair, IdVersionPair>> _packageExporters = new HashMap<String, Map<IdVersionPair, IdVersionPair>>();
    private final Map<IdVersionPair, List<String>> _nestedLibs = new HashMap<IdVersionPair, List<String>>();
    private final Map<IdVersionPair, List<String>> _exportedPackagesByPlugin = new HashMap<IdVersionPair, List<String>>();
    private final Map<IdVersionPair, List<String>> _exportedPackagesByBundle = new HashMap<IdVersionPair, List<String>>();
    private final Map<IdVersionPair, List<String>> _importedPackagesByPlugin = new HashMap<IdVersionPair, List<String>>();
    private final Map<IdVersionPair, List<String>> _importedPackagesByBundle = new HashMap<IdVersionPair, List<String>>();

    public PluginMetadataLookup(Collection<PackageDeployData> collection) {
        this._deployedPluginIds = this.extractPluginIds(collection);
        ValidationUtil.paramsNotNull((Object[])new Object[]{collection});
        IdentityHashSet identityHashSet = new IdentityHashSet();
        identityHashSet.addAll(collection);
        for (PackageDeployData packageDeployData : identityHashSet) {
            ValidationUtil.paramsNotNull((Object[])new Object[]{packageDeployData});
            IdVersionPair idVersionPair = packageDeployData.getPackageRef();
            PluginPackageInfo pluginPackageInfo = packageDeployData.getPackageInfo();
            List<BundleInfo> list = packageDeployData.getBundlesInfo();
            ValidationUtil.paramsNotNull((Object[])new Object[]{idVersionPair, pluginPackageInfo, list});
            if (this._pluginInfos.containsKey(idVersionPair) || this._bundlesPerPlugin.containsKey(idVersionPair)) {
                _logger.warn((Object)("Plugin " + idVersionPair + " skipped. " + "The lookup already contains a package with this ID."));
                continue;
            }
            this._pluginInfos.put(idVersionPair, pluginPackageInfo);
            this._bundlesPerPlugin.put(idVersionPair, list);
        }
    }

    private Set<IdVersionPair> extractPluginIds(Collection<PackageDeployData> collection) {
        HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>();
        for (PackageDeployData packageDeployData : collection) {
            hashSet.add(packageDeployData.getPackageRef());
        }
        return hashSet;
    }

    public final String getPluginName(IdVersionPair idVersionPair) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{idVersionPair});
        PluginPackageInfo pluginPackageInfo = this._pluginInfos.get(idVersionPair);
        return pluginPackageInfo == null ? "null" : pluginPackageInfo.getName();
    }

    public final String getPluginVendor(IdVersionPair idVersionPair) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{idVersionPair});
        PluginPackageInfo pluginPackageInfo = this._pluginInfos.get(idVersionPair);
        return pluginPackageInfo == null ? "null" : pluginPackageInfo.getVendor();
    }

    public final boolean isPluginDeployed(IdVersionPair idVersionPair) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{idVersionPair});
        return this._deployedPluginIds.contains(idVersionPair);
    }

    public final List<BundleInfo> getBundles(IdVersionPair idVersionPair) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{idVersionPair});
        ArrayList arrayList = this._bundlesPerPlugin.get(idVersionPair);
        if (this._pluginInfos.containsKey(idVersionPair) && arrayList == null) {
            _logger.warn((Object)("Plugin " + idVersionPair + " is a known plugin package but contains no bundle info."));
        }
        return arrayList == null ? new ArrayList(0) : arrayList;
    }

    public final List<String> exportedPackagesByBundle(BundleInfo bundleInfo, boolean bl) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{bundleInfo});
        IdVersionPair idVersionPair = bundleInfo.getBundleRef();
        if (!this._exportedPackagesByBundle.containsKey(idVersionPair)) {
            this._exportedPackagesByBundle.put(idVersionPair, PluginMetadataLookup.splitPackageList(bundleInfo.getExportPackage()));
        }
        List<String> list = this._exportedPackagesByBundle.get(idVersionPair);
        if (bl) {
            return PluginMetadataLookup.stripPackageDirectives(list);
        }
        return list;
    }

    public final List<String> exportedPackagesByPluginPackage(IdVersionPair idVersionPair) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{idVersionPair});
        if (!this._exportedPackagesByPlugin.containsKey(idVersionPair)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (BundleInfo bundleInfo : this.getBundles(idVersionPair)) {
                for (String string : this.exportedPackagesByBundle(bundleInfo, false)) {
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
            }
            this._exportedPackagesByPlugin.put(idVersionPair, arrayList);
        }
        return this._exportedPackagesByPlugin.get(idVersionPair);
    }

    public final List<String> importedPackagesByBundle(BundleInfo bundleInfo, boolean bl) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{bundleInfo});
        IdVersionPair idVersionPair = bundleInfo.getBundleRef();
        if (!this._importedPackagesByBundle.containsKey(idVersionPair)) {
            this._importedPackagesByBundle.put(idVersionPair, PluginMetadataLookup.splitPackageList(bundleInfo.getImportPackage()));
        }
        List<String> list = this._importedPackagesByBundle.get(idVersionPair);
        if (bl) {
            return PluginMetadataLookup.stripPackageDirectives(list);
        }
        return list;
    }

    public final List<String> importedPackagesByPluginPackage(IdVersionPair idVersionPair) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{idVersionPair});
        if (!this._importedPackagesByPlugin.containsKey(idVersionPair)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (BundleInfo bundleInfo : this.getBundles(idVersionPair)) {
                for (String string : this.importedPackagesByBundle(bundleInfo, false)) {
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
            }
            this._importedPackagesByPlugin.put(idVersionPair, arrayList);
        }
        return this._importedPackagesByPlugin.get(idVersionPair);
    }

    public final List<String> nestedLibrariesByBundle(BundleInfo bundleInfo) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{bundleInfo});
        IdVersionPair idVersionPair = bundleInfo.getBundleRef();
        ValidationUtil.paramsNotNull((Object[])new Object[]{idVersionPair});
        if (!this._nestedLibs.containsKey(idVersionPair)) {
            String string = bundleInfo.getBundleClasspath();
            if (!StringUtil.isNullOrEmpty((String)string)) {
                String[] stringArray = StringUtil.splitAndTrim((String)string, (String)MANIFEST_DELIMITER);
                this._nestedLibs.put(idVersionPair, Arrays.asList(stringArray));
            } else {
                this._nestedLibs.put(idVersionPair, new ArrayList(0));
            }
        }
        return this._nestedLibs.get(idVersionPair);
    }

    public final Map<IdVersionPair, IdVersionPair> bundlesByExportedPackage(String string) {
        Map<Object, Object> map;
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        if (!this._packageExporters.containsKey(string)) {
            map = new HashMap();
            for (IdVersionPair idVersionPair : this._pluginInfos.keySet()) {
                block1: for (BundleInfo bundleInfo : this.getBundles(idVersionPair)) {
                    List<String> list = this.exportedPackagesByBundle(bundleInfo, false);
                    for (String string2 : list) {
                        String string3 = string2.split(";")[0];
                        if (!string.equals(string2) && !string.equals(string3)) continue;
                        if (map.containsKey(bundleInfo.getBundleRef())) continue block1;
                        map.put(bundleInfo.getBundleRef(), idVersionPair);
                        continue block1;
                    }
                }
            }
            this._packageExporters.put(string, map);
        }
        return (map = this._packageExporters.get(string)) == null ? new HashMap() : map;
    }

    protected static List<String> splitPackageList(String string) {
        if (string == null) {
            return Collections.emptyList();
        }
        String string2 = string + MANIFEST_DELIMITER;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < string2.length(); ++i) {
            String string3;
            if (string2.charAt(i) == '\"') {
                bl = !bl;
                continue;
            }
            if (string2.charAt(i) != ',' || bl || (string3 = string2.substring(n, i).trim()).isEmpty()) continue;
            arrayList.add(PluginMetadataLookup.stripUsesDirective(string3));
            n = i + 1;
        }
        return arrayList;
    }

    protected static String stripUsesDirective(String string) {
        String[] stringArray = string.split(";");
        if (stringArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[0].trim());
        for (int i = 1; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            if (string2.matches(REGEX_PACKAGE_USES)) continue;
            stringBuilder.append(';').append(string2);
        }
        return stringBuilder.toString();
    }

    protected static List<String> stripPackageDirectives(List<String> list) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{list});
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(PluginMetadataLookup.stripPackageDirectives(string));
        }
        return arrayList;
    }

    protected static String stripPackageDirectives(String string) {
        int n = string.indexOf(59);
        String string2 = n == -1 ? string : string.substring(0, n);
        return string2.trim();
    }
}

