/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.impl.TemplateInfo;
import com.vmware.vise.extensionfw.impl.TemplateVariableInfo;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.XMLUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TemplateMerger {
    private static final Log _logger = LogFactory.getLog(TemplateMerger.class);
    private Map<String, TemplateInfo> _templateById;

    public TemplateMerger(Map<String, TemplateInfo> map) {
        this._templateById = map;
    }

    public TemplateInfo getMergedTemplateInfo(TemplateInfo templateInfo) {
        String string;
        List<TemplateInfo> list = this.getInheritedTemplateInfos(templateInfo);
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return templateInfo;
        }
        list.add(templateInfo);
        HashMap<String, TemplateVariableInfo> hashMap = new HashMap<String, TemplateVariableInfo>();
        Element element = null;
        for (TemplateInfo templateVariableInfoArray2 : list) {
            Element element2 = XMLUtil.parseXml((String)templateVariableInfoArray2.getTemplateXmlStr()).getDocumentElement();
            if (element == null) {
                element = element2;
            } else {
                XMLUtil.addChildTags((Node)element2, (Node)element);
            }
            this.addVariables(templateVariableInfoArray2, hashMap);
        }
        templateInfo = (TemplateInfo)templateInfo.clone();
        try {
            string = XMLUtil.xmlToString(element);
        }
        catch (IOException iOException) {
            _logger.error((Object)iOException);
            return null;
        }
        templateInfo.setTemplateXmlStr(string);
        TemplateVariableInfo[] templateVariableInfoArray = hashMap.values().toArray(new TemplateVariableInfo[0]);
        templateInfo.setVariableInfos(templateVariableInfoArray);
        return templateInfo;
    }

    private List<TemplateInfo> getInheritedTemplateInfos(TemplateInfo templateInfo) {
        ArrayList<TemplateInfo> arrayList = new ArrayList<TemplateInfo>();
        String string = templateInfo.getInheritedTemplateId();
        if (StringUtil.isNullOrEmpty((String)string)) {
            return arrayList;
        }
        TemplateInfo templateInfo2 = this._templateById.get(string);
        if (templateInfo2 == null) {
            _logger.error((Object)("The template '" + string + "' inherited by " + "the template '" + templateInfo.getId() + "' could not be found."));
            return null;
        }
        arrayList.add(0, templateInfo2);
        return arrayList;
    }

    private void addVariables(TemplateInfo templateInfo, Map<String, TemplateVariableInfo> map) {
        TemplateVariableInfo[] templateVariableInfoArray = templateInfo.getVariableInfos();
        if (templateVariableInfoArray == null) {
            return;
        }
        for (TemplateVariableInfo templateVariableInfo : templateVariableInfoArray) {
            map.put(templateVariableInfo.getName(), templateVariableInfo);
        }
    }
}

