/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl.validation;

import com.vmware.vise.extensionfw.BundleInfo;
import com.vmware.vise.extensionfw.OsgiUsageValidationListener;
import com.vmware.vise.extensionfw.OsgiWarningInfo;
import com.vmware.vise.extensionfw.impl.PluginMetadataLookup;
import com.vmware.vise.extensionfw.impl.validation.OsgiUsageValidationCheckBase;
import com.vmware.vise.extensionfw.impl.validation.OsgiValidationUtils;
import com.vmware.vise.util.IdVersionPair;
import java.util.ArrayList;
import java.util.List;

public class VmwareNameMisuseCheck
extends OsgiUsageValidationCheckBase {
    private static final String VMWARE_COMPANY_NAME = "vmware";
    private static final String VMWARE_REVERSE_COMPANY_NAME = "com.vmware";
    private static final String DESCRIPTION = "Don't use 'com.vmware' prefix for bundle symbolic names and packages";

    @Override
    public void validate(IdVersionPair idVersionPair, PluginMetadataLookup pluginMetadataLookup, OsgiUsageValidationListener osgiUsageValidationListener) {
        List<BundleInfo> list = pluginMetadataLookup.getBundles(idVersionPair);
        for (BundleInfo bundleInfo : list) {
            Object object;
            String string = bundleInfo.getId();
            if (string == null) continue;
            String string2 = OsgiValidationUtils.companyPrefix(string);
            String string3 = bundleInfo.getBundleVendor();
            if (string3 == null || string3.toLowerCase().contains(VMWARE_COMPANY_NAME)) continue;
            if (string2.equals(VMWARE_REVERSE_COMPANY_NAME)) {
                object = new OsgiWarningInfo(idVersionPair, DESCRIPTION, OsgiWarningInfo.ObjectType.BUNDLE, string, OsgiWarningInfo.ObjectType.BUNDLE, string3);
                this.logWarning((OsgiWarningInfo)object, "Bundle vendor", osgiUsageValidationListener);
            }
            object = pluginMetadataLookup.exportedPackagesByBundle(bundleInfo, false);
            ArrayList<String> arrayList = new ArrayList<String>();
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                String string4 = (String)object2.next();
                if (!string4.startsWith(VMWARE_REVERSE_COMPANY_NAME)) continue;
                arrayList.add(string4);
            }
            if (arrayList.isEmpty()) continue;
            object2 = new OsgiWarningInfo(idVersionPair, DESCRIPTION, OsgiWarningInfo.ObjectType.BUNDLE, string, OsgiWarningInfo.ObjectType.PACKAGE, OsgiValidationUtils.formatList(arrayList));
            this.logWarning((OsgiWarningInfo)object2, "Misnamed exported packages", osgiUsageValidationListener);
        }
    }
}

